/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DB0Handle {
    private final InfinityDbHandle dbh;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final File db0File;

    public DB0Handle(File db0File) throws IOException {
        this.db0File = db0File;
        this.dbh = DB0EAV.open(db0File);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T read(ReaderE<T, E> reader) throws E, DbException {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            T t2 = reader.read(this.dbh);
            return t2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T write(WriterE<T, E> writer) throws E, DbException {
        ReentrantReadWriteLock.WriteLock writeLock = this.takeWriteLock();
        try {
            T t2 = writer.write(this.dbh);
            return t2;
        }
        finally {
            writeLock.unlock();
        }
    }

    private ReentrantReadWriteLock.WriteLock takeWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        return writeLock;
    }

    public <T> T read(final Reader<T> reader) throws DbException {
        return this.read(new ReaderE<T, RuntimeException>(){

            @Override
            public T read(InfinityDbHandle db) throws DbException, RuntimeException {
                return reader.read(db);
            }
        });
    }

    public <T> T write(final Writer<T> writer) throws DbException {
        return this.write(new WriterE<T, RuntimeException>(){

            @Override
            public T write(InfinityDbHandle db) throws DbException, RuntimeException {
                return writer.write(db);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T withClosedDb(WhileClosedE<T, E> whileClosed) throws IOException, E {
        ReentrantReadWriteLock.WriteLock writeLock = this.takeWriteLock();
        try {
            this.dbh.close();
            T t2 = whileClosed.whileClosed(this.db0File);
            return t2;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void close() throws IOException {
        this.withClosedDb(new WhileClosedE<Void, RuntimeException>(){

            @Override
            public Void whileClosed(File dbFile) throws RuntimeException {
                return null;
            }
        });
    }

    public boolean isOpen() {
        return this.dbh.isOpen();
    }

    public Exception getOpenTrace() {
        return this.dbh == null ? null : this.dbh.getOpenTrace();
    }

    public static interface Writer<T> {
        public T write(InfinityDbHandle var1) throws DbException;
    }

    public static interface Reader<T> {
        public T read(InfinityDbHandle var1) throws DbException;
    }

    public static interface WhileClosedE<T, E extends Throwable> {
        public T whileClosed(File var1) throws E;
    }

    public static interface WriterE<T, E extends Throwable> {
        public T write(InfinityDbHandle var1) throws DbException, E;
    }

    public static interface ReaderE<T, E extends Throwable> {
        public T read(InfinityDbHandle var1) throws DbException, E;
    }
}

