/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.ap;
import com.cenqua.obfuscate.idb.y;
import java.io.File;
import java.io.IOException;

public class DB0EAV {
    public static final ap SCHEMA = new ap(y.a());
    public static final I DBVERSION = new I(1L);
    public static final int CURRENT_DBVERSION = 2;
    public static final I CONSTANTS = new I(50L);
    public static final I FEUSER = new I(100L);
    public static final I INDEX_EMAIL_TO_FEUSER = new I(101L);
    public static final I PERSISTENT_LOGIN = new I(102L);
    public static final I FEGROUP = new I(103L);
    public static final I WATCH = new I(200L);
    public static final I INDEX_REP_TO_WATCH = new I(201L);
    public static final I INDEX_USER_TO_WATCH = new I(202L);
    public static final I COMMIT_NOTIFICATION = new I(300L);

    public static InfinityDbHandle open(File file) throws IOException {
        boolean newlyCreated = InfinityDbUtil.createIfNeccessary(file);
        InfinityDbHandle handle = new InfinityDbHandle(file);
        if (newlyCreated) {
            DB0EAV.initialSetup(handle);
        } else {
            DB0EAV.upgradeSchema(handle);
        }
        return handle;
    }

    private static void upgradeSchema(InfinityDbHandle db) throws IOException {
        y cu = y.a();
        while (true) {
            cu.f();
            cu.a(DBVERSION);
            int pl = cu.e();
            if (!db.get().b(cu, pl)) {
                throw new IOException("could not determine current version of db0 schema");
            }
            int dbVersion = (int)cu.v(pl);
            if (dbVersion > 2) {
                throw new IOException("db version is more recent that what we support " + dbVersion);
            }
            if (dbVersion == 2) break;
            DB0EAV.upgradeSchemaFrom(db, dbVersion);
        }
    }

    private static void upgradeSchemaFrom(InfinityDbHandle db, int dbVersion) throws IOException {
        if (dbVersion != 1) {
            throw new IOException("cannot upgrade from schema " + dbVersion);
        }
        DB0EAV.upgrade1to2(db.get());
        int nextVersion = 2;
        y cu = y.a().a(DBVERSION);
        int pl = cu.e();
        cu.b((long)nextVersion);
        db.get().e(cu, pl);
        db.commit();
        Logs.APP_LOG.info((Object)"upgrade done");
    }

    private static void upgrade1to2(ac db) throws IOException {
        Logs.APP_LOG.info((Object)"upgrading db0 from schema 1 to 2");
        y cu = y.a();
        while (db.d(cu)) {
            if (cu.f(0) != 2) continue;
            db.c(cu);
        }
    }

    private static void initialSetup(InfinityDbHandle db) throws IOException {
        y cu = y.a();
        cu.a(DBVERSION).b(2L);
        db.get().b(cu);
        db.commit();
    }
}

