/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.GroupType;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class ConfigUtil {
    public static String getDefaultTimezone() {
        TimeZone timezone = AppConfig.getsConfig().getTimezone();
        return timezone != null ? timezone.getID() : null;
    }

    public static GroupType[] createGroupArray(Iterable<String> groups) {
        ArrayList<GroupType> groupTypes = new ArrayList<GroupType>();
        for (String group : groups) {
            GroupType groupType = GroupType.Factory.newInstance();
            groupType.setName(group);
            groupTypes.add(groupType);
        }
        return groupTypes.toArray(new GroupType[groupTypes.size()]);
    }

    @Nonnull
    public static ImmutableSet<String> getGroupNames(GroupListType groupList) {
        ImmutableSet.Builder groupsBuilder = ImmutableSet.builder();
        if (groupList != null && groupList.getGroupArray() != null) {
            for (GroupType group : groupList.getGroupArray()) {
                groupsBuilder.add((Object)group.getName());
            }
        }
        return groupsBuilder.build();
    }
}

