/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.fisheye.web.NetworkLocation;
import com.cenqua.fisheye.logging.Logs;

public final class Bind {
    private final String host;
    private final int port;

    private Bind(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static Bind parse(String bindText, String defaultHost, int defaultPort) {
        String host = defaultHost;
        int port = defaultPort;
        try {
            NetworkLocation bind = new NetworkLocation(bindText);
            if (!bind.isWildcard()) {
                host = bind.getHost();
            }
            port = bind.getPort();
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"problem parsing our own bind address", (Throwable)e2);
        }
        return new Bind(host, port);
    }
}

