/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.IncludeTree;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.AntGlob;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AllowRules {
    private final List<IncludeTree> allowDirs;
    private final List<AntGlob> disallowPatterns;

    public AllowRules(List<IncludeTree> allowDirs, List<AntGlob> dissallowPatterns) {
        this.allowDirs = allowDirs;
        this.disallowPatterns = dissallowPatterns;
    }

    public List<IncludeTree> getIncludes() {
        return Collections.unmodifiableList(this.allowDirs);
    }

    public boolean isIgnored(Path path) {
        if (!this.allowDirs.isEmpty()) {
            boolean included = false;
            Iterator<IncludeTree> i2 = this.allowDirs.iterator();
            while (!included && i2.hasNext()) {
                IncludeTree allowDir = i2.next();
                included = allowDir.isInTree(path);
            }
            if (!included) {
                return true;
            }
        }
        if (this.disallowPatterns.isEmpty()) {
            return false;
        }
        String s2 = "/" + path.toString();
        for (AntGlob disallowPattern : this.disallowPatterns) {
            if (!disallowPattern.matches(s2)) continue;
            if (Logs.isDebugMode()) {
                Logs.APP_LOG.debug((Object)("Excluding path '" + s2 + "' by pattern: " + disallowPattern));
            }
            return true;
        }
        return false;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (!caseSensitive) {
            for (IncludeTree includeTree : this.allowDirs) {
                includeTree.setCaseSensitive(false);
            }
            for (AntGlob glob : this.disallowPatterns) {
                glob.setCaseSensitive(false);
            }
        }
    }

    public List<AntGlob> getExcludes() {
        return this.disallowPatterns;
    }
}

