/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.security.password.DefaultPasswordEncoder;
import com.atlassian.security.password.PasswordEncoder;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.MD5;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AdminConfig {
    private final RootConfig rootConfig;
    private final PasswordEncoder encoder;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    protected AdminConfig(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
        this.encoder = DefaultPasswordEncoder.getDefaultInstance();
        Preconditions.checkArgument((boolean)this.encoder.canDecodePassword("{PKCS5S2}"), (Object)"AdminConfig requires encoder with PKCS5S2 support");
    }

    public boolean haveDoneInitialSetup() {
        this.readLock.lock();
        try {
            boolean bl = this.rootConfig.getConfig().isSetAdminHash();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isAdminEnabled() {
        this.readLock.lock();
        try {
            boolean bl = this.rootConfig.getConfig().isSetAdminHash() && this.rootConfig.getConfig().getAdminHash().length() != 0;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setAdminPassword(String password) {
        this.writeLock.lock();
        try {
            if (password == null) {
                if (this.rootConfig.getConfig().isSetAdminHash()) {
                    this.rootConfig.getConfig().unsetAdminHash();
                }
            } else if (password.length() == 0) {
                this.rootConfig.getConfig().setAdminHash("");
            } else {
                String adminHash = this.encoder.encodePassword(password);
                this.rootConfig.getConfig().setAdminHash(adminHash);
            }
            try {
                this.rootConfig.saveConfig();
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)"AdminConfig: failed to save configuration file after setting the password");
                Throwables.propagate((Throwable)e2);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeAdminPassword(String oldPassword, String newPassword) {
        this.writeLock.lock();
        try {
            String adminHash = this.rootConfig.getConfig().getAdminHash();
            if (this.compareAdminPassword(adminHash, oldPassword)) {
                this.setAdminPassword(newPassword);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyAdminPassword(String password) {
        this.readLock.lock();
        boolean shouldUpdatePassword = false;
        try {
            String adminHash = this.rootConfig.getConfig().getAdminHash();
            if (this.compareAdminPassword(adminHash, password)) {
                if (this.hashNeedsUpgrade(adminHash)) {
                    shouldUpdatePassword = true;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
            if (shouldUpdatePassword) {
                this.updateHashIfNeeded(password);
            }
        }
    }

    private void updateHashIfNeeded(String password) {
        this.writeLock.lock();
        try {
            if (this.hashNeedsUpgrade(this.rootConfig.getConfig().getAdminHash())) {
                this.setAdminPassword(password);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean hashNeedsUpgrade(String hash) {
        return this.getHashType(hash).equals((Object)HashType.MD5);
    }

    private HashType getHashType(String hash) {
        if (hash == null || hash.isEmpty()) {
            return HashType.EMPTY;
        }
        if (this.encoder.canDecodePassword(hash)) {
            return HashType.SALT_PKCS5S2;
        }
        return HashType.MD5;
    }

    private boolean compareAdminPassword(String adminHash, String password) {
        switch (this.getHashType(adminHash)) {
            case MD5: {
                return MD5.hash(password).equalsIgnoreCase(adminHash);
            }
            case SALT_PKCS5S2: {
                return this.encoder.isValidPassword(password, adminHash);
            }
        }
        return false;
    }

    public static enum HashType {
        EMPTY,
        MD5,
        SALT_PKCS5S2;

    }
}

