/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cache;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class RevisionCacheProperties {
    public static final long SERIAL_DEFAULT = 1L;
    private static final String VERSION_KEY = "version";
    private static final String SERIAL_KEY = "serial";
    private final Properties props;
    private final File propsFile;

    public static RevisionCacheProperties createNew(File file, int version) throws IOException {
        return new RevisionCacheProperties(file, version);
    }

    public static RevisionCacheProperties readExisting(File file) throws IOException {
        return new RevisionCacheProperties(file);
    }

    private RevisionCacheProperties(File file, int version) throws IOException {
        this.propsFile = file;
        this.props = new Properties();
        this.setVersion(version);
        this.setSerial(RevisionCacheProperties.makeNewSerial());
        this.store();
    }

    public void store() throws IOException {
        FileOutputStream out = new FileOutputStream(this.propsFile);
        try {
            this.props.store(out, null);
        }
        catch (Throwable throwable) {
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close(out);
    }

    private RevisionCacheProperties(File file) throws IOException {
        this.propsFile = file;
        this.props = new Properties();
        FileInputStream in = new FileInputStream(file);
        try {
            this.props.load(in);
        }
        catch (Throwable throwable) {
            IOHelper.close(in);
            throw throwable;
        }
        IOHelper.close(in);
    }

    public int getVersion() {
        String version = this.props.getProperty(VERSION_KEY);
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.info((Object)("Current cache version '" + version + "' is not a number, treating it as version 1 to trigger an upgrade"));
            return 1;
        }
    }

    public long getSerial() {
        String s2 = this.props.getProperty(SERIAL_KEY);
        if (s2 == null) {
            return 1L;
        }
        try {
            return Long.parseLong(s2);
        }
        catch (NumberFormatException e2) {
            return 1L;
        }
    }

    private static long makeNewSerial() {
        return System.currentTimeMillis();
    }

    public void setVersion(int version) {
        this.props.setProperty(VERSION_KEY, Integer.toString(version));
    }

    public void setSerial(long serial) {
        this.props.setProperty(SERIAL_KEY, Long.toString(serial));
    }
}

