/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cache;

import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionIdentifier;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangesetRevision;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.ChangeSetService;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public interface RevisionCache<C extends ChangeSet>
extends ChangeSetService<C> {
    public String getRepositoryName();

    public Map<Path, Integer> findPathRoots(Set<Path> var1, EggTimer var2) throws IOException, DbException;

    public void visitChangesetIds(int var1, UniqueStringTable.Visitor var2) throws DbException;

    public void visitRevisions(Iterable<Integer> var1, Visitor<FileRevision> var2) throws DbException;

    @Nullable
    public String getDefaultBranch();

    public boolean isLocEnabled();

    public boolean isStoreDiffs();

    public void addListener(CacheListener var1);

    public Path[] listFiles(Path var1) throws DbException;

    public Path[] listDirs(Path var1) throws DbException;

    public boolean isFile(Path var1) throws DbException;

    public boolean isDir(Path var1) throws DbException;

    public boolean isEmptyOfFiles(Path var1, String var2, String var3) throws DbException;

    public void getTextRevision(RevInfoKey var1, OutputStream var2, String var3, String var4) throws IOException, DbException;

    public StreamIndexedLineReader getUnicodeTextRevision(FileRevision var1, String var2, String var3) throws IOException, DbException;

    public File getBinaryRevision(RevInfoKey var1) throws IOException, DbException;

    public void getBinaryRevision(RevInfoKey var1, OutputStream var2) throws IOException, DbException;

    public Charset getTextEncoding(RevInfoKey var1) throws DbException;

    public FileRevision getFileRevision(int var1) throws DbException;

    public FileRevision getFileRevision(RevInfoKey var1) throws DbException;

    public FileRevision getFileRevision(int var1, boolean var2) throws DbException;

    public FileRevision findFileRevision(Path var1, String var2) throws DbException;

    public FileRevision getFileRevisionAtBranch(Path var1, String var2);

    public FileRevision getFileRevisionAtTag(Path var1, String var2);

    public int getRevId(RevInfoKey var1) throws DbException;

    public boolean existsChangeSet(String var1) throws DbException;

    public long countChangeSets(Path var1, String var2) throws DbException;

    public long countChangeSets(ActivityItemSearchParams var1) throws DbException;

    public String getChangeSetId(int var1) throws DbException;

    public List<String> findRecentChangeSetIds(RecentChangesParams2 var1) throws DbException;

    public List<ChangeSet> findRecentChangeSets(RecentChangesParams2 var1) throws DbException;

    public FileRevision getLatestFileRevision(Path var1) throws DbException;

    public void visitHeadRevisionsInDirectory(Path var1, Visitor<FileRevision> var2) throws DbException;

    public void visitHeadRevisionsOnBranchInDirectory(Path var1, String var2, Visitor<FileRevision> var3) throws DbException;

    public void visitRevisionsAtBranchPoint(String var1, Visitor<FileRevision> var2) throws DbException;

    public void visitRevisionsForTagInDirectory(Path var1, String var2, Visitor<FileRevision> var3) throws DbException;

    public void visitHeadRevisionsAtPath(Path var1, Visitor<FileRevision> var2) throws DbException;

    public void visitHeadRevisionsOnBranchAtPath(Path var1, String var2, Visitor<FileRevision> var3) throws DbException;

    public void visitHeadRevisionsOnTagAtPath(Path var1, String var2, Visitor<FileRevision> var3) throws DbException;

    public List<Integer> getHeadRevisions(Path var1, boolean var2) throws DbException;

    public RevInfoKey searchAncestors(RevInfoKey var1, Predicate<RevInfoKey> var2) throws DbException;

    public FileHistory getFullFileHistory(Path var1, boolean var2) throws DbException;

    public Map<Path, String> resolveRevisionsForPatch(Map<Path, RevisionIdentifier> var1) throws DbException;

    public FileHistory getFileHistory(Path var1, boolean var2) throws DbException;

    public FileHistory getFullFileHistory(Path var1) throws DbException;

    public FileHistory getFileHistory(Path var1) throws DbException;

    public List<BlameChunk> getBlameSpans(RevInfoKey var1) throws DbException;

    public boolean hasBlameSpans(RevInfoKey var1);

    public void setBlameSpans(RevInfoKey var1, List<BlameChunk> var2) throws DbException;

    public Blame getBlame(RevInfoKey var1) throws DbException, IOException;

    public Optional<Blame> getBlame(RevInfoKey var1, boolean var2) throws DbException, IOException;

    public Blame getBlameFallback(RevInfoKey var1) throws DbException, IOException;

    public ScmType getRepositoryType();

    public long getLastModifiedDate() throws DbException;

    public long getCacheSerialNumber();

    public DirInfo findDirInfo(Path var1) throws DbException;

    public List<String> getSimilarChangeSetIds(String var1) throws DbException;

    public List<String> findSimilarPartialChangeSetIds(String var1) throws DbException;

    public Set<Branch> getBranches() throws DbException;

    public Branch getBranch(String var1) throws DbException;

    public List<String> findBranches(Path var1) throws DbException;

    public List<String> findAuthors(Path var1) throws DbException;

    public void visitAuthors(Path var1, StoppableVisitor<String> var2);

    public List<String> findAuthors(Path var1, String var2) throws DbException;

    public Map<String, ChangeSet> findLatestChangesByAuthor(Path var1, Collection<String> var2) throws DbException;

    public Map<String, ChangeSet> findEarliestChangesByAuthor(Path var1, Collection<String> var2) throws DbException;

    public ChangeSet findLatestChangesetForCommitter(String var1) throws DbException;

    public ChangeSet findEarliestChangesetForCommitter(String var1) throws DbException;

    public ChangeSet findLatestChangeset(Path var1) throws DbException;

    public String getImpliedBranch(Path var1);

    public int findLastSuccessor(int var1) throws DbException;

    public int findNextSuccessor(int var1) throws DbException;

    public Collection<String> findChangesetsWithLaterRevisions(RevInfoKey var1) throws DbException;

    public boolean isBefore(int var1, int var2) throws DbException;

    public boolean isAfter(int var1, int var2) throws DbException;

    public boolean isCaseSensitive();

    public boolean isAuthorLocEnabled();

    public List<Hunk> getHunks(RevInfoKey var1) throws DbException;

    public void setQuicksearchReslurped(boolean var1) throws DbException;

    public void setMetadataVersion(long var1) throws DbException;

    @Override
    public Set<String> getAllAuthors() throws DbException;

    public void touchLastModifiedDate() throws DbException;

    public long getScanProperty(String var1, long var2) throws DbException;

    public void setScanProperty(String var1, long var2) throws DbException;

    public String getAuthorOfRevision(int var1) throws DbException;

    public int getVersion();

    public boolean isInitialIndexingComplete() throws DbException;

    public boolean isInitialCrucibleIndexingComplete() throws DbException;

    public void markInitialCrucibleIndexingComplete();

    public List<ChangesetRevision> getChangesetRevisions(ChangeSet var1, List<FileRevision> var2);

    public long getSubBranchId(String var1) throws DbException;

    public FileRevision getHeadRevisionOnBranchAtPath(String var1, Path var2);

    public Set<String> getChangeSetAncestors(String var1, int var2, @Nullable Iterable<Branch> var3, @Nullable AtomicReference<String> var4);

    public static interface CacheListener
    extends EventListener {
        public void cacheUpdated();
    }
}

