/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cache;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Predicate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class RecentChangesParams2 {
    public static final int DEFAULT_MAX_RETURN = 30;
    public static final int SD_TOWARDS_PAST = 0;
    public static final int SD_TOWARDS_FUTURE = 1;
    private Path basePath = Path.ROOT;
    private Long minDate;
    private Long maxDate;
    private int maxReturn = 30;
    private int searchDirection = 0;
    private ChangeSet maxChangeset;
    private boolean maxChangesetInclusive;
    private ChangeSet minChangeset;
    private boolean minChangesetInclusive;
    private final Set<String> anyCommitters = new HashSet<String>();
    private final Set<Path> anyPaths = new HashSet<Path>();
    private boolean anyPathsContainsRoot = false;
    private WaybackSpec wbFilter = new WaybackSpec();
    private String p4JobFixed;

    public Path getBasePath() {
        return this.basePath;
    }

    public void setBasePath(Path path) {
        if (path == null) {
            path = Path.ROOT;
        }
        this.basePath = path;
    }

    public Long getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Long minDate) {
        this.minDate = minDate;
    }

    public Long getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Long maxDate) {
        this.maxDate = maxDate;
    }

    public int getMaxReturn() {
        return this.maxReturn;
    }

    public void setMaxReturn(int maxReturn) {
        this.maxReturn = maxReturn;
    }

    public ChangeSet getMaxChangeset() {
        return this.maxChangeset;
    }

    public void setMaxChangeset(ChangeSet maxChangeset, boolean inclusive) {
        this.maxChangeset = maxChangeset;
        this.maxChangesetInclusive = inclusive;
    }

    public boolean isMaxChangesetInclusive() {
        return this.maxChangesetInclusive;
    }

    public ChangeSet getMinChangeset() {
        return this.minChangeset;
    }

    @Nullable
    public Predicate<ChangeSet> getChangesetIncludePredicate() {
        if (this.getMaxChangeset() == null && this.getMinChangeset() == null) {
            return null;
        }
        return new Predicate<ChangeSet>(){

            public boolean apply(ChangeSet cs) {
                if (RecentChangesParams2.this.getMaxChangeset() != null && !RecentChangesParams2.checkBound(RecentChangesParams2.this.getMaxChangeset(), cs, RecentChangesParams2.this.isMaxChangesetInclusive(), true)) {
                    return false;
                }
                return RecentChangesParams2.this.getMinChangeset() == null || RecentChangesParams2.checkBound(RecentChangesParams2.this.getMinChangeset(), cs, RecentChangesParams2.this.isMinChangesetInclusive(), false);
            }
        };
    }

    private static boolean checkBound(ChangeSet bound, ChangeSet cs, boolean inclusive, boolean lt) {
        if (bound.getId().equals(cs.getId())) {
            return inclusive;
        }
        int datecmp = cs.dateCompare(bound);
        return lt ? datecmp < 0 : datecmp > 0;
    }

    public Date computeEffectiveMaxDate() {
        if (this.getMaxChangeset() != null) {
            long d2 = this.getMaxChangeset().getDate();
            return new Date(this.maxDate == null ? d2 : Math.min(this.maxDate, d2));
        }
        return this.maxDate == null ? null : new Date(this.maxDate);
    }

    public Date computeEffectiveMinDate() {
        if (this.getMinChangeset() != null) {
            long d2 = this.getMinChangeset().getDate();
            return new Date(this.minDate == null ? d2 : Math.max(this.minDate, d2));
        }
        return this.minDate == null ? null : new Date(this.minDate);
    }

    public void setMinChangeset(ChangeSet minChangeset, boolean inclusive) {
        this.minChangeset = minChangeset;
        this.minChangesetInclusive = inclusive;
    }

    public boolean isMinChangesetInclusive() {
        return this.minChangesetInclusive;
    }

    public int getSearchDirection() {
        return this.searchDirection;
    }

    public void setSearchDirection(int searchDirection) {
        this.searchDirection = searchDirection;
    }

    public void addAnyCommiter(String committer) {
        this.anyCommitters.add(committer);
    }

    public Set<String> getAnyCommitters() {
        return this.anyCommitters;
    }

    public void addAnyPath(Path path) {
        if (path.isRoot()) {
            this.anyPathsContainsRoot = true;
        }
        this.anyPaths.add(path);
    }

    public Set<Path> getAnyPaths() {
        return this.anyPaths;
    }

    public boolean isAnyPathsContainsRoot() {
        return this.anyPathsContainsRoot;
    }

    public String getCompulsoryCommitter() {
        return this.wbFilter.getAuthor();
    }

    public void setCompulsoryCommitter(String compulsoryCommitter) {
        this.wbFilter.setAuthor(compulsoryCommitter);
    }

    public String getBranch() {
        return this.wbFilter.getBranch();
    }

    public String getCommentSearchText() {
        return this.wbFilter.getCommentSearchText();
    }

    public void setCommentSearchText(String commentSearchText) {
        this.wbFilter.setCommentSearchText(commentSearchText);
    }

    public String getFileExtension() {
        return this.wbFilter.getFileExtension();
    }

    public String getFileName() {
        return this.wbFilter.getFileName();
    }

    public String getP4JobFixed() {
        return this.p4JobFixed;
    }

    public void setP4JobFixed(String p4JobFixed) {
        this.p4JobFixed = p4JobFixed;
    }

    public boolean isTowardsFuture() {
        return this.searchDirection == 1;
    }

    public String toString() {
        return "RecentChangesParams2{basePath=" + this.basePath + ", minDate=" + this.minDate + ", maxDate=" + this.maxDate + ", maxReturn=" + this.maxReturn + ", searchDirection=" + this.searchDirection + ", maxChangeset=" + this.maxChangeset + ", maxChangesetInclusive=" + this.maxChangesetInclusive + ", minChangeset=" + this.minChangeset + ", minChangesetInclusive=" + this.minChangesetInclusive + ", anyCommitters=" + this.anyCommitters + ", anyPaths=" + this.anyPaths + ", anyPathsContainsRoot=" + this.anyPathsContainsRoot + ", wbFilter='" + this.wbFilter.toString() + '\'' + ", p4JobFixed='" + this.p4JobFixed + '\'' + '}';
    }

    public void setWbFilter(WaybackSpec wbFilter) {
        this.wbFilter = wbFilter;
    }
}

