/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cache;

import com.atlassian.fecru.locks.PriorityLock;
import com.atlassian.fecru.locks.TwoLevelPriorityLock;
import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fecru.util.ListIterable;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.db.BranchDAO;
import com.atlassian.fisheye.db.CommonBranchDAO;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.atlassian.util.IndexingStats;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.csindex.RecentChangesSearcher2;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.DbTask;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.NotQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.Query3Params;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.io.Utf16ERandomAccessIoStream;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.ChangesetRevision;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.IndexingState;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.SyntheticBlameInfo;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.CommonUtilDAO;
import com.cenqua.fisheye.rep.impl.TagTreeVisitor;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class BaseRevisionCache<F extends FileRevision, C extends ChangeSetImpl<F>, T extends CommonStringTables>
implements InternalRevisionCache<C> {
    private final List<RevisionCache.CacheListener> listeners = new LinkedList<RevisionCache.CacheListener>();
    private final CommonUtilDAO utilDAO;
    private final RepositoryStatus status;
    private final long cacheSerialNumber;
    private final InfinityDbHandle dbh;
    private final T stringTables;
    private final LuceneConnection<LuceneIndexes> luceneConnection;
    private final LicenseEnforcer licenseEnforcer;
    private final IndexingContext indexingContext;
    private final RevisionCache.CacheListener eventMulticaster;
    private final BranchDAO branchDAO;
    private int version;
    private final IndexingStats indexingStats = new IndexingStats();
    private final PriorityLock writeLock = new TwoLevelPriorityLock();

    protected BaseRevisionCache(RepositoryStatus status, long cacheSerial, int version, InfinityDbHandle dbh, LuceneConnection<LuceneIndexes> luceneConnection, T stringTables, LicenseEnforcer licenseEnforcer, IndexingContext indexingContext) {
        this.status = status;
        this.cacheSerialNumber = cacheSerial;
        this.version = version;
        this.dbh = dbh;
        this.stringTables = stringTables;
        this.luceneConnection = luceneConnection;
        this.indexingContext = indexingContext;
        this.utilDAO = new CommonUtilDAO(dbh, (CommonStringTables)stringTables);
        this.branchDAO = new CommonBranchDAO(dbh, (CommonStringTables)stringTables);
        this.licenseEnforcer = licenseEnforcer;
        this.eventMulticaster = new RevisionCache.CacheListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cacheUpdated() {
                List list = BaseRevisionCache.this.listeners;
                synchronized (list) {
                    for (RevisionCache.CacheListener listener : BaseRevisionCache.this.listeners) {
                        listener.cacheUpdated();
                    }
                }
            }
        };
    }

    @Override
    public abstract ChangeSetDAO<F, C> getChangeSetDAO();

    @Override
    public abstract FileRevisionDAO<F> getFileRevisionDAO();

    public BranchDAO getBranchDAO() {
        return this.branchDAO;
    }

    public LicenseEnforcer getLicenseEnforcer() {
        return this.licenseEnforcer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RevisionCache.CacheListener l2) {
        List<RevisionCache.CacheListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l2);
        }
    }

    @Override
    public void commit() throws DbException {
        try {
            if (this.dbh.isOpen() && this.dbh.isDirty()) {
                this.touchLastModifiedDate();
                long start = System.currentTimeMillis();
                this.dbh.commit();
                this.indexingStats.addOperation("infdb commit", "infdb commit at " + new Date(), System.currentTimeMillis() - start);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public void rollback() throws DbException {
        try {
            if (this.dbh.isOpen() && this.dbh.isDirty()) {
                this.dbh.rollback();
                this.syncChangeSetCountsPerState();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getBinaryRevision(RevInfoKey key) throws IOException, DbException {
        Disposer disposer = Disposer.threadInstance();
        File tmpFile = disposer.newDisposedTmpFile();
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(tmpFile));
            this.getBinaryRevision(key, out);
        }
        catch (Throwable throwable) {
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close(out);
        return tmpFile;
    }

    @Override
    public FileRevision findFileRevision(Path path, String revision) throws DbException {
        if (StringUtils.isEmpty((String)revision)) {
            return null;
        }
        FileRevision fileRevision = this.getFileRevision(new RevInfoKey(path, revision));
        if (fileRevision == null && (fileRevision = this.getFileRevisionAtBranch(path, revision)) == null && (fileRevision = this.getFileRevisionAtTag(path, revision)) == null && "HEAD".equals(revision)) {
            fileRevision = this.getLatestFileRevision(path);
        }
        return fileRevision;
    }

    @Override
    public FileRevision getFileRevisionAtBranch(final Path path, String branch) {
        final AtomicReference newest = new AtomicReference();
        this.visitHeadRevisionsOnBranchAtPath(path, branch, new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision fileRevision) {
                if (fileRevision.getPath().equals(path) && (newest.get() == null || FileRevision.NEWEST_FIRST_COMPARATOR.compare((FileRevision)newest.get(), fileRevision) > 0)) {
                    newest.set(fileRevision);
                }
            }
        });
        return (FileRevision)newest.get();
    }

    @Override
    public FileRevision getFileRevisionAtTag(final Path path, String tag) {
        final AtomicReference newest = new AtomicReference();
        this.visitHeadRevisionsOnTagAtPath(path, tag, new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision fileRevision) {
                if (fileRevision.getPath().equals(path) && (newest.get() == null || FileRevision.NEWEST_FIRST_COMPARATOR.compare((FileRevision)newest.get(), fileRevision) > 0)) {
                    newest.set(fileRevision);
                }
            }
        });
        return (FileRevision)newest.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamIndexedLineReader getUnicodeTextRevision(FileRevision rev, String kopt, String symrev) throws IOException, DbException {
        Disposer disposer = Disposer.threadInstance();
        File unicodeFile = disposer.newDisposedTmpFile();
        File tmp2 = File.createTempFile("fisheye", null);
        try {
            BufferedOutputStream out2 = null;
            try {
                out2 = new BufferedOutputStream(new FileOutputStream(tmp2));
                this.getTextRevision(rev.getRevInfoKey(), out2, kopt, symrev);
            }
            catch (Throwable throwable) {
                IOHelper.close(out2);
                throw throwable;
            }
            IOHelper.close(out2);
            IOHelper.translateEncodings(tmp2, this.getTextEncoding(rev.getRevInfoKey()), unicodeFile, Utf16ERandomAccessIoStream.UTF_16LE);
        }
        finally {
            tmp2.delete();
        }
        BufferedRandomAccessInputStream ris = new BufferedRandomAccessInputStream(unicodeFile);
        String pathDebugStr = String.format("%s:%s:%s", new Object[]{this.getRepositoryType(), this.getRepositoryName(), rev.getPath()});
        StreamIndexedLineReader reader = new StreamIndexedLineReader(new Utf16ERandomAccessIoStream(ris), pathDebugStr);
        disposer.add(reader);
        return reader;
    }

    @Override
    public long getCacheSerialNumber() {
        return this.cacheSerialNumber;
    }

    @Override
    public InfinityDbHandle getInfDb() {
        return this.dbh;
    }

    @Override
    public LuceneConnection<LuceneIndexes> getLuceneConnection() {
        return this.luceneConnection;
    }

    protected AndQuery3 findRevisionsUnderDirQuery3(Path dir, boolean findLogical) {
        return CommonQuery3Helper.findRevisionsUnderDirAndQuery3(dir, this.isCaseSensitive());
    }

    protected AndQuery3 findRevisionsUnderDirAndBranchQuery3(Path dir, String branch, boolean findLogical) {
        return CommonQuery3Helper.findRevisionsUnderDirAndBranchAndQuery3(dir, branch, this.isCaseSensitive());
    }

    @Override
    public FileHistory getFileHistory(Path lpath) throws DbException {
        return this.getFileHistory(lpath, false);
    }

    @Override
    public FileHistory getFullFileHistory(Path lpath) throws DbException {
        return this.getFullFileHistory(lpath, false);
    }

    @Override
    public RevisionCache.CacheListener getEventMulticaster() {
        return this.eventMulticaster;
    }

    @Override
    public List<String> findBranches(Path lpath) throws DbException {
        TreeSet<String> result = new TreeSet<String>();
        this.findMatchingStringTerms(lpath, null, true, CommonSchema.E_MOD_ON_BRANCH_TO_REVID, result);
        this.findMatchingStringTerms(lpath, null, true, CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, result);
        this.findMatchingStringTerms(lpath, null, true, CommonSchema.E_BP_ON_BRANCH_TO_REVID, result);
        return new ArrayList<String>(result);
    }

    @Override
    public Set<Tag> getAllTags() throws DbException {
        return this.getChangeSetDAO().getAllTags();
    }

    @Override
    public Tag getTag(String tagName) {
        return this.getChangeSetDAO().getTag(tagName);
    }

    @Override
    public List<String> findAuthors(Path lpath) throws DbException {
        LinkedList<String> result = new LinkedList<String>();
        this.findMatchingStringTerms(lpath, null, false, CommonSchema.E_AUTHOR_TO_REVID, result);
        return result;
    }

    @Override
    public List<String> findAuthors(Path lpath, String branch) throws DbException {
        LinkedList<String> result = new LinkedList<String>();
        this.findMatchingStringTerms(lpath, branch, false, CommonSchema.E_AUTHOR_TO_REVID, result);
        return result;
    }

    @Override
    public void visitAuthors(Path lpath, final StoppableVisitor<String> visitor) {
        this.visitMatchingStringTerms(lpath, null, false, CommonSchema.E_AUTHOR_TO_REVID, new CommonQuery3Helper.StringVisitor(){

            @Override
            public boolean visit(String term) {
                return visitor.visit(term);
            }
        });
    }

    @Override
    public Map<String, ChangeSet> findLatestChangesByAuthor(Path path, Collection<String> committers) throws DbException {
        return this.findChangesByAuthor(path, 0, committers);
    }

    @Override
    public ChangeSet findLatestChangesetForCommitter(String committer) throws DbException {
        return this.findBorderChangesetForCommitter(committer, 0);
    }

    @Override
    public ChangeSet findEarliestChangesetForCommitter(String committer) throws DbException {
        return this.findBorderChangesetForCommitter(committer, 1);
    }

    private ChangeSet findBorderChangesetForCommitter(String committer, int direction) throws DbException {
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setCompulsoryCommitter(committer);
        params.setSearchDirection(direction);
        return this.findAChangeset(params);
    }

    @Override
    public ChangeSet findLatestChangeset(Path path) throws DbException {
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setSearchDirection(0);
        params.setBasePath(path);
        return this.findAChangeset(params);
    }

    @Override
    public List<String> findRecentChangeSetIds(RecentChangesParams2 params) throws DbException {
        List<ChangeSet> changesets = this.findRecentChangeSets(params);
        ArrayList<String> results = new ArrayList<String>(changesets.size());
        for (ChangeSet cs : changesets) {
            results.add(cs.getId());
        }
        return results;
    }

    @Override
    public List<ChangeSet> findRecentChangeSets(RecentChangesParams2 params) throws DbException {
        RecentChangesSearcher2 searcher = new RecentChangesSearcher2(this);
        return searcher.findRecentChangeSets(params);
    }

    private ChangeSet findAChangeset(RecentChangesParams2 params) throws DbException {
        params.setMaxReturn(1);
        RecentChangesSearcher2 searcher = new RecentChangesSearcher2(this);
        List<ChangeSet> changesets = searcher.findRecentChangeSets(params);
        return changesets.isEmpty() ? null : changesets.get(0);
    }

    protected Query3 getBranchOrTagConstraintQuery3(String branchName, String tagName) {
        boolean filterByBranch = StringUtils.isNotEmpty((String)branchName);
        boolean filterByTag = StringUtils.isNotEmpty((String)tagName);
        if (filterByBranch && filterByTag) {
            return new AndQuery3().addClause(CommonQuery3Helper.atTagQuery3(tagName)).addClause(CommonQuery3Helper.headOnBranchQuery3(branchName));
        }
        if (filterByTag) {
            return CommonQuery3Helper.atTagQuery3(tagName);
        }
        if (filterByBranch) {
            return CommonQuery3Helper.headOnBranchQuery3(branchName);
        }
        return CommonQuery3Helper.headOnAnyBranchQuery3();
    }

    public IndexingStats getIndexingStats() {
        return this.indexingStats;
    }

    protected boolean isLogicalPathsSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmptyOfFiles(Path path, String branchName, String tagName) throws DbException {
        long t1 = System.currentTimeMillis();
        try {
            ac db = this.getInfDb().get();
            AndQuery3 bq2 = this.findRevisionsUnderDirQuery3(path, false);
            AndQuery3 query = new AndQuery3();
            query.addClause(new NotQuery3(CommonQuery3Helper.findDeletedRevisionsQuery3()));
            query.addClause(this.getBranchOrTagConstraintQuery3(branchName, tagName));
            bq2.addClause(query);
            boolean bl = !bq2.existAny(new Query3Params(db, (CommonStringTables)this.getStringTables()));
            return bl;
        }
        finally {
            if (Logs.APP_LOG.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                Logs.APP_LOG.debug((Object)("isempty check for /" + path + " in " + (t2 - t1) + "ms"));
            }
        }
    }

    @Override
    public void visitHeadRevisionsInDirectory(Path path, Visitor<FileRevision> revVisitor) throws DbException {
        for (Path p2 : this.listFiles(path)) {
            this.visitHeadRevisionsAtPath(p2, revVisitor);
        }
    }

    @Override
    public void visitHeadRevisionsOnBranchInDirectory(Path path, String branch, Visitor<FileRevision> revVisitor) throws DbException {
        AndQuery3 query = CommonQuery3Helper.findHeadRevisionsInDirAndBranchAndQuery3(path, branch, this.isCaseSensitive());
        this.visitFileRevisionQueryResults(revVisitor, query);
    }

    @Override
    public FileRevision getHeadRevisionOnBranchAtPath(String branchName, Path logicalPath) {
        final ArrayList revisionsOnDefault = new ArrayList(1);
        this.visitHeadRevisionsOnBranchAtPath(logicalPath, branchName, new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision object) {
                revisionsOnDefault.add(object);
            }
        });
        return revisionsOnDefault.isEmpty() ? null : (FileRevision)revisionsOnDefault.get(0);
    }

    @Override
    public void visitRevisionsAtBranchPoint(String branch, Visitor<FileRevision> revVisitor) throws DbException {
        Query3 query = CommonQuery3Helper.branchPointQuery3(branch);
        this.visitFileRevisionQueryResults(revVisitor, query);
    }

    @Override
    public void visitRevisionsForTagInDirectory(Path path, String tag, Visitor<FileRevision> revVisitor) throws DbException {
        AndQuery3 query = CommonQuery3Helper.findRevisionsInDirAndTagAndQuery3(path, tag, this.isCaseSensitive());
        this.visitFileRevisionQueryResults(revVisitor, query);
    }

    @Override
    public void visitHeadRevisionsAtPath(Path path, Visitor<FileRevision> revisionVisitor) throws DbException {
        FileRevision fr = this.getLatestFileRevision(path);
        if (fr != null) {
            revisionVisitor.visit(fr);
        }
    }

    @Override
    public void visitHeadRevisionsOnTagAtPath(Path path, String tag, Visitor<FileRevision> revVisitor) throws DbException {
        AndQuery3 query = CommonQuery3Helper.findRevisionsAtPathAndTagQuery3(path, tag, this.isCaseSensitive());
        this.visitFileRevisionQueryResults(revVisitor, query);
    }

    @Override
    public void visitHeadRevisionsOnBranchAtPath(Path path, String branch, Visitor<FileRevision> revVisitor) throws DbException {
        AndQuery3 query = CommonQuery3Helper.findHeadRevisionsAtPathAndBranchQuery3(path, branch, this.isCaseSensitive());
        this.visitFileRevisionQueryResults(revVisitor, query);
    }

    @Override
    public List<Integer> getHeadRevisions(Path path, boolean isLogicalPath) throws DbException {
        Set<Integer> revIds = this.getRevisionIds(path, isLogicalPath);
        if (revIds.size() <= 0) {
            return Collections.emptyList();
        }
        Set<Integer> headRevIds = this.getCommonRevInfoDAO().filterHeadRevisions(revIds);
        return this.orderRevisions(headRevIds);
    }

    protected List<Integer> orderRevisions(Iterable<Integer> headRevIds) throws DbException {
        return this.getCommonRevInfoDAO().orderRevisions(headRevIds, true);
    }

    protected Set<Integer> getRevisionIds(Path path, boolean isLogicalPath) throws DbException {
        Map<String, Integer> mapRevIds = this.getCommonRevInfoDAO().getPathRevisions(path);
        return new HashSet<Integer>(mapRevIds.values());
    }

    private void visitFileRevisionQueryResults(Visitor<FileRevision> revVisitor, Query3 query) throws DbException {
        y cu = null;
        try {
            ac result = query.asItemSpace(new Query3Params(this.dbh.get(), (CommonStringTables)this.stringTables));
            cu = y.a();
            while (result.d(cu)) {
                int revid = (int)cu.v(0);
                F revInfo = this.getFileRevisionDAO().loadLazy(revid);
                if (revInfo == null) continue;
                revVisitor.visit((FileRevision)revInfo);
            }
        }
        catch (IOException e2) {
            try {
                throw new DbException(e2);
            }
            catch (Throwable throwable) {
                y.c(cu);
                throw throwable;
            }
        }
        y.c(cu);
    }

    protected IndexingContext getIndexingContext() {
        return this.indexingContext;
    }

    @Override
    public LuceneConnection<CrossRepLuceneIndexes> getCrossRepLuceneConnection() {
        return this.getCrossRepoIndex().getConnection();
    }

    public CrossRepLuceneIndex getCrossRepoIndex() {
        return this.getIndexingContext().getCrossRepLuceneIndex();
    }

    private Map<String, ChangeSet> findChangesByAuthor(Path path, int direction, Collection<String> committers) throws DbException {
        HashMap<String, ChangeSet> authorLatestCommitMap = new HashMap<String, ChangeSet>();
        RecentChangesSearcher2 searcher = new RecentChangesSearcher2(this);
        for (String author : committers) {
            RecentChangesParams2 params = new RecentChangesParams2();
            params.setMaxReturn(1);
            params.addAnyCommiter(author);
            params.setBasePath(path);
            params.setSearchDirection(direction);
            List<ChangeSet> cs = searcher.findRecentChangeSets(params);
            if (cs.isEmpty()) continue;
            authorLatestCommitMap.put(author, cs.get(0));
        }
        return authorLatestCommitMap;
    }

    @Override
    public Map<String, ChangeSet> findEarliestChangesByAuthor(Path path, Collection<String> committers) throws DbException {
        return this.findChangesByAuthor(path, 1, committers);
    }

    private void findMatchingStringTerms(Path lpath, String branch, boolean findLogical, I entity, final Collection<String> result) throws DbException {
        this.visitMatchingStringTerms(lpath, branch, findLogical, entity, new CommonQuery3Helper.StringVisitor(){

            @Override
            public boolean visit(String term) {
                result.add(term);
                return true;
            }
        });
    }

    private void visitMatchingStringTerms(Path path, String branch, boolean findLogical, I entity, CommonQuery3Helper.StringVisitor v2) throws DbException {
        long t0 = System.currentTimeMillis();
        AndQuery3 q2 = this.isDir(path) ? (Strings.isNullOrEmpty((String)branch) ? this.findRevisionsUnderDirQuery3(path, findLogical) : this.findRevisionsUnderDirAndBranchQuery3(path, branch, findLogical)) : (Strings.isNullOrEmpty((String)branch) ? CommonQuery3Helper.findRevisionsAtPathQuery3(path, this.isCaseSensitive()) : CommonQuery3Helper.findRevisionsAtPathBranchQuery3(path, branch, this.isCaseSensitive()));
        CommonQuery3Helper.visitMatchingStringTerms(this.dbh.get(), this.stringTables, q2, entity, v2);
        if (Logs.APP_LOG.isDebugEnabled()) {
            long t1 = System.currentTimeMillis();
            Logs.APP_LOG.debug((Object)("findMatching " + entity + " for /" + path + (findLogical ? " logically" : "") + " computed in " + (t1 - t0) + "ms"));
        }
    }

    @Override
    public DirInfo findDirInfo(Path lpath) throws DbException {
        CommonDirInfoDAO dao = new CommonDirInfoDAO(this.dbh, (CommonStringTables)this.stringTables, this.isCaseSensitive());
        return dao.load(lpath);
    }

    @Override
    public int findLastSuccessor(int revid) throws DbException {
        TagTreeVisitor v2 = new TagTreeVisitor(this.dbh.get());
        return v2.findLastSuccessor(revid);
    }

    @Override
    public int findNextSuccessor(int revid) throws DbException {
        TagTreeVisitor v2 = new TagTreeVisitor(this.dbh.get());
        return v2.findNextSuccessor(revid);
    }

    @Override
    public Collection<String> findChangesetsWithLaterRevisions(RevInfoKey revInfoKey) throws DbException {
        final LinkedHashSet<String> results = new LinkedHashSet<String>();
        TagTreeVisitor v2 = new TagTreeVisitor(this.dbh.get());
        CommonRevInfoDAO dao = this.getCommonRevInfoDAO();
        int startid = dao.getRevId(revInfoKey);
        v2.visitSuccessors(startid, new TagTreeVisitor.DescendentVisitor(){

            @Override
            public void visitDescendent(int revid) throws DbException, IOException {
                results.add(BaseRevisionCache.this.getChangeSetId(revid));
            }
        });
        return results;
    }

    @Override
    public boolean isBefore(int revIdA, int revIdB) throws DbException {
        RevInfoKey revKeyB = this.getKey(revIdB);
        RevInfoKey revKeyA = this.getKey(revIdA);
        if (revKeyB != null && revKeyA != null) {
            RevInfoKey found = this.searchAncestors(revKeyB, (Predicate<RevInfoKey>)Predicates.equalTo((Object)revKeyA));
            return found != null;
        }
        return false;
    }

    @Override
    public boolean isAfter(int revIdA, int revIdB) throws DbException {
        return revIdA != revIdB && this.isBefore(revIdB, revIdA);
    }

    @Override
    public List<Hunk> getHunks(RevInfoKey key) throws DbException {
        CommonRevInfoDAO dao = this.getCommonRevInfoDAO();
        int revid = dao.getRevId(key);
        return dao.getHunks(revid);
    }

    @Override
    public void setBlameSpans(RevInfoKey key, List<BlameChunk> spans) throws DbException {
        CommonRevInfoDAO dao = this.getCommonRevInfoDAO();
        int revId = dao.getRevId(key);
        try {
            dao.setBlameSpans(revId, spans);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public List<BlameChunk> getBlameSpans(RevInfoKey key) throws DbException {
        CommonRevInfoDAO dao = this.getCommonRevInfoDAO();
        int revId = dao.getRevId(key);
        return dao.getBlameSpans(revId);
    }

    @Override
    public boolean hasBlameSpans(RevInfoKey revInfoKey) {
        CommonRevInfoDAO dao = this.getCommonRevInfoDAO();
        int revId = dao.getRevId(revInfoKey);
        return dao.hasBlameSpans(revId);
    }

    @Override
    public Blame getBlame(RevInfoKey revInfoKey) throws DbException, IOException {
        return this.getBlame(revInfoKey, true).get();
    }

    @Override
    public Optional<Blame> getBlame(RevInfoKey revInfoKey, boolean withScmFallback) throws DbException, IOException {
        List<BlameChunk> blameChunks;
        if (FishEyeSysProps.BLAME_CALC_ENABLED && (blameChunks = this.getBlameSpans(revInfoKey)) != null && !blameChunks.isEmpty()) {
            HashMap<Integer, FileRevision> revisions = new HashMap<Integer, FileRevision>();
            for (BlameChunk chunk : blameChunks) {
                if (chunk.getLength() < 0) {
                    if (withScmFallback) {
                        Logs.APP_LOG.warn((Object)String.format("Malformed blame chunk %s. Falling back to SCM blame.", chunk));
                        return Optional.of(this.getBlameFallback(revInfoKey));
                    }
                    Logs.APP_LOG.warn((Object)String.format("Malformed blame chunk %s. Not falling back to SCM blame.", chunk));
                    return Optional.empty();
                }
                int revId = chunk.getRevId();
                SyntheticBlameInfo syntheticBlameInfo = new SyntheticBlameInfo("", "", revInfoKey.getPath());
                if ((long)revId == -1L) {
                    chunk.setBlameInfo(syntheticBlameInfo);
                    continue;
                }
                FileRevision fr = (FileRevision)revisions.get(revId);
                if (fr == null) {
                    fr = this.getFileRevision(revId, true);
                }
                if (fr == null) {
                    Logs.APP_LOG.warn((Object)String.format("Failed to load FileRevisions for %s (%s)", revId, revInfoKey));
                    chunk.setBlameInfo(syntheticBlameInfo);
                    continue;
                }
                revisions.put(revId, fr);
                chunk.setBlameInfo(fr);
            }
            return Optional.of(new Blame(blameChunks));
        }
        return withScmFallback ? Optional.of(this.getBlameFallback(revInfoKey)) : Optional.empty();
    }

    public T getStringTables() {
        return this.stringTables;
    }

    @Override
    public long getLastModifiedDate() throws DbException {
        return this.getScanProperty(CommonProperties.LAST_MODIFIED.value, -1L);
    }

    @Override
    public void touchLastModifiedDate() throws DbException {
        long timestamp = System.currentTimeMillis();
        this.getIndexingContext().getRepositoryModificationTracker().setModified(this.getRepositoryName(), timestamp);
        this.setScanProperty(CommonProperties.LAST_MODIFIED.value, timestamp);
    }

    @Override
    public IndexingState getIndexingPhase() throws DbException {
        long value = this.getScanProperty(CommonProperties.INDEXING_PHASE.value, IndexingState.PROCESSING_REVISIONS.infdbInt);
        return IndexingState.getState(value);
    }

    @Override
    public void setIndexingPhase(IndexingState phase) throws DbException {
        this.setScanProperty(CommonProperties.INDEXING_PHASE.value, phase.infdbInt);
    }

    @Override
    public void setScanProperty(String propName, long value) throws DbException {
        this.utilDAO.setProperty(propName, value);
    }

    @Override
    public long getScanProperty(String propName, long defaultValue) throws DbException {
        return this.utilDAO.getProperty(propName, defaultValue);
    }

    public boolean hasScanProperty(String propName) throws DbException {
        return this.utilDAO.hasProperty(propName);
    }

    @Override
    public long getMetadataVersion() throws DbException {
        return this.getScanProperty(CommonProperties.QUICKSEARCH_VERSION.value, 0L);
    }

    @Override
    public void setMetadataVersion(long version) throws DbException {
        this.setScanProperty(CommonProperties.QUICKSEARCH_VERSION.value, version);
    }

    @Override
    public void setQuicksearchReslurped(boolean b2) throws DbException {
        if (!this.hasScanProperty(CommonProperties.QUICKSEARCH_RESLURPED.value) && !b2) {
            this.setScanProperty(CommonProperties.QUICKSEARCH_RESLURPED.value, 0L);
        } else {
            this.setScanProperty(CommonProperties.QUICKSEARCH_RESLURPED.value, 1L);
        }
    }

    @Override
    public Map<Path, Integer> findPathRoots(Set<Path> paths, EggTimer timer) throws IOException, DbException {
        HashMultiset collector = HashMultiset.create();
        for (Path p2 : paths) {
            if (p2.isRoot()) continue;
            collector.addAll(this.findPathRoots(p2, timer));
            if (timer == null || !timer.isTimeExpired()) continue;
            break;
        }
        HashMap results = Maps.newHashMap();
        for (Multiset.Entry entry : collector.entrySet()) {
            results.put(entry.getElement(), entry.getCount());
        }
        return results;
    }

    protected List<Path> findPathRoots(Path suffix, EggTimer timer) throws IOException, DbException {
        CommonRevInfoDAO revInfoDAO = this.getCommonRevInfoDAO();
        return revInfoDAO.getPathId(suffix) == -1L ? Collections.emptyList() : Collections.singletonList(Path.ROOT);
    }

    @Override
    public String getAuthorOfRevision(int revId) throws DbException {
        return this.getCommonRevInfoDAO().getAuthorOfRevision(revId);
    }

    @Override
    public int getRevId(RevInfoKey key) throws DbException {
        return this.getCommonRevInfoDAO().getRevId(key);
    }

    @Override
    public boolean existsChangeSet(String csid) throws DbException {
        return this.getChangeSetDAO().exists(csid);
    }

    @Override
    public long countChangeSets(Path path, String committer) throws DbException {
        ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(this.getRepositoryName(), null, committer, path);
        return calculator.count(this.getCrossRepLuceneConnection());
    }

    @Override
    public long countChangeSets(ActivityItemSearchParams params) throws DbException {
        ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(params);
        return calculator.count(this.getCrossRepLuceneConnection());
    }

    public long countChangeSets() {
        return this.countChangeSets(Path.ROOT, null);
    }

    @Override
    public void setInitialIndexingComplete(boolean markWrapped) throws DbException {
        if (!this.isInitialIndexingComplete()) {
            this.setScanProperty(CommonProperties.INITIAL_DONE.value, System.currentTimeMillis());
            this.status.setInitialIndexingComplete(true);
            this.status.setInitialScanningComplete(true);
        }
        if (markWrapped) {
            this.status.setIndexingUpToDate(true);
        }
    }

    @Override
    public boolean isInitialIndexingComplete() throws DbException {
        return this.getScanProperty(CommonProperties.INITIAL_DONE.value, -1L) != -1L;
    }

    @Override
    public boolean isInitialCrucibleIndexingComplete() throws DbException {
        return this.getScanProperty(CommonProperties.INITIAL_CRU_DONE.value, 0L) == 1L;
    }

    @Override
    public void markInitialCrucibleIndexingComplete() {
        this.setScanProperty(CommonProperties.INITIAL_CRU_DONE.value, 1L);
        this.status.setInitialCrucibleIndexingComplete(true);
        this.commit();
    }

    public RevInfoKey getKey(int revid) throws DbException {
        return this.getCommonRevInfoDAO().getKey(revid);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void visitChangesetIds(int startId, UniqueStringTable.Visitor visitor) throws DbException {
        ((CommonStringTables)this.getStringTables()).changeSetIdDB.visit(visitor, startId);
    }

    @Override
    public void visitRevisions(Iterable<Integer> revIds, Visitor<FileRevision> visitor) throws DbException {
        for (Integer revId : revIds) {
            if (revId == null) continue;
            visitor.visit(this.getFileRevision(revId));
        }
    }

    @Override
    public Set<String> getAllAuthors() throws DbException {
        return this.getChangeSetDAO().getAllAuthors();
    }

    @Override
    public List<ChangesetRevision> getChangesetRevisions(ChangeSet changeset, List<FileRevision> revs) {
        ArrayList<ChangesetRevision> changesetRevs = new ArrayList<ChangesetRevision>();
        if (changeset != null) {
            for (FileRevision rev : revs) {
                changesetRevs.add(new ChangesetRevision(rev, this.getFileRevisionDAO().getDiffRevision(rev)));
            }
        }
        return changesetRevs;
    }

    @Override
    public long getSubBranchId(String changeSetId) throws DbException {
        return 0L;
    }

    @Override
    public RevInfoKey searchAncestors(RevInfoKey revInfoKey, Predicate<RevInfoKey> predicate) throws DbException {
        return this.getFileRevisionDAO().searchAncestors(revInfoKey, predicate, false);
    }

    @Override
    public Branch getBranch(String branchName) throws DbException {
        return this.branchDAO.load(branchName);
    }

    public boolean hasBranch(String branchName) throws DbException {
        return this.branchDAO.exists(branchName);
    }

    @Override
    public void storeBranch(Branch branch) throws DbException {
        this.branchDAO.store(branch, true);
    }

    @Override
    public Set<Branch> getBranches() throws DbException {
        return this.branchDAO.loadAll();
    }

    @Override
    public boolean deleteBranch(Branch branch) throws DbException {
        return this.branchDAO.delete(branch.getName());
    }

    @Override
    public C getNextChangeSet(ChangeSet cs) {
        return (C)((ChangeSetImpl)this.getChangeSetDAO().getNextChangeSet(cs));
    }

    @Override
    public C getPreviousChangeSet(ChangeSet cs) {
        return (C)((ChangeSetImpl)this.getChangeSetDAO().getPreviousChangeSet(cs));
    }

    public void visitRevisionsForTag(String tag, Visitor<FileRevision> visitor) {
        AndQuery3 query = new AndQuery3();
        query.addClause(CommonQuery3Helper.atTagQuery3(tag));
        this.visitFileRevisionQueryResults(visitor, query);
    }

    @Override
    public ListIterable<C> getChangeSets() {
        return this.getChangeSetDAO().getChangeSets();
    }

    @Override
    public List<String> getChangeSetIds() throws DbException {
        return this.getChangeSetDAO().getChangeSetIds();
    }

    @Override
    public boolean exists(String csid) throws DbException {
        return this.getChangeSetDAO().exists(csid);
    }

    @Override
    public C getLatestChangesetOnBranchUpTo(String branchName, String csId, boolean inclusive) {
        return (C)((ChangeSetImpl)this.getChangeSetDAO().getLatestChangesetOnBranchUpTo(branchName, csId, false));
    }

    @Override
    public C getLatestChangesetOnBranch(String branchName) {
        return (C)((ChangeSetImpl)this.getChangeSetDAO().getLatestChangesetOnBranch(branchName));
    }

    @Override
    public ListIterable<C> getChangeSets(ChangeSet startPosition) {
        return this.getChangeSetDAO().getChangeSets(startPosition);
    }

    @Override
    public Iterable<C> getChangeSetsInState(ChangeSetIndexingState state) {
        return this.getChangeSetDAO().getChangeSetsInState(state);
    }

    @Override
    public ListIterable<C> getChangeSetsOnBranch(String branchName, ChangeSet startPosition) {
        return this.getChangeSetDAO().getChangeSetsOnBranch(branchName, startPosition);
    }

    @Override
    public void syncChangeSetCountsPerState() {
        this.getChangeSetDAO().syncChangeSetCountsPerState();
        int numEmptyChangesets = (int)this.getScanProperty(CommonProperties.NUM_EMPTY_CS.value, 0L);
        this.status.setNumEmptyChangesets(numEmptyChangesets);
    }

    @Override
    public C getTipChangeSet(Set<String> branches) {
        return (C)((ChangeSetImpl)this.getChangeSetDAO().getTipChangeSet(branches));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withDbWriteLock(int priority, DbTask<T> task) throws DbException {
        boolean committed = false;
        try {
            long ts0 = System.currentTimeMillis();
            this.writeLock.lock(priority);
            long ts1 = System.currentTimeMillis();
            T result = task.perform(this.getInfDb().get());
            long ts2 = System.currentTimeMillis();
            this.commit();
            long ts3 = System.currentTimeMillis();
            Logs.APP_LOG.debug((Object)("Committed for priority " + priority + " total= " + (ts3 - ts0) + " ms (lock= " + (ts1 - ts0) + " ms, task=" + (ts2 - ts1) + " ms, commit=" + (ts3 - ts2) + " ms)"));
            committed = true;
            T t2 = result;
            return t2;
        }
        finally {
            try {
                if (!committed) {
                    Logs.APP_LOG.debug((Object)("Rolling back for priority " + priority));
                    this.rollback();
                }
            }
            finally {
                if (this.writeLock.hasLock()) {
                    this.writeLock.unlock();
                }
            }
        }
    }

    @Override
    public boolean hasDbWriteLock() {
        return this.writeLock.hasLock();
    }

    @Override
    public Set<String> getChangeSetAncestors(String startCsId, int limit, @Nullable Iterable<Branch> excludedBranches, @Nullable AtomicReference<String> topmostBranchPointCsId) {
        return this.getChangeSetDAO().getChangeSetAncestors(startCsId, limit, excludedBranches, topmostBranchPointCsId);
    }
}

