/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cache;

import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.IndexingFeatures;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import java.io.IOException;
import java.util.Collection;

public abstract class BaseDirInfoCache<F extends FileRevision, C extends ChangeSetImpl<F>, T extends CommonStringTables>
extends BaseRevisionCache<F, C, T> {
    private final CommonDirInfoDAO dirInfoDAO;
    private IndexingFeatures features;

    protected BaseDirInfoCache(RepositoryStatus status, long cacheSerial, int version, InfinityDbHandle dbh, LuceneConnection<LuceneIndexes> luceneConnection, T stringTables, LicenseEnforcer licenseEnforcer, IndexingContext indexingContext, boolean caseSensitive) {
        super(status, cacheSerial, version, dbh, luceneConnection, stringTables, licenseEnforcer, indexingContext);
        this.dirInfoDAO = new CommonDirInfoDAO(this.getInfDb(), (CommonStringTables)this.getStringTables(), caseSensitive);
    }

    @Override
    public Path[] listFiles(Path dir) throws DbException {
        Collection<Path> files = this.dirInfoDAO.listFiles(dir);
        return files.toArray(new Path[files.size()]);
    }

    @Override
    public Path[] listDirs(Path dir) throws DbException {
        Collection<Path> dirs = this.dirInfoDAO.listDirs(dir);
        return dirs.toArray(new Path[dirs.size()]);
    }

    @Override
    public boolean isDir(Path path) throws DbException {
        return path.isRoot() || this.dirInfoDAO.exists(path);
    }

    public boolean existsDir(Path dir) throws DbException {
        return this.dirInfoDAO.exists(dir);
    }

    public void createDir(Path dir) throws DbException {
        try {
            this.dirInfoDAO.addDirToParent(dir);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public DirInfo findDirInfo(Path lpath) throws DbException {
        return this.dirInfoDAO.load(lpath);
    }

    public IndexingFeatures loadIndexingFeatures() throws DbException {
        if (!this.hasScanProperty(CommonProperties.STORE_DIFFS.value) && !this.hasScanProperty(CommonProperties.LOC_ENABLED.value)) {
            return null;
        }
        IndexingFeatures config = new IndexingFeatures();
        if (this.hasScanProperty(CommonProperties.STORE_DIFFS.value)) {
            config.setStoreDiffs(this.getScanProperty(CommonProperties.STORE_DIFFS.value, 1L) == 1L);
        }
        if (this.hasScanProperty(CommonProperties.LOC_ENABLED.value)) {
            config.setLocEnabled(this.getScanProperty(CommonProperties.LOC_ENABLED.value, 1L) == 1L);
        }
        return config;
    }

    public void storeIndexingFeatures(IndexingFeatures config) throws DbException {
        this.setScanProperty(CommonProperties.STORE_DIFFS.value, config.isStoreDiffs() ? 1L : 0L);
        this.setScanProperty(CommonProperties.LOC_ENABLED.value, config.isLocEnabled() ? 1L : 0L);
    }

    public void setFeatures(IndexingFeatures features) {
        this.features = features;
    }

    public IndexingFeatures getFeatures() {
        return this.features;
    }

    @Override
    public boolean isAuthorLocEnabled() {
        return this.features.isStoreDiffs() && this.features.isLocEnabled();
    }

    @Override
    public boolean isLocEnabled() {
        return this.features.isLocEnabled();
    }

    @Override
    public boolean isStoreDiffs() {
        return this.features.isStoreDiffs();
    }
}

