/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.TarballType;

public class TarballConfig {
    private final TarballType config;
    private final TarballType defaults;
    private final boolean hasConfig;

    public TarballConfig(TarballType config, TarballType defaults) {
        this.config = config;
        this.defaults = defaults;
        this.hasConfig = config != null;
    }

    public boolean isEnabled() {
        return this.hasConfig ? this.config.getEnabled() : this.defaults.getEnabled();
    }

    public int getMaxFileCount() {
        int max = 0;
        if (this.defaults.isSetMaxFileCount()) {
            max = this.defaults.getMaxFileCount().intValue();
        }
        if (this.hasConfig && this.config.isSetMaxFileCount()) {
            max = this.config.getMaxFileCount().intValue();
        }
        return max;
    }

    public boolean isExcluded(Path path) {
        return TarballConfig.isExcluded(this.defaults.getExcludeArray(), path) || this.hasConfig && TarballConfig.isExcluded(this.config.getExcludeArray(), path);
    }

    private static boolean isExcluded(TarballType.Exclude[] ex, Path path) {
        for (TarballType.Exclude exclude : ex) {
            Path tree;
            Path dir;
            if (exclude.isSetDir() && path.equals(dir = new Path(exclude.getDir()))) {
                return true;
            }
            if (!exclude.isSetTree() || !path.hasPrefix(tree = new Path(exclude.getTree()))) continue;
            return true;
        }
        return false;
    }
}

