/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.atlassian.crucible.spi.data.CvsRepositoryData;
import com.atlassian.crucible.spi.data.GitRepositoryData;
import com.atlassian.crucible.spi.data.HgRepositoryData;
import com.atlassian.crucible.spi.data.P4RepositoryData;
import com.atlassian.crucible.spi.data.RepositoryData;
import com.atlassian.crucible.spi.data.SvnRepositoryData;
import com.atlassian.fisheye.spi.admin.impl.DefaultCvsRepositoryIndexer;
import com.atlassian.fisheye.spi.admin.impl.DefaultDvcsRepositoryIndexer;
import com.atlassian.fisheye.spi.admin.impl.DefaultP4RepositoryIndexer;
import com.atlassian.fisheye.spi.admin.impl.DefaultRepositoryAdminService;
import com.atlassian.fisheye.spi.admin.impl.DefaultRepositoryIndexer;
import com.atlassian.fisheye.spi.admin.impl.DefaultSvnRepositoryIndexer;
import com.atlassian.fisheye.spi.admin.services.RepositoryIndexer;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.HgRepType;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.EnumSet;

public enum ScmType {
    CVS("cvs", "Concurrent Versions System (CVS)"){

        @Override
        public RepositoryData getRepositoryData(RepositoryHandle rh) {
            CvsRepType cvs = rh.getCfg().getRepositoryTypeConfig().getCvs();
            return new CvsRepositoryData(rh.getName(), rh.getCfg().getRepositoryType().id, rh.getCfg().isEnabled(), rh.isRunning(), cvs.getDir());
        }

        @Override
        public RepositoryIndexer getDefaultRepositoryIndexer(DefaultRepositoryAdminService service, RepositoryHandle handle) {
            return new DefaultCvsRepositoryIndexer(service, handle);
        }
    }
    ,
    SVN("svn", "Subversion"){

        @Override
        public RepositoryData getRepositoryData(RepositoryHandle rh) {
            SvnRepType svn = rh.getCfg().getRepositoryTypeConfig().getSvn();
            return new SvnRepositoryData(rh.getName(), rh.getCfg().getRepositoryType().id, rh.getCfg().isEnabled(), rh.isRunning(), svn.getUrl(), svn.getPath());
        }

        @Override
        public RepositoryIndexer getDefaultRepositoryIndexer(DefaultRepositoryAdminService service, RepositoryHandle handle) {
            return new DefaultSvnRepositoryIndexer(service, handle);
        }
    }
    ,
    P4("p4", "Perforce"){

        @Override
        public RepositoryData getRepositoryData(RepositoryHandle rh) {
            P4RepType p4 = rh.getCfg().getRepositoryTypeConfig().getPerforce();
            return new P4RepositoryData(rh.getName(), rh.getCfg().getRepositoryType().id, rh.getCfg().isEnabled(), rh.isRunning(), p4.getServer(), p4.isSetPort() ? Integer.valueOf(p4.getPort().intValue()) : null, p4.getPath());
        }

        @Override
        public RepositoryIndexer getDefaultRepositoryIndexer(DefaultRepositoryAdminService service, RepositoryHandle handle) {
            return new DefaultP4RepositoryIndexer(service, handle);
        }
    }
    ,
    GIT("git", "Git"){

        @Override
        public RepositoryData getRepositoryData(RepositoryHandle rh) {
            GitRepType git = rh.getCfg().getRepositoryTypeConfig().getGit();
            return new GitRepositoryData(rh.getName(), rh.getCfg().getRepositoryType().id, rh.getCfg().isEnabled(), rh.isRunning(), git.getLocation(), git.getPath());
        }

        @Override
        public RepositoryIndexer getDefaultRepositoryIndexer(DefaultRepositoryAdminService service, RepositoryHandle handle) {
            return new DefaultDvcsRepositoryIndexer(service, handle);
        }
    }
    ,
    CLEARCASE("clearcase", "ClearCase"){

        @Override
        public RepositoryData getRepositoryData(RepositoryHandle rh) {
            return new RepositoryData(rh.getName(), ScmType.CLEARCASE.id, false, rh.isRunning());
        }
    }
    ,
    HG("hg", "Mercurial"){

        @Override
        public RepositoryData getRepositoryData(RepositoryHandle rh) {
            HgRepType hg = rh.getCfg().getRepositoryTypeConfig().getHg();
            return new HgRepositoryData(rh.getName(), rh.getCfg().getRepositoryType().id, rh.getCfg().isEnabled(), rh.isRunning(), hg.getLocation());
        }

        @Override
        public RepositoryIndexer getDefaultRepositoryIndexer(DefaultRepositoryAdminService service, RepositoryHandle handle) {
            return new DefaultDvcsRepositoryIndexer(service, handle);
        }
    };

    private static final Function<ScmType, String> SCM_TYPE_TO_ID;
    public static final ImmutableSet<String> ALL_SCM_TYPE_IDS;
    public final String id;
    public final String fullName;

    private ScmType(String id, String fullName) {
        this.id = id;
        this.fullName = fullName;
    }

    public abstract RepositoryData getRepositoryData(RepositoryHandle var1);

    public RepositoryIndexer getDefaultRepositoryIndexer(DefaultRepositoryAdminService service, RepositoryHandle handle) {
        return new DefaultRepositoryIndexer(service, handle);
    }

    public String getId() {
        return this.id;
    }

    public boolean isCvs() {
        return CVS.equals((Object)this);
    }

    public boolean isSvn() {
        return SVN.equals((Object)this);
    }

    public boolean isP4() {
        return P4.equals((Object)this);
    }

    public boolean isGit() {
        return GIT.equals((Object)this);
    }

    public boolean isHg() {
        return HG.equals((Object)this);
    }

    public boolean isDvcs() {
        return this.isGit() || this.isHg();
    }

    public boolean isChangesetIdNumeric() {
        return this.isSvn() || this.isP4();
    }

    public String getFullName() {
        return this.fullName;
    }

    static {
        SCM_TYPE_TO_ID = new Function<ScmType, String>(){

            public String apply(ScmType scmType) {
                return scmType.getId();
            }
        };
        ALL_SCM_TYPE_IDS = ImmutableSet.copyOf((Iterable)Iterables.transform(EnumSet.allOf(ScmType.class), SCM_TYPE_TO_ID));
    }
}

