/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.scmapi.ScmConfig;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.TarballConfig;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.config.AllowRules;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.IncludeTree;
import com.cenqua.fisheye.config.IndexingConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.CustomRepositoryConfigType;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.GroupType;
import com.cenqua.fisheye.config1.HideDirType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;

public class RepositoryConfig
implements IndexingConfig {
    private final RepositoryType repoConfig;
    private final String name;
    private Linker linker;
    private final Object linkerInitLock = new Object();
    private final Analyzer masterAnalyzer = LuceneUtils.createPerFieldAnalyzer((Analyzer)new SimpleAnalyzer(LuceneConnection.VERSION));
    private final List<AntGlob> hideDirectoryPatterns = new ArrayList<AntGlob>();
    private final TarballConfig tarballConfig;
    private AllowRules allowRules;
    private final RepositoryStatus status;
    private final boolean storeDiffs;
    private final ScmConfig scmConfig;
    private final LicenseEnforcer licenseEnforcer;
    private final long maxIndexableSize;
    private final RootConfig rootConfig;
    private ConfigException configException;

    public RepositoryConfig(RootConfig rootConfig, RepositoryType repoConfig, ScmConfig scmConfig, LicenseEnforcer licenseEnforcer, ConfigException configException) {
        this.rootConfig = rootConfig;
        this.repoConfig = repoConfig;
        this.configException = configException;
        this.name = repoConfig.getName();
        this.status = new RepositoryStatus(this.name);
        this.tarballConfig = new TarballConfig(repoConfig.getTarball(), this.getRepositoryDefaults().getTarball());
        this.setup();
        this.storeDiffs = repoConfig.isSetStoreDiff() ? repoConfig.getStoreDiff() : true;
        this.scmConfig = scmConfig;
        this.licenseEnforcer = licenseEnforcer;
        this.maxIndexableSize = repoConfig.isSetMaxIndexableSize() ? repoConfig.getMaxIndexableSize().longValue() : (this.getRepositoryDefaults().isSetMaxIndexableSize() ? this.getRepositoryDefaults().getMaxIndexableSize().longValue() : 102400L);
    }

    public void deleteCache() {
        File repoLocalDiffText;
        IOHelper.deleteFile(this.getCachePropertiesFile());
        IOHelper.recursiveDelete(this.getRevCacheDir(), 2);
        File[] indexDirs = this.getCacheDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("idx");
            }
        });
        if (indexDirs != null) {
            for (File indexDir : indexDirs) {
                IOHelper.recursiveDelete(indexDir, 2);
            }
        }
        if ((repoLocalDiffText = new File(this.getCacheDir(), "DiffTextCache")).exists()) {
            IOHelper.recursiveDelete(repoLocalDiffText, 3, true);
        }
    }

    public RevisionCacheProperties createNewCache() throws ConfigException, IOException {
        this.deleteCache();
        File cacheDir = this.getCacheDir();
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new ConfigException("Unable to create cache directory " + cacheDir.getAbsolutePath());
        }
        File revCacheDir = this.getRevCacheDir();
        if (!revCacheDir.exists() && !revCacheDir.mkdirs()) {
            throw new ConfigException("Unable to create rev cache directory " + revCacheDir.getAbsolutePath());
        }
        File propFile = this.getCachePropertiesFile();
        RevisionCacheProperties props = RevisionCacheProperties.createNew(propFile, this.getSoftwareCacheVersion());
        if (!this.isCacheValid()) {
            throw new ConfigException("Unable to create a valid cache for " + this.getName());
        }
        return props;
    }

    public boolean isCacheValid() {
        File propFile = this.getCachePropertiesFile();
        if (!propFile.exists()) {
            return false;
        }
        File cacheDir = this.getCacheDir();
        if (!cacheDir.exists() || !cacheDir.isDirectory()) {
            return false;
        }
        File revCacheDir = this.getRevCacheDir();
        return revCacheDir.exists() && revCacheDir.isDirectory();
    }

    public boolean isStoreDiffs() {
        return this.storeDiffs;
    }

    public ScmConfig getScmConfig() {
        return this.scmConfig;
    }

    public ConfigException getConfigException() {
        return this.configException;
    }

    public RepositoryEngine createRepositoryEngine(UpgradeManager upgradeManager, IndexingContext indexingContext) throws DbException, ConfigException {
        RepositoryEngine engine = this.scmConfig.createRepositoryEngine(this, upgradeManager, indexingContext);
        engine.init();
        engine.setLicenseEnforcer(this.licenseEnforcer);
        return engine;
    }

    public AllowRules getAllowRules() {
        return this.allowRules;
    }

    private void setup() {
        ArrayList<AntGlob> disallowPatterns = new ArrayList<AntGlob>();
        ArrayList<IncludeTree> allowDirs = new ArrayList<IncludeTree>();
        if (this.repoConfig.isSetAllow()) {
            this.setupRepositoryAllows(allowDirs, disallowPatterns, this.repoConfig.getAllow());
        }
        this.setupRepositoryAllows(allowDirs, disallowPatterns, this.getRepositoryDefaults().getAllow());
        this.allowRules = new AllowRules(allowDirs, disallowPatterns);
        this.setupRepositoryHidden(this.repoConfig.getHideDirArray());
        this.setupRepositoryHidden(this.getRepositoryDefaults().getHideDirArray());
    }

    public void setupLinker() {
        LinkerFactory linkerFactory = (LinkerFactory)SpringContext.getComponent("linkerFactory");
        this.linker = linkerFactory.createRepositoryLinker(this.repoConfig.getLinker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Linker getLinker() {
        Object object = this.linkerInitLock;
        synchronized (object) {
            if (this.linker == null) {
                this.setupLinker();
            }
            return this.linker;
        }
    }

    private void setupRepositoryHidden(HideDirType[] hiddendirs) {
        for (HideDirType hidden : hiddendirs) {
            AntGlob glob = new AntGlob(hidden.getPattern(), hidden.getCasesensitive());
            this.hideDirectoryPatterns.add(glob);
        }
    }

    private void setupRepositoryAllows(List<IncludeTree> allowDirs, List<AntGlob> disallowPatterns, AllowType allow) {
        AllowType.Exclude[] excludes;
        AllowType.Include[] includeDirs;
        for (AllowType.Include includeDir : includeDirs = allow.getIncludeArray()) {
            String dir = includeDir.getTree();
            allowDirs.add(new IncludeTree(new Path(dir), includeDir.getCasesensitive()));
        }
        for (AllowType.Exclude exclude : excludes = allow.getExcludeArray()) {
            AntGlob glob = new AntGlob(exclude.getPattern(), exclude.getCasesensitive());
            disallowPatterns.add(glob);
        }
    }

    public TarballConfig getTarballConfig() {
        return this.tarballConfig;
    }

    public List<AntGlob> getHideDirectoryPatterns() {
        return this.hideDirectoryPatterns;
    }

    public String getName() {
        return this.name;
    }

    public Analyzer getMasterAnalyzer() {
        return this.masterAnalyzer;
    }

    public List<String> getAllowedGroups() {
        return this.repoConfig.getSecurity().getUseDefaults() ? this.asList(this.getRepositoryDefaults().getSecurity().getRequiredGroups()) : this.asList(this.repoConfig.getSecurity().getRequiredGroups());
    }

    public boolean isAnonAccessAllowed() {
        return this.repoConfig.getSecurity().getUseDefaults() ? this.getRepositoryDefaults().getSecurity().getAllowAnon() : this.repoConfig.getSecurity().getAllowAnon();
    }

    public boolean isLoggedInAccessAllowed() {
        return this.repoConfig.getSecurity().getUseDefaults() ? this.getRepositoryDefaults().getSecurity().getAllowLoggedIn() : this.repoConfig.getSecurity().getAllowLoggedIn();
    }

    public boolean isAnonWriteAllowed() {
        return this.repoConfig.getSecurity().getUseDefaults() ? this.getRepositoryDefaults().getSecurity().getAllowAnonWrite() : this.repoConfig.getSecurity().getAllowAnonWrite();
    }

    public boolean isLoggedInWriteAllowed() {
        return this.repoConfig.getSecurity().getUseDefaults() ? this.getRepositoryDefaults().getSecurity().getAllowLoggedInWrite() : this.repoConfig.getSecurity().getAllowLoggedInWrite();
    }

    public boolean isSetCustom() {
        return this.repoConfig.getSecurity().getUseDefaults() ? this.getRepositoryDefaults().getSecurity().isSetCustom() : this.repoConfig.getSecurity().isSetCustom();
    }

    public List<String> getAllowedWriteGroups() {
        return this.repoConfig.getSecurity().getUseDefaults() ? this.asList(this.getRepositoryDefaults().getSecurity().getRequiredWriteGroups()) : this.asList(this.repoConfig.getSecurity().getRequiredWriteGroups());
    }

    private List<String> asList(GroupListType groups) {
        LinkedList<String> result = new LinkedList<String>();
        for (int i2 = 0; i2 < groups.sizeOfGroupArray(); ++i2) {
            GroupType g2 = groups.getGroupArray(i2);
            result.add(g2.getName());
        }
        return result;
    }

    public File getCacheDir() {
        return new File(AppConfig.getVarDir(), "cache/" + this.getName());
    }

    public File getRevCacheDir() {
        return new File(this.getCacheDir(), "revcache");
    }

    public File getCachePropertiesFile() {
        return new File(this.getCacheDir(), "cache.properties");
    }

    public File getTempDir() {
        return new File(AppConfig.getTempDir(), this.getName());
    }

    public CustomRepositoryConfigType getCustomAuthConstraint() {
        RepSecurityType sec = this.repoConfig.getSecurity();
        if (sec.isSetCustom()) {
            return sec.getCustom();
        }
        sec = this.getRepositoryDefaults().getSecurity();
        return sec.getCustom();
    }

    public boolean isEnabled() {
        return this.repoConfig.getEnabled();
    }

    @Override
    public boolean isContentIndexingEnabled() {
        if (AppConfig.Hacks.DISABLE_CONTENT_INDEXING) {
            return false;
        }
        if (this.repoConfig.isSetTextIndexer()) {
            return this.repoConfig.getTextIndexer().getEnabled();
        }
        return this.getRepositoryDefaults().getTextIndexer().getEnabled();
    }

    public boolean isHitHighlightingEnabled() {
        return this.isStoreDiffs();
    }

    public boolean isWatchesEnabled() {
        if (this.repoConfig.isSetWatches()) {
            return this.repoConfig.getWatches().getEnabled();
        }
        return this.getRepositoryDefaults().getWatches().getEnabled();
    }

    public ScmType getRepositoryType() {
        return this.scmConfig.getRepositoryType();
    }

    @Override
    public RepositoryStatus getStatus() {
        return this.status;
    }

    public RepositoryType getRepositoryTypeConfig() {
        return this.repoConfig;
    }

    @Override
    public long getMaxIndexableSize() {
        return this.maxIndexableSize;
    }

    @Override
    public boolean isOfIndexableSize(Path path, long size, String revision) {
        if (size >= this.getMaxIndexableSize()) {
            StringBuffer sb = new StringBuffer();
            sb.append("[").append(this.getName()).append("] ").append(path);
            if (revision != null) {
                sb.append("@").append(revision);
            }
            sb.append(" exceeds indexing size limit (").append(FileUtils.formatFileSize(size)).append(", limit is ").append(FileUtils.formatFileSize(this.getMaxIndexableSize())).append(").  ");
            if (this.isTextFileLimitEnabled()) {
                sb.append("The contents of this files won't be searchable in FishEye or viewable in the user interface of FishEye or Crucible, and it won't count towards line of code counts.");
                Logs.APP_LOG.info((Object)sb);
            } else {
                sb.append("The contents of this file won't be searchable in FishEye.");
                Logs.APP_LOG.warn((Object)sb);
            }
            return false;
        }
        return true;
    }

    public void testConnection() throws ConfigException {
        this.scmConfig.testConnection(this);
    }

    public boolean isAllowChangesetDiscussions() {
        if (this.getRepositoryTypeConfig().isSetChangesetDiscussions()) {
            return this.getRepositoryTypeConfig().getChangesetDiscussions().getEnabled();
        }
        return AppConfig.getsConfig().getConfig().getRepositoryDefaults().getChangesetDiscussions().getEnabled();
    }

    public boolean isLocEnabled() {
        return this.getRepositoryType() != ScmType.HG && this.getRepositoryType() != ScmType.GIT;
    }

    public boolean isAuthorLocEnabled() {
        return this.isLocEnabled() && this.isStoreDiffs();
    }

    public boolean isSupportsBranchFilter() {
        return this.getRepositoryType() != ScmType.CLEARCASE;
    }

    public boolean isSupportsCompletelyLogicalBranches() {
        return this.getRepositoryType() != ScmType.SVN;
    }

    public boolean isSupportsCommitGraph() {
        return this.getRepositoryType() != ScmType.CLEARCASE;
    }

    private boolean isTextFileLimitEnabled() {
        return this.getRepositoryType() == ScmType.SVN;
    }

    public int getSoftwareCacheVersion() {
        return this.scmConfig.getSoftwareCacheVersion();
    }

    public RepositoryDefaultsType getRepositoryDefaults() {
        return this.rootConfig.getConfig().getRepositoryDefaults();
    }
}

