/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class Path
implements Serializable,
Comparable<Path> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("/");
    private static final Pattern SLOSH_SPLIT_PATTERN = Pattern.compile("[/|\\\\]");
    private static final String[] EMPTY = new String[0];
    private static final Interner<String> interner = Interners.newWeakInterner();
    public static final Path ROOT = new Path(EMPTY);
    private final String[] path;
    private String stringRep = null;
    private String urlRep = null;

    private static String[] internAll(String[] components) {
        for (int i2 = 0; i2 < components.length; ++i2) {
            components[i2] = (String)interner.intern((Object)components[i2]);
        }
        return components;
    }

    private Path(String[] path) {
        this.path = path;
    }

    public Path(CharSequence path) {
        this.path = Path.internAll(Path.split(path));
    }

    public Path(CharSequence path, boolean allowSloshes) {
        this.path = Path.internAll(Path.split(path, allowSloshes));
    }

    public Path(Path aParent, String aPath) {
        this.path = Path.join(aParent.path, Path.internAll(Path.split(aPath)));
    }

    public Path(Path aParent, Path aPath) {
        this.path = Path.join(aParent.path, aPath.path);
    }

    public Path(Path aParent, String aPath, boolean allowSloshes) {
        this.path = Path.join(aParent.path, Path.internAll(Path.split(aPath, allowSloshes)));
    }

    public Path(String aParent, Path aPath) {
        this.path = Path.join(Path.internAll(Path.split(aParent)), aPath.path);
    }

    public Path(List<String> start) {
        this(Path.internAll(start.toArray(new String[start.size()])));
    }

    @Deprecated
    public Path(Path path) {
        this.path = path.path;
    }

    public Path getParent() {
        if (this.path.length == 0) {
            return this;
        }
        String[] comp = new String[this.path.length - 1];
        System.arraycopy(this.path, 0, comp, 0, comp.length);
        return new Path(comp);
    }

    public String getPath() {
        if (this.stringRep == null) {
            StringBuilder buf = new StringBuilder();
            String sep = "";
            for (String path : this.path) {
                buf.append(sep).append(path);
                sep = "/";
            }
            this.stringRep = buf.toString();
        }
        return this.stringRep;
    }

    public String[] getComponents() {
        return this.copy(this.path.length);
    }

    public Path[] getPathComponents() {
        Path[] paths = new Path[this.path.length + 1];
        for (int i2 = 0; i2 <= this.path.length; ++i2) {
            paths[i2] = new Path(this.copy(i2));
        }
        return paths;
    }

    public boolean isAncestor(Path descendant) {
        String[] child = descendant.path;
        String[] parent = this.path;
        if (child.length <= parent.length) {
            return false;
        }
        for (int i2 = 0; i2 < parent.length; ++i2) {
            if (parent[i2].equals(child[i2])) continue;
            return false;
        }
        return true;
    }

    public Path getCommonRoot(Path other) {
        int i2;
        int limit = Math.min(this.path.length, other.path.length);
        for (i2 = 0; i2 < limit && this.path[i2].equals(other.path[i2]); ++i2) {
        }
        if (i2 == 0) {
            return ROOT;
        }
        return new Path(this.copy(i2));
    }

    public Path getStripTail(Path other, boolean caseSensitive) {
        if (this.path.length < other.path.length) {
            return null;
        }
        for (int i2 = 0; i2 < other.path.length; ++i2) {
            String component1 = this.path[this.path.length - i2 - 1];
            String component2 = other.path[other.path.length - i2 - 1];
            if (!(caseSensitive ? !component1.equals(component2) : !component1.equalsIgnoreCase(component2))) continue;
            return null;
        }
        return this.getSubPath(this.path.length - other.path.length);
    }

    public Path getRelativePath(Path aStartPath) {
        return this.getRelativePath(aStartPath, true);
    }

    public Path getRelativePath(Path aStartPath, boolean caseSensitive) {
        List<String> start = Path.simplify(aStartPath.path);
        if (start.isEmpty()) {
            return this;
        }
        List<String> us = Path.simplify(this.path);
        while (start.size() > 0 && us.size() > 0 && this.isEqualFirstComponent(start, us, caseSensitive)) {
            start.remove(0);
            us.remove(0);
        }
        int nback = start.size();
        for (int i2 = 0; i2 < nback; ++i2) {
            start.add("..");
            start.add("..");
        }
        start.addAll(us);
        return new Path(Path.simplify(start.toArray(new String[start.size()])));
    }

    private boolean isEqualFirstComponent(List<String> start, List<String> us, boolean caseSensitive) {
        String lhs = start.get(0);
        String rhs = us.get(0);
        return caseSensitive && lhs.equals(rhs) || lhs.equalsIgnoreCase(rhs);
    }

    public String getName() {
        if (this.path.length == 0) {
            return "";
        }
        return this.path[this.path.length - 1];
    }

    public String toString() {
        return this.getPath();
    }

    public Path simplify() {
        List<String> simplify = Path.simplify(this.path);
        return new Path(simplify.toArray(new String[simplify.size()]));
    }

    public boolean isAbove() {
        return this.path.length > 0 && this.path[0].equals("..");
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Path)) {
            return false;
        }
        Path path = (Path)o2;
        return Arrays.equals(this.path, path.path);
    }

    public int hashCode() {
        int result = 0;
        for (String s2 : this.path) {
            result += s2.hashCode();
        }
        return result;
    }

    private static List<String> simplify(String[] aPath) {
        String s0;
        ArrayList path = Lists.newArrayList((Object[])aPath);
        for (int i2 = 0; i2 < path.size(); ++i2) {
            String s1 = (String)path.get(i2);
            if ("..".equals(s1) && i2 > 0) {
                String s02 = (String)path.get(i2 - 1);
                if ("..".equals(s02)) continue;
                path.remove(i2--);
                path.remove(i2--);
                continue;
            }
            if (!".".equals(s1)) continue;
            path.remove(i2--);
        }
        if (path.size() == 1 && (s0 = (String)path.get(0)).length() == 0) {
            path.remove(0);
        }
        return path;
    }

    private static String[] join(String[] aLeft, String[] aRight) {
        int left = aLeft.length;
        int right = aRight.length;
        String[] result = new String[left + right];
        System.arraycopy(aLeft, 0, result, 0, left);
        System.arraycopy(aRight, 0, result, left, right);
        return result;
    }

    public static String join(String a2, String b2) {
        if (a2 == null) {
            a2 = "";
        }
        if (b2 == null) {
            b2 = "";
        }
        if (a2.length() == 0) {
            return b2;
        }
        if (b2.length() == 0) {
            return a2;
        }
        if (a2.endsWith("/")) {
            a2 = a2.substring(0, a2.length() - 1);
        }
        if (b2.startsWith("/")) {
            b2 = b2.substring(1);
        }
        return a2 + "/" + b2;
    }

    public static String[] split(CharSequence aPath) {
        return Path.split(aPath, false);
    }

    public static String[] split(CharSequence aPath, boolean allowSloshes) {
        if (aPath == null || aPath.length() == 0) {
            return EMPTY;
        }
        if (aPath.length() > 0 && aPath.charAt(0) == '/') {
            aPath = aPath.subSequence(1, aPath.length());
        }
        if (aPath.length() == 0) {
            return EMPTY;
        }
        Pattern splitPattern = allowSloshes ? SLOSH_SPLIT_PATTERN : SPLIT_PATTERN;
        return splitPattern.split(aPath);
    }

    public boolean isRoot() {
        return this.path.length == 0 || this.path.length == 1 && this.path[0].length() == 0;
    }

    public Path trimFirst() {
        return this.trimFirst(1);
    }

    public Path trimFirst(int n2) {
        if (this.path.length == 0) {
            return this;
        }
        int newLen = this.path.length - n2;
        if (newLen <= 0) {
            return ROOT;
        }
        String[] p2 = new String[newLen];
        System.arraycopy(this.path, n2, p2, 0, p2.length);
        return new Path(p2);
    }

    public Path trimLast() {
        if (this.path.length == 0) {
            return this;
        }
        if (this.path.length == 1) {
            return ROOT;
        }
        String[] p2 = new String[this.path.length - 1];
        System.arraycopy(this.path, 0, p2, 0, p2.length);
        return new Path(p2);
    }

    public String getComponent(int i2) {
        return this.path[i2];
    }

    public int numComponents() {
        return this.path.length;
    }

    public int getNumComponents() {
        return this.numComponents();
    }

    @Override
    public int compareTo(Path o2) {
        if (o2 == null) {
            return -1;
        }
        String[] path = o2.path;
        for (int i2 = 0; i2 < this.path.length && i2 < path.length; ++i2) {
            String a2 = this.path[i2];
            String b2 = path[i2];
            int r2 = a2.compareTo(b2);
            if (r2 == 0) continue;
            return r2;
        }
        if (this.path.length < path.length) {
            return -1;
        }
        if (path.length < this.path.length) {
            return 1;
        }
        return 0;
    }

    public static String parseName(String p2) {
        int idx = p2.lastIndexOf("/");
        if (idx == -1) {
            return p2;
        }
        return p2.substring(idx + 1);
    }

    public static String parseDir(String p2) {
        int idx = p2.lastIndexOf("/");
        if (idx == -1) {
            return "";
        }
        return p2.substring(0, idx);
    }

    public Path abbreviate(int maxLength) {
        return this.abbreviateImpl((int)maxLength).path;
    }

    public Path[] abbreviatePathComponents(int maxLength) {
        List<Path> pc = this.abbreviateImpl((int)maxLength).pathComponents;
        return pc.toArray(new Path[pc.size()]);
    }

    public String getAsUrl() {
        if (this.urlRep == null) {
            StringBuilder buf = new StringBuilder();
            String sep = "";
            for (String path : this.path) {
                buf.append(sep).append(FishEyeURLEncoder.uriEncode(path));
                sep = "/";
            }
            this.urlRep = buf.toString();
        }
        return this.urlRep;
    }

    private AbbrevResult abbreviateImpl(int maxLength) {
        String ellipses = "...";
        if (this.path.length <= 2) {
            return new AbbrevResult(this, Arrays.asList(this.getPathComponents()));
        }
        int len = this.getPath().length();
        if (len <= maxLength) {
            return new AbbrevResult(this, Arrays.asList(this.getPathComponents()));
        }
        ArrayList components = Lists.newArrayList((Object[])this.path);
        ArrayList pathComponents = Lists.newArrayList((Object[])this.getPathComponents());
        int insertEllipsesAt = components.size() / 2;
        while (len > maxLength && components.size() > 2) {
            int midPoint = components.size() / 2;
            insertEllipsesAt = Math.min(insertEllipsesAt, midPoint);
            String s2 = (String)components.remove(midPoint);
            pathComponents.remove(midPoint);
            len -= s2.length() + 1;
        }
        components.add(insertEllipsesAt, "...");
        pathComponents.add(insertEllipsesAt, null);
        return new AbbrevResult(new Path(components.toArray(new String[components.size()])), pathComponents);
    }

    public boolean hasPrefix(Path p2) {
        return this.hasPrefix(p2, true);
    }

    public boolean hasPrefix(Path p2, boolean caseSensitive) {
        if (p2.numComponents() > this.numComponents()) {
            return false;
        }
        for (int i2 = 0; i2 < p2.path.length; ++i2) {
            String p1 = p2.path[i2];
            String p0 = this.path[i2];
            if ((!caseSensitive || p1.equals(p0)) && p1.equalsIgnoreCase(p0)) continue;
            return false;
        }
        return true;
    }

    public Path normalize() {
        ArrayList components = Lists.newArrayList((Object[])this.path);
        int i2 = 0;
        while (i2 < components.size()) {
            String component = (String)components.get(i2);
            if (component.equals(".")) {
                components.remove(i2);
                continue;
            }
            if (component.equals("..") && i2 != 0) {
                String previous = (String)components.get(i2 - 1);
                if (!previous.equals("..")) {
                    components.remove(i2);
                    components.remove(i2 - 1);
                    --i2;
                    continue;
                }
                ++i2;
                continue;
            }
            ++i2;
        }
        return new Path(components.toArray(new String[components.size()]));
    }

    public String getPath(boolean caseSensitive) {
        String normalized = caseSensitive ? this.getPath() : this.getPath().toLowerCase(Locale.US);
        return normalized;
    }

    public Path getSubPath(int depth) {
        return new Path(this.copy(Math.min(depth, this.path.length)));
    }

    private String[] copy(int i2) {
        String[] comp = new String[i2];
        System.arraycopy(this.path, 0, comp, 0, i2);
        return comp;
    }

    public Path getPathHead() {
        if (this.path.length == 0) {
            return this;
        }
        return new Path(this.path[0]);
    }

    public String getTail() {
        return this.trimFirst(1).getPath();
    }

    public Path getTailPath() {
        return this.trimFirst(1);
    }

    public String getExtension() {
        String file;
        int dot;
        String extn = null;
        if (this.path.length > 0 && (dot = (file = this.getComponent(this.path.length - 1)).lastIndexOf(".")) != -1 && dot != file.length() - 1) {
            extn = file.substring(dot + 1);
        }
        return extn;
    }

    private static class AbbrevResult {
        final Path path;
        final List<Path> pathComponents;

        public AbbrevResult(Path path, List<Path> pathComponents) {
            this.path = path;
            this.pathComponents = pathComponents;
        }
    }
}

