/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.license.LicenseInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FisheyeVersionInfo {
    public static final String RELEASE_NUM = "4.0.4";
    public static final String BUILD_DATE = "2016-05-06";
    public static final String BUILD_NUMBER = "20160506105158";
    public static final String BUILD_STAMP_FILE = "buildstamp.txt";
    public static final String BUILD_STAMP = FisheyeVersionInfo.readBuildStamp();

    public String getReleaseNum() {
        return RELEASE_NUM;
    }

    public String getBuildDate() {
        return BUILD_DATE;
    }

    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public LicenseInfo getLicense() {
        return AppConfig.getsConfig().getLicense();
    }

    public String getSid() {
        return AppConfig.getsConfig().getConfig().getLicense().getSID();
    }

    private static String readBuildStamp() {
        try {
            InputStreamReader in;
            InputStream is = FisheyeVersionInfo.class.getClassLoader().getResourceAsStream(BUILD_STAMP_FILE);
            if (is != null && (in = new InputStreamReader(is)) != null) {
                return IOHelper.copyReaderToString(in).trim();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return null;
    }
}

