/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Function;
import java.util.Arrays;
import javax.annotation.Nonnull;

public final class FishEyeSysProps {
    public static final String FISHEYE_PROP_PREFIX = "fisheye.";
    public static final String RECENTLY_ACTIVE_BRANCH_CHECK_LIMIT_PROP = "fisheye.branch.recently.active.check.limit";
    public static final String SEARCH_MAX_REPOSITORIES_PROP = "fisheye.search.max.repositories";
    public static final String P4_ANCESTRY_DISABLE_PROP = "fisheye.p4.disable.ancestry";
    public static final String P4_BRANCH_SPEC_DISABLE_PROP = "fisheye.p4.disable.branchspecs";
    public static final String P4_CLIENTPOOL_MAX_CLIENTS_PROP = "fisheye.p4.clientpool.max.clients";
    public static final String SVN_ANCESTRY_PROCESSING_PROP = "fisheye.svn.ancestry.processing";
    public static final String SVN_PROPERTIES_ON_ADD_PROP = "fisheye.svn.properties.on.add";
    public static final String CHANGESET_PATHS_LIMIT_PROP = "fisheye.changeset.paths.limit";
    public static final String PATH_DOCS_PER_BATCH_PROP = "fisheye.path.docs.per.batch";
    public static final String WEIGHTED_CHANGESET_DOCS_PER_BATCH_PROP = "fisheye.weighted.changeset.docs.per.batch";
    public static final String PATH_INDEXER_CACHE_SIZE_PROP = "fisheye.path.indexer.cache.size";
    public static final String LUCENE_BOOLEAN_QUERY_MAX_CLAUSE_COUNT_PROP = "fisheye.lucene.boolean.query.max.clause.count";
    public static final String SUFFIX_PATHS_PROP = "fisheye.disable.suffixpaths";
    public static final String SVN_INDEX_TRUNK_CONTENT_ONLY_PROP = "fisheye.svn.index.trunk.content.only";
    public static final String SVN_TAG_COMBINED_DIFF_THRESHOLD_PROP = "fisheye.svn.tag.combined.diff.threshold";
    public static final String CLEARCASE_DISABLE = "fisheye.clearcase.disable";
    public static final String MANAGED_REPOS_CONVERT = "fisheye.managed.repos.convert";
    public static final String JIRA_ACTIVITY_ENABLE_PROP = "fisheye.jira.activity.enable";
    public static final String JETTY_JMX_ENABLE_PROP = "fisheye.jetty.jmx.enable";
    public static final String ENABLE_PDL_PROP = "fisheye.pdl.enable";
    public static final String PIPELINE_THREAD_COUNT_PROP = "fisheye.pipeline.threads";
    public static final String PIPELINE_FAIRNESS_PROP = "fisheye.pipeline.fairness";
    public static final String PIPELINE_BATCH_CSLIMIT_PROP = "fisheye.pipeline.batch.cslimit";
    public static final String PIPELINE_BATCH_PATHLIMIT_PROP = "fisheye.pipeline.batch.pathlimit";
    public static final String SMART_COMMIT_TRIGGER_LIMIT_DAYS_PROP = "fisheye.commithook.smartcommit.limit";
    public static final String SSH_KEYSIZE_PROP = "fisheye.ssh.keysize";
    public static final String SSH_KEYPOOL_SIZE_PROP = "fisheye.ssh.keypool.size";
    public static final String MANIFEST_MAXDEPTH_PROP = "fisheye.manifest.maxdepth";
    public static final String MANIFEST_UPGRADEPATHS_PROP = "fisheye.manifest.maxupgradepaths";
    public static final String MANIFEST_UPGRADE_FORCE = "fisheye.manifest.forceupgrade";
    public static final String MANIFEST_UPGRADE_BATCH = "fisheye.manifest.upgradebatch";
    public static final String SELECTION_HISTORY_PROP = "fisheye.selection.history";
    public static final String AVATAR_TTL_MINUTES_PROP = "fisheye.avatar.ttl.mins";
    public static final String BLAME_CALC_PROP = "fisheye.blame.calc.enable";
    public static final String BLAME_SCM_FALLBACK_ENABLE_PROP = "fisheye.blame.scm.fallback.enable";
    public static final String SVN_EARLIEST_IN_STATE_IGNORE_MISSING_CHANGESETS_PROP = "fisheye.svn.earliest.in.state.ignore.missing.changesets";
    public static final String PASSIVATION_GC_INTERVAL_PROP = "fisheye.passivation.gcinterval";
    public static final String PASSIVATION_GC_THRESHOLD_PROP = "fisheye.passivation.gcthreshold";
    public static final String GIT_SCANNED_CHANGESET_INDEXING_TIMELIMIT_SECONDS_PROP = "fisheye.git.backscanning.timelimit";
    public static final String CSDBIDS_IN_TOPOLOGICAL_ORDER_PROP = "fisheye.csdbids.in.topological.order";
    public static final String ENABLE_REQUEST_BLAME_CALCULATION_PROP = "fisheye.enable.request.blame.calculation";
    public static final Function<String, Integer> INT_PARSER = new Function<String, Integer>(){

        public Integer apply(@Nonnull String input) {
            return Integer.valueOf(input);
        }
    };
    public static final Function<String, Long> LONG_PARSER = new Function<String, Long>(){

        public Long apply(@Nonnull String input) {
            return Long.valueOf(input);
        }
    };
    public static final Function<String, Double> DOUBLE_PARSER = new Function<String, Double>(){

        public Double apply(@Nonnull String input) {
            return Double.valueOf(input);
        }
    };
    public static final Function<String, Boolean> BOOLEAN_PARSER = new Function<String, Boolean>(){

        public Boolean apply(@Nonnull String input) {
            return Boolean.valueOf(input);
        }
    };
    public static int RECENTLY_ACTIVE_BRANCH_CHECK_LIMIT = 250;
    public static int SEARCH_MAX_REPOSITORIES = 100;
    public static boolean P4_ANCESTRY_DISABLE = false;
    public static boolean P4_BRANCH_SPEC_DISABLE = false;
    public static int P4_CLIENTPOOL_MAX_CLIENTS = 50;
    public static int CHANGESET_PATHS_LIMIT = 10000;
    public static int PATH_DOCS_PER_BATCH = 20000;
    public static int WEIGHTED_CHANGESET_DOCS_PER_BATCH = 36000;
    public static int PATH_INDEXER_CACHE_SIZE = 100000;
    public static int LUCENE_BOOLEAN_QUERY_MAX_CLAUSE_COUNT = 10000;
    public static boolean SUFFIX_PATHS_DISABLE = false;
    public static boolean SVN_INDEX_TRUNK_CONTENT_ONLY = false;
    public static boolean JIRA_ACTIVITY_ENABLED = false;
    public static boolean jettyJmxEnabled = false;
    public static boolean ENABLE_PDL = true;
    public static boolean BLAME_CALC_ENABLED = true;
    public static boolean BLAME_SCM_FALLBACK_ENABLED = false;
    public static final int PIPELINE_MIN_THREADS = 4;
    public static final int PIPELINE_MAX_THREADS = 1000;
    public static final int PIPELINE_MAX_BATCH_CSLIMIT = 50000;
    public static final int PIPELINE_MIN_BATCH_PATHLIMIT = 1000;
    public static final int PIPELINE_MAX_BATCH_PATHLIMIT = 120000;
    public static int PIPELINE_THREAD_COUNT = Math.max(4, Runtime.getRuntime().availableProcessors());
    public static int PIPELINE_METADATA_THREAD_COUNT = 4;
    public static int PIPELINE_INDEXING_THREAD_COUNT = 4;
    public static int PIPELINE_BATCH_CSLIMIT = 10000;
    public static int PIPELINE_BATCH_PATHLIMIT = 60000;
    public static boolean PIPELINE_FAIRNESS = true;
    public static int SVN_TAG_COMBINED_DIFF_THRESHOLD = 200;
    public static int SMART_COMMIT_TRIGGER_LIMIT_DAYS = 30;
    public static final int SSH_MIN_KEYSIZE = 1024;
    public static final int SSH_MAX_KEYSIZE = 16384;
    public static int SSH_KEYSIZE = 4096;
    public static int SSH_KEYPOOL_SIZE = 10;
    public static int maxManifestDepth = 3;
    public static int maxManifestUpgradePaths = 500000;
    public static boolean forceManifestUpgrade = true;
    public static int manifestUpgradeBatchSize;
    public static boolean SELECTION_HISTORY;
    public static final int AVATAR_TTL_MINUTES_MIN = 1;
    public static final int AVATAR_TTL_MINUTES_MAX = 1440;
    public static int AVATAR_TTL_MINUTES;
    public static long PASSIVATION_GC_INTERVAL_MS;
    public static double PASSIVATION_GC_THRESHOLD;
    public static int GIT_SCANNED_CHANGESET_INDEXING_TIMELIMIT_SECONDS;
    public static boolean CSDBIDS_TOPOLOGICAL_ORDER;
    public static boolean ENABLE_REQUEST_BLAME_CALCULATION;
    public static SvnAncestryProcessing SVN_ANCESTRY_PROCESSING;
    public static SvnPropertiesOnAdd SVN_PROPERTIES_ON_ADD;

    private static void calculatePipelineThreadpoolSizes() {
        PIPELINE_INDEXING_THREAD_COUNT = PIPELINE_THREAD_COUNT / 2;
        PIPELINE_METADATA_THREAD_COUNT = PIPELINE_THREAD_COUNT - PIPELINE_INDEXING_THREAD_COUNT;
    }

    public static void reloadProperties() {
        RECENTLY_ACTIVE_BRANCH_CHECK_LIMIT = FishEyeSysProps.loadIntProperty(RECENTLY_ACTIVE_BRANCH_CHECK_LIMIT_PROP, RECENTLY_ACTIVE_BRANCH_CHECK_LIMIT);
        SEARCH_MAX_REPOSITORIES = FishEyeSysProps.loadIntProperty(SEARCH_MAX_REPOSITORIES_PROP, SEARCH_MAX_REPOSITORIES);
        P4_ANCESTRY_DISABLE = FishEyeSysProps.loadBooleanProperty(P4_ANCESTRY_DISABLE_PROP, P4_ANCESTRY_DISABLE);
        P4_BRANCH_SPEC_DISABLE = FishEyeSysProps.loadBooleanProperty(P4_BRANCH_SPEC_DISABLE_PROP, P4_BRANCH_SPEC_DISABLE);
        P4_CLIENTPOOL_MAX_CLIENTS = FishEyeSysProps.loadIntProperty(P4_CLIENTPOOL_MAX_CLIENTS_PROP, P4_CLIENTPOOL_MAX_CLIENTS);
        SVN_ANCESTRY_PROCESSING = FishEyeSysProps.loadEnumProperty(SVN_ANCESTRY_PROCESSING_PROP, SvnAncestryProcessing.class, SVN_ANCESTRY_PROCESSING);
        SVN_PROPERTIES_ON_ADD = FishEyeSysProps.loadEnumProperty(SVN_PROPERTIES_ON_ADD_PROP, SvnPropertiesOnAdd.class, SVN_PROPERTIES_ON_ADD);
        CHANGESET_PATHS_LIMIT = FishEyeSysProps.loadIntProperty(CHANGESET_PATHS_LIMIT_PROP, CHANGESET_PATHS_LIMIT);
        PATH_DOCS_PER_BATCH = FishEyeSysProps.loadIntProperty(PATH_DOCS_PER_BATCH_PROP, PATH_DOCS_PER_BATCH);
        WEIGHTED_CHANGESET_DOCS_PER_BATCH = FishEyeSysProps.loadIntProperty(WEIGHTED_CHANGESET_DOCS_PER_BATCH_PROP, WEIGHTED_CHANGESET_DOCS_PER_BATCH);
        PATH_INDEXER_CACHE_SIZE = FishEyeSysProps.loadIntProperty(PATH_INDEXER_CACHE_SIZE_PROP, PATH_INDEXER_CACHE_SIZE);
        LUCENE_BOOLEAN_QUERY_MAX_CLAUSE_COUNT = FishEyeSysProps.loadIntProperty(LUCENE_BOOLEAN_QUERY_MAX_CLAUSE_COUNT_PROP, LUCENE_BOOLEAN_QUERY_MAX_CLAUSE_COUNT);
        SUFFIX_PATHS_DISABLE = FishEyeSysProps.loadBooleanProperty(SUFFIX_PATHS_PROP, SUFFIX_PATHS_DISABLE);
        SVN_INDEX_TRUNK_CONTENT_ONLY = FishEyeSysProps.loadBooleanProperty(SVN_INDEX_TRUNK_CONTENT_ONLY_PROP, SVN_INDEX_TRUNK_CONTENT_ONLY);
        SVN_TAG_COMBINED_DIFF_THRESHOLD = FishEyeSysProps.loadIntProperty(SVN_TAG_COMBINED_DIFF_THRESHOLD_PROP, SVN_TAG_COMBINED_DIFF_THRESHOLD);
        JIRA_ACTIVITY_ENABLED = FishEyeSysProps.loadBooleanProperty(JIRA_ACTIVITY_ENABLE_PROP, JIRA_ACTIVITY_ENABLED);
        jettyJmxEnabled = FishEyeSysProps.loadBooleanProperty(JETTY_JMX_ENABLE_PROP, jettyJmxEnabled);
        ENABLE_PDL = FishEyeSysProps.loadBooleanProperty(ENABLE_PDL_PROP, ENABLE_PDL);
        PIPELINE_THREAD_COUNT = FishEyeSysProps.loadIntProperty(PIPELINE_THREAD_COUNT_PROP, 4, 1000, PIPELINE_THREAD_COUNT);
        PIPELINE_FAIRNESS = FishEyeSysProps.loadBooleanProperty(PIPELINE_FAIRNESS_PROP, PIPELINE_FAIRNESS);
        PIPELINE_BATCH_CSLIMIT = FishEyeSysProps.loadIntProperty(PIPELINE_BATCH_CSLIMIT_PROP, 1, 50000, PIPELINE_BATCH_CSLIMIT);
        PIPELINE_BATCH_PATHLIMIT = FishEyeSysProps.loadIntProperty(PIPELINE_BATCH_PATHLIMIT_PROP, 1000, 120000, PIPELINE_BATCH_PATHLIMIT);
        SSH_KEYSIZE = FishEyeSysProps.loadIntProperty(SSH_KEYSIZE_PROP, 1024, 16384, SSH_KEYSIZE);
        SSH_KEYPOOL_SIZE = FishEyeSysProps.loadIntProperty(SSH_KEYPOOL_SIZE_PROP, SSH_KEYPOOL_SIZE);
        SELECTION_HISTORY = FishEyeSysProps.loadBooleanProperty(SELECTION_HISTORY_PROP, false);
        FishEyeSysProps.calculatePipelineThreadpoolSizes();
        SMART_COMMIT_TRIGGER_LIMIT_DAYS = FishEyeSysProps.loadIntProperty(SMART_COMMIT_TRIGGER_LIMIT_DAYS_PROP, SMART_COMMIT_TRIGGER_LIMIT_DAYS);
        maxManifestDepth = FishEyeSysProps.loadIntProperty(MANIFEST_MAXDEPTH_PROP, 1, 100, maxManifestDepth);
        maxManifestUpgradePaths = FishEyeSysProps.loadIntProperty(MANIFEST_UPGRADEPATHS_PROP, 100, Integer.MAX_VALUE, maxManifestUpgradePaths);
        forceManifestUpgrade = FishEyeSysProps.loadBooleanProperty(MANIFEST_UPGRADE_FORCE, true);
        manifestUpgradeBatchSize = FishEyeSysProps.loadIntProperty(MANIFEST_UPGRADE_BATCH, 10, Integer.MAX_VALUE, 1000);
        AVATAR_TTL_MINUTES = FishEyeSysProps.loadIntProperty(AVATAR_TTL_MINUTES_PROP, 1, 1440, AVATAR_TTL_MINUTES);
        BLAME_CALC_ENABLED = FishEyeSysProps.loadBooleanProperty(BLAME_CALC_PROP, BLAME_CALC_ENABLED);
        BLAME_SCM_FALLBACK_ENABLED = FishEyeSysProps.loadBooleanProperty(BLAME_SCM_FALLBACK_ENABLE_PROP, BLAME_SCM_FALLBACK_ENABLED);
        PASSIVATION_GC_INTERVAL_MS = FishEyeSysProps.loadLongProperty(PASSIVATION_GC_INTERVAL_PROP, 1000L, Long.MAX_VALUE, PASSIVATION_GC_INTERVAL_MS);
        PASSIVATION_GC_THRESHOLD = FishEyeSysProps.loadDoubleProperty(PASSIVATION_GC_THRESHOLD_PROP, 0.05f, 1.01f, PASSIVATION_GC_THRESHOLD);
        GIT_SCANNED_CHANGESET_INDEXING_TIMELIMIT_SECONDS = FishEyeSysProps.loadIntProperty(GIT_SCANNED_CHANGESET_INDEXING_TIMELIMIT_SECONDS_PROP, 1, Integer.MAX_VALUE, GIT_SCANNED_CHANGESET_INDEXING_TIMELIMIT_SECONDS);
        CSDBIDS_TOPOLOGICAL_ORDER = FishEyeSysProps.loadBooleanProperty(CSDBIDS_IN_TOPOLOGICAL_ORDER_PROP, CSDBIDS_TOPOLOGICAL_ORDER);
        ENABLE_REQUEST_BLAME_CALCULATION = FishEyeSysProps.loadBooleanProperty(ENABLE_REQUEST_BLAME_CALCULATION_PROP, ENABLE_REQUEST_BLAME_CALCULATION);
    }

    public static <T extends Enum<T>> T loadEnumProperty(String propertyName, Class<T> enumClass, T defaultValue) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            T retv = Enum.valueOf(enumClass, value);
            Logs.APP_LOG.info((Object)("System property " + propertyName + " set to value: " + retv));
            return retv;
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("System property " + propertyName + " has value " + value + ", which is invalid - using default value " + defaultValue + "; valid values: " + Arrays.toString(enumClass.getEnumConstants())));
            return defaultValue;
        }
    }

    public static int loadIntProperty(String propertyName, int defaultValue) {
        return FishEyeSysProps.loadIntProperty(propertyName, Integer.MIN_VALUE, Integer.MAX_VALUE, defaultValue);
    }

    public static int loadIntProperty(String propertyName, int min, int max, int defaultValue) {
        return FishEyeSysProps.loadProperty(propertyName, min, max, defaultValue, INT_PARSER);
    }

    public static long loadLongProperty(String propertyName, long min, long max, long defaultValue) {
        return FishEyeSysProps.loadProperty(propertyName, min, max, defaultValue, LONG_PARSER);
    }

    public static double loadDoubleProperty(String propertyName, double min, double max, double defaultValue) {
        return FishEyeSysProps.loadProperty(propertyName, min, max, defaultValue, DOUBLE_PARSER);
    }

    public static boolean loadBooleanProperty(String propertyName, boolean defaultValue) {
        return FishEyeSysProps.loadProperty(propertyName, null, null, defaultValue, BOOLEAN_PARSER);
    }

    private static <T extends Comparable<T>> T loadProperty(String propertyName, T min, T max, T defaultValue, Function<String, T> valueParser) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            Comparable retv = (Comparable)valueParser.apply((Object)value);
            return (T)FishEyeSysProps.enforceBounds(propertyName, min, max, value, retv, defaultValue);
        }
        catch (NumberFormatException e2) {
            FishEyeSysProps.warnValueFormat(propertyName, defaultValue, value);
            return defaultValue;
        }
    }

    private static <T extends Comparable<T>> T enforceBounds(String propertyName, T min, T max, String value, T retv, T defaultValue) {
        if (min != null && retv.compareTo(min) < 0) {
            Logs.APP_LOG.warn((Object)("System property " + propertyName + " has value " + value + ", which is below the allowed minimum of " + min + ". Using a value of " + min + " instead."));
            retv = min;
        } else if (max != null && retv.compareTo(max) > 0) {
            Logs.APP_LOG.warn((Object)("System property " + propertyName + " has value " + value + ", which is above the allowed maximum of " + max + ". Using a value of " + max + " instead."));
            retv = max;
        } else if (!retv.equals(defaultValue)) {
            Logs.APP_LOG.info((Object)("System property " + propertyName + " set to value: " + retv));
        } else {
            Logs.APP_LOG.debug((Object)("System property " + propertyName + " set to default value: " + retv));
        }
        return retv;
    }

    private static <T> void warnValueFormat(String propertyName, T defaultValue, String value) {
        Logs.APP_LOG.warn((Object)("System property " + propertyName + " has value " + value + ", which is invalid - using default value " + defaultValue.toString()));
    }

    static {
        AVATAR_TTL_MINUTES = 60;
        PASSIVATION_GC_INTERVAL_MS = 2000L;
        PASSIVATION_GC_THRESHOLD = 0.15;
        GIT_SCANNED_CHANGESET_INDEXING_TIMELIMIT_SECONDS = 30;
        CSDBIDS_TOPOLOGICAL_ORDER = true;
        ENABLE_REQUEST_BLAME_CALCULATION = true;
        SVN_ANCESTRY_PROCESSING = SvnAncestryProcessing.CalculateAllAncestry;
        SVN_PROPERTIES_ON_ADD = SvnPropertiesOnAdd.ReuseCopySource;
        FishEyeSysProps.reloadProperties();
    }

    public static enum SvnPropertiesOnAdd {
        Always,
        ReuseCopySource,
        None;

    }

    public static enum SvnAncestryProcessing {
        None,
        CalculateBranchesOnUpgrade,
        CalculateBasicAncestry,
        CalculateAllAncestry;


        public boolean calculateNothing() {
            return this == None;
        }

        public boolean calculateNoAncestry() {
            return this == None || this == CalculateBranchesOnUpgrade;
        }

        public boolean calculateBranchAndTagRootAncestry() {
            return this == CalculateAllAncestry;
        }
    }
}

