/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.atlassian.fugue.Iterables;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.PathAcceptor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public class ExcludeSubdirPathAcceptor
implements PathAcceptor {
    private final ImmutableCollection<Path> excludedSubdirs;

    public ExcludeSubdirPathAcceptor(String ... excludedSubdirs) {
        Preconditions.checkNotNull((Object)excludedSubdirs);
        this.excludedSubdirs = ImmutableList.copyOf((Collection)Collections2.transform(Arrays.asList(excludedSubdirs), (Function)new Function<String, Path>(){

            public Path apply(@Nullable String path) {
                Preconditions.checkState((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0);
                return new Path(path);
            }
        }));
    }

    @Override
    public boolean accept(final Path path) {
        if (null == path) {
            throw new IllegalArgumentException("Null path");
        }
        return Iterables.findFirst(this.excludedSubdirs, (Predicate)new Predicate<Path>(){

            public boolean apply(@Nullable Path excludedSubdir) {
                return path.hasPrefix(excludedSubdir);
            }
        }).isEmpty();
    }
}

