/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.ctl.ShutdownService;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.WebServer;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class AppConfig {
    private static File configurationFile;
    private static File sAppHome;
    private static File sInstanceDir;
    private static WebServer webServer;
    private static ShutdownService shutdown;
    private static boolean testMode;
    private static Boolean crucibleBinary;
    public static int DEFAULT_TAB_WIDTH;
    public static boolean noSlurp;
    public static final long START_TIME;
    private static long lastModified;

    public static boolean isMailServerConfigured() {
        return AppConfig.getsConfig().getConfig().isSetSmtp();
    }

    public static void setTestMode(boolean mode) {
        testMode = mode;
    }

    public static void setTestMode() {
        AppConfig.setTestMode(true);
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static RootConfig getsConfig() {
        return RootConfigLazySingleton.sConfig;
    }

    public static void resetConfig(RootConfig c2) {
        RootConfigLazySingleton.sConfig = c2;
    }

    public static boolean isFishEye() {
        return AppConfig.getsConfig().isFishEye();
    }

    public static boolean isCrucible() {
        return AppConfig.getsConfig().isCrucible();
    }

    public static boolean isCrucibleOnly() {
        return AppConfig.getsConfig().isCrucibleOnly();
    }

    public static boolean isFishEyeOnly() {
        return AppConfig.getsConfig().isFishEyeOnly();
    }

    public static boolean isFisheyeDownload() {
        return !AppConfig.isCrucibleDownload();
    }

    public static String getDownloadProductName() {
        return AppConfig.isFisheyeDownload() ? "FishEye" : "Crucible";
    }

    public static boolean isCrucibleDownload() {
        if (crucibleBinary == null) {
            InputStream in;
            block6: {
                in = null;
                try {
                    in = AppConfig.class.getClassLoader().getResourceAsStream("fecru-download.properties");
                    if (in == null) {
                        Logs.APP_LOG.info((Object)"Unable to locate fecru-download.properties.");
                        crucibleBinary = true;
                        break block6;
                    }
                    Properties props = new Properties();
                    props.load(in);
                    crucibleBinary = Boolean.valueOf(props.getProperty("fecru-download.crucible"));
                }
                catch (Exception e2) {
                    try {
                        Logs.APP_LOG.info((Object)"Problem loading fecru-download.properties.", (Throwable)e2);
                        crucibleBinary = true;
                    }
                    catch (Throwable throwable) {
                        IOHelper.close(in);
                        throw throwable;
                    }
                    IOHelper.close(in);
                }
            }
            IOHelper.close(in);
        }
        return crucibleBinary;
    }

    public static void setWebServer(WebServer ws) {
        webServer = ws;
    }

    public static WebServer getWebServer() {
        return webServer;
    }

    public static ShutdownService getShutdown() {
        return shutdown;
    }

    public static void setShutdown(ShutdownService shutdown) {
        AppConfig.shutdown = shutdown;
    }

    public static String getProductName() {
        return AppConfig.getsConfig().getProductName();
    }

    public static long getLastModified() {
        return lastModified;
    }

    public static void updateLastModified() {
        lastModified = System.currentTimeMillis();
    }

    public static File getVarDataDir() {
        return new File(AppConfig.getVarDir(), "data");
    }

    public static File getDataDir() {
        return new File(AppConfig.getInstanceDir(), "data");
    }

    public static File getVarDir() {
        return new File(AppConfig.getInstanceDir(), "var");
    }

    public static File getCacheDir() {
        return new File(AppConfig.getInstanceDir(), "cache");
    }

    public static File getLogDir() {
        return new File(AppConfig.getVarDir(), "log");
    }

    public static File getTempDir() {
        return new File(AppConfig.getVarDir(), "tmp");
    }

    public static File getRepositoriesDir() {
        return new File(AppConfig.getVarDir(), "cache");
    }

    private static File getOsgiCacheDirectory() {
        return new File(AppConfig.getVarDir(), "osgi-cache");
    }

    public static File createOsgiCacheDirectoryIfNonExistent() {
        return IOHelper.ensureDirectoryExists(AppConfig.getOsgiCacheDirectory());
    }

    public static File getWebAppLocation() {
        return new File(AppConfig.getAppHome(), "content");
    }

    public static File getDiffTextCacheDir() {
        return new File(AppConfig.getTempDir(), "DiffTextCache");
    }

    public static File getAppHome() {
        if (sAppHome == null) {
            String apphome = System.getProperty("fisheye.home");
            sAppHome = apphome != null ? new File(apphome).getAbsoluteFile() : new File(".").getAbsoluteFile();
        }
        return sAppHome;
    }

    public static void setAppHome(File appHome) {
        sAppHome = appHome;
    }

    public static void setInstanceDir(File instanceDir) {
        sInstanceDir = instanceDir;
        try {
            System.setProperty("fisheye.inst", instanceDir.getCanonicalPath());
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Error setting system property", (Throwable)e2);
        }
    }

    public static File getBundledDriverDir() {
        return new File(AppConfig.getAppHome(), "lib/dbdrivers");
    }

    public static File getBinDir() {
        return new File(AppConfig.getAppHome(), "bin");
    }

    public static File getInstanceDir() {
        if (sInstanceDir == null) {
            String instanceHome = System.getProperty("fisheye.inst");
            sInstanceDir = instanceHome != null ? new File(instanceHome) : AppConfig.getAppHome();
        }
        return sInstanceDir;
    }

    public static void overrideAppHome(File appHome, File instHome) {
        sAppHome = appHome;
        sInstanceDir = instHome;
    }

    public static File getConfigurationFile() {
        if (configurationFile == null) {
            configurationFile = new File(AppConfig.getInstanceDir(), "config.xml").getAbsoluteFile();
        }
        return configurationFile;
    }

    public static void setConfigurationFile(File cf) {
        configurationFile = cf;
    }

    @Deprecated
    public static TimeZone getUserTimeZone(HttpServletRequest request) {
        UserLogin user;
        TimeZone tz = null;
        if (request != null && (user = AppConfig.getsConfig().getUserManager().getCurrentUser(request)) != null) {
            try {
                tz = AppConfig.getUserTimeZone(user.getUsername());
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        if (tz == null) {
            tz = AppConfig.getsConfig().getTimezone();
        }
        return tz;
    }

    @Deprecated
    public static TimeZone getUserTimeZone(String username) throws DbException {
        String preferedTZ;
        FecruUser up;
        TimeZone tz = null;
        if (!Strings.isNullOrEmpty((String)username) && (up = AppConfig.getsConfig().getUserManager().getLicensedUser(username)) != null && (preferedTZ = up.getUserProfile().getTimezone()) != null) {
            tz = TimeZone.getTimeZone(preferedTZ);
        }
        if (tz == null) {
            tz = AppConfig.getsConfig().getTimezone();
        }
        return tz;
    }

    static {
        testMode = false;
        DEFAULT_TAB_WIDTH = 8;
        noSlurp = false;
        lastModified = START_TIME = System.currentTimeMillis();
    }

    public static class Hacks {
        public static boolean DISABLE_DIRTREE_EMPTY_CHECKS = false;
        public static boolean DISABLE_CONTENT_INDEXING = false;
        public static final boolean USE_GRAPHAEL = false;
        public static boolean DISABLE_HEAD_DETECION = false;
        public static boolean DISABLE_TAGS = false;
        public static boolean LENIENT_PATCHES = false;
        public static boolean ENABLE_GIT_CONTENT_HASH_RESOLVING_HEURISTIC = false;
    }

    private static class RootConfigLazySingleton {
        static RootConfig sConfig = new RootConfig();

        private RootConfigLazySingleton() {
        }
    }
}

