/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view.reviewfilters;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.fisheye.logging.Logs;
import java.util.HashMap;
import java.util.Map;

public class ReviewFilters {
    private FecruUser user;
    private Project project;
    private final StateManager stateMgr = StateManager.INSTANCE;

    public ReviewFilters(FecruUser user) {
        this.user = user;
    }

    public ReviewFilters(Project project) {
        this.project = project;
    }

    public FecruUser getUser() {
        return this.user;
    }

    public void setUser(FecruUser user) {
        this.user = user;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public ReviewFilterDef getFilterDefByKey(FilterKey key) {
        switch (key) {
            case INBOX: {
                return this.getInboxFilterDef();
            }
            case OUTBOX: {
                return this.getOutboxFilterDef();
            }
            case ARCHIVE: {
                return this.getArchiveFilterDef();
            }
            case ALL_REVIEWS: {
                return this.getAllReviewsFilterDef();
            }
            case ALL_OPEN_REVIEWS: {
                return this.getAllOpenReviewsFilterDef();
            }
            case ALL_CLOSED_REVIEWS: {
                return this.getAllClosedReviewsFilterDef();
            }
            case ALL_DRAFT_REVIEWS: {
                return this.getAllDraftReviewsFilterDef();
            }
            case TO_REVIEW: {
                return this.getToReviewFilterDef();
            }
            case ACTIVE_PARTICIPANT: {
                return this.getAllActiveReviewsIParticipateIn();
            }
            case REQUIRE_MY_APPROVAL: {
                return this.getRequireMyApprovalFilterDef();
            }
            case TO_SUMMARIZE: {
                return this.getToSummarizeFilterDef();
            }
            case OUT_FOR_REVIEW: {
                return this.getOutForReviewFilterDef();
            }
            case MY_DRAFT: {
                return this.getAllMyDraftReviewsFilterDef();
            }
            case MY_OPEN: {
                return this.getAllMyOpenReviewsFilterDef();
            }
            case MY_COMPLETED: {
                return this.getMyCompletedReviewsFilterDef();
            }
            case MY_CLOSED: {
                return this.getAllMyClosedReviewsFilterDef();
            }
            case MY_TRASH: {
                return this.getMyTrashedReviewsFilterDef();
            }
            case MY_SUMMARIZED: {
                return this.getAllMySummarizedReviewsFilterDef();
            }
            case MY_OPEN_SNIPPETS: {
                return this.getMyOpenSnippetsFilterDef();
            }
            case MY_SNIPPETS: {
                return this.getAllMySnippetsFilterDef();
            }
            case ALL_OPEN_SNIPPETS: {
                return this.getOpenSnippetsFilterDef();
            }
            case ALL_SNIPPETS: {
                return this.getAllSnippetsFilterDef();
            }
            case CUSTOM: {
                return this.getCustomFilterDef();
            }
            case MY_TODO: {
                return this.getTodoFilterDef();
            }
        }
        Logs.APP_LOG.warn((Object)("No filter with name " + (Object)((Object)key) + " found"));
        return null;
    }

    private ReviewFilterDef getInboxFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.INBOX, this.getFilterDefByKey(FilterKey.TO_REVIEW), this.getFilterDefByKey(FilterKey.TO_SUMMARIZE), this.getFilterDefByKey(FilterKey.MY_DRAFT), this.getFilterDefByKey(FilterKey.REQUIRE_MY_APPROVAL));
        f2.filterName = "Inbox";
        f2.filterDescription = "All reviews requiring my attention";
        f2.project = this.project;
        return f2;
    }

    private ReviewFilterDef getTodoFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.MY_TODO, this.getFilterDefByKey(FilterKey.TO_REVIEW), this.getFilterDefByKey(FilterKey.TO_SUMMARIZE), this.getFilterDefByKey(FilterKey.REQUIRE_MY_APPROVAL));
        f2.filterName = "Inbox";
        f2.filterDescription = "All reviews requiring my attention, excluding drafts";
        f2.project = this.project;
        return f2;
    }

    private ReviewFilterDef getOutboxFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.OUTBOX, this.getFilterDefByKey(FilterKey.OUT_FOR_REVIEW), this.getFilterDefByKey(FilterKey.MY_COMPLETED));
        f2.filterName = "Outbox";
        f2.filterDescription = "Reviews awaiting action by others";
        f2.project = this.project;
        return f2;
    }

    private ReviewFilterDef getArchiveFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.ARCHIVE, this.getFilterDefByKey(FilterKey.MY_CLOSED), this.getFilterDefByKey(FilterKey.MY_TRASH), this.getFilterDefByKey(FilterKey.MY_SUMMARIZED));
        f2.filterName = "Archive";
        f2.filterDescription = "Archived reviews";
        f2.project = this.project;
        return f2;
    }

    private ReviewFilterDef getAllReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.ALL_REVIEWS);
        f2.state = StateManager.INSTANCE.getNotDeadStateNames();
        f2.filterName = "All Reviews";
        f2.project = this.project;
        return f2;
    }

    private ReviewFilterDef getAllDraftReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.ALL_DRAFT_REVIEWS);
        f2.state = new String[]{this.stateMgr.getDraftState().getName()};
        f2.filterDescription = "All Draft reviews";
        f2.filterName = "Drafts";
        f2.project = this.project;
        return f2;
    }

    private ReviewFilterDef getAllOpenReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.ALL_OPEN_REVIEWS);
        f2.state = StateManager.INSTANCE.getOpenStateNames();
        f2.filterName = "All Open Reviews";
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.REVIEW;
        return f2;
    }

    private ReviewFilterDef getAllClosedReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.ALL_CLOSED_REVIEWS);
        f2.state = StateManager.INSTANCE.getClosedStateNames();
        f2.filterName = "All Closed Reviews";
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.REVIEW;
        return f2;
    }

    private ReviewFilterDef getToReviewFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.TO_REVIEW);
        f2.state = new String[]{this.stateMgr.getReviewState().getName()};
        f2.filterName = "To Review";
        f2.filterDescription = "Reviews you need to do as reviewer";
        f2.reviewer = this.user;
        f2.complete = Boolean.FALSE;
        f2.project = this.project;
        return f2;
    }

    private ReviewFilterDef getRequireMyApprovalFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.REQUIRE_MY_APPROVAL);
        f2.state = new String[]{this.stateMgr.getApprovalState().getName()};
        f2.filterName = "Require My Approval";
        f2.filterDescription = "Reviews awaiting my approval";
        f2.moderator = this.user;
        f2.project = this.project;
        return f2;
    }

    private ReviewFilterDef getToSummarizeFilterDef() {
        ReviewFilterDef withCompleteReviewers = new ReviewFilterDef(null);
        withCompleteReviewers.state = new String[]{this.stateMgr.getReviewState().getName()};
        withCompleteReviewers.moderator = this.user;
        withCompleteReviewers.allReviewersComplete = Boolean.TRUE;
        withCompleteReviewers.project = this.project;
        ReviewFilterDef inSummarize = new ReviewFilterDef(null);
        inSummarize.state = new String[]{this.stateMgr.getSummarizeState().getName()};
        inSummarize.moderator = this.user;
        inSummarize.project = this.project;
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.TO_SUMMARIZE, withCompleteReviewers, inSummarize);
        f2.filterName = "Ready to Close";
        f2.filterDescription = "Reviews that are ready to be closed";
        return f2;
    }

    private ReviewFilterDef getOutForReviewFilterDef() {
        ReviewFilterDef awaitingApproval = new ReviewFilterDef(null);
        awaitingApproval.state = new String[]{this.stateMgr.getApprovalState().getName()};
        awaitingApproval.author = this.user;
        awaitingApproval.moderatorIsNotAuthor = Boolean.TRUE;
        awaitingApproval.project = this.project;
        ReviewFilterDef incompleteReviewers = new ReviewFilterDef(null);
        incompleteReviewers.state = new String[]{this.stateMgr.getReviewState().getName()};
        incompleteReviewers.moderator = this.user;
        incompleteReviewers.author = this.user;
        incompleteReviewers.orRoles = true;
        incompleteReviewers.allReviewersComplete = Boolean.FALSE;
        incompleteReviewers.project = this.project;
        ReviewFilterDef withModerator = new ReviewFilterDef(null);
        withModerator.state = new String[]{this.stateMgr.getReviewState().getName()};
        withModerator.author = this.user;
        withModerator.allReviewersComplete = Boolean.TRUE;
        withModerator.project = this.project;
        withModerator.moderatorIsNotAuthor = Boolean.TRUE;
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.OUT_FOR_REVIEW, incompleteReviewers, withModerator, awaitingApproval);
        f2.filterName = "Out For Review";
        f2.filterDescription = "Reviews that are in progress but don't require your immediate action";
        return f2;
    }

    private ReviewFilterDef getAllMyDraftReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.MY_DRAFT);
        f2.state = new String[]{this.stateMgr.getDraftState().getName()};
        f2.filterDescription = "My draft reviews";
        f2.filterName = "In Draft";
        f2.creator = this.user;
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.REVIEW;
        return f2;
    }

    private ReviewFilterDef getMyCompletedReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.MY_COMPLETED);
        f2.state = this.stateMgr.getOpenStateNames();
        f2.filterName = "Completed";
        f2.filterDescription = "Open reviews I have completed";
        f2.reviewer = this.user;
        f2.complete = true;
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.REVIEW;
        return f2;
    }

    private ReviewFilterDef getAllMyOpenReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.MY_OPEN);
        f2.state = this.stateMgr.getOpenStateNames();
        f2.filterName = "Open";
        f2.filterDescription = "Open reviews I have created";
        f2.creator = this.user;
        f2.complete = true;
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.REVIEW;
        return f2;
    }

    private ReviewFilterDef getAllMyClosedReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.MY_CLOSED);
        f2.state = this.stateMgr.getClosedStateNames();
        f2.filterName = "Closed";
        f2.filterDescription = "Closed reviews I participated in";
        f2.author = this.user;
        f2.moderator = this.user;
        f2.creator = this.user;
        f2.reviewer = this.user;
        f2.orRoles = true;
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.REVIEW;
        return f2;
    }

    private ReviewFilterDef getAllMySummarizedReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.MY_SUMMARIZED);
        f2.state = new String[]{this.stateMgr.getSummarizeState().getName()};
        f2.filterName = "Summarized";
        f2.filterDescription = "Summarized reviews I participated in";
        f2.author = this.user;
        f2.moderator = this.user;
        f2.creator = this.user;
        f2.reviewer = this.user;
        f2.orRoles = true;
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.REVIEW;
        return f2;
    }

    public ReviewFilterDef getCustomFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.CUSTOM);
        f2.filterName = "Custom Filter";
        return f2;
    }

    private ReviewFilterDef getMyTrashedReviewsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.MY_TRASH);
        f2.state = new String[]{this.stateMgr.getDeadState().getName()};
        f2.filterDescription = "My abandoned reviews";
        f2.filterName = "Abandoned";
        f2.creator = this.user;
        f2.project = this.project;
        return f2;
    }

    private ReviewFilterDef getAllActiveReviewsIParticipateIn() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.ACTIVE_PARTICIPANT);
        f2.orRoles = true;
        f2.author = this.user;
        f2.moderator = this.user;
        f2.creator = this.user;
        f2.reviewer = this.user;
        f2.state = StateManager.INSTANCE.getOpenStateNames();
        f2.filterName = "Active";
        f2.complete = Boolean.FALSE;
        f2.filterDescription = "Any reviews I have an incomplete role in";
        f2.reviewType = Review.ReviewType.REVIEW;
        return f2;
    }

    private ReviewFilterDef getMyOpenSnippetsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.MY_OPEN_SNIPPETS);
        f2.state = this.stateMgr.getOpenStateNames();
        f2.filterName = "My Open Snippets";
        f2.filterDescription = "Open snippets I have created";
        f2.creator = this.user;
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.SNIPPET;
        return f2;
    }

    private ReviewFilterDef getAllMySnippetsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.MY_SNIPPETS);
        f2.filterName = "My Snippets";
        f2.filterDescription = "Snippets I have created";
        f2.creator = this.user;
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.SNIPPET;
        return f2;
    }

    private ReviewFilterDef getOpenSnippetsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.ALL_OPEN_SNIPPETS);
        f2.state = this.stateMgr.getOpenStateNames();
        f2.filterName = "All Open Snippets";
        f2.filterDescription = "All open snippets";
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.SNIPPET;
        return f2;
    }

    private ReviewFilterDef getAllSnippetsFilterDef() {
        ReviewFilterDef f2 = new ReviewFilterDef(FilterKey.ALL_SNIPPETS);
        f2.filterName = "All Snippets";
        f2.filterDescription = "All snippets";
        f2.project = this.project;
        f2.reviewType = Review.ReviewType.SNIPPET;
        return f2;
    }

    public static enum FilterKey {
        ALL_REVIEWS("allReviews"),
        ALL_OPEN_REVIEWS("allOpenReviews"),
        ALL_CLOSED_REVIEWS("allClosedReviews"),
        ALL_DRAFT_REVIEWS("draftReviews"),
        INBOX("inbox"),
        OUTBOX("outbox"),
        ARCHIVE("archive"),
        TO_REVIEW("toReview"),
        ACTIVE_PARTICIPANT("activeParticipant"),
        REQUIRE_MY_APPROVAL("requireMyApproval"),
        TO_SUMMARIZE("toSummarize"),
        OUT_FOR_REVIEW("outForReview"),
        MY_DRAFT("drafts"),
        MY_OPEN("open"),
        MY_CLOSED("closed"),
        MY_TRASH("trash"),
        CUSTOM("custom"),
        MY_COMPLETED("completed"),
        MY_TODO("todo"),
        MY_SUMMARIZED("summarized"),
        ALL_SNIPPETS("allSnippets"),
        ALL_OPEN_SNIPPETS("allOpenSnippets"),
        MY_SNIPPETS("mySnippets"),
        MY_OPEN_SNIPPETS("myOpenSnippets");

        public final String id;
        private static final Map<String, FilterKey> keyToFilter;

        public static FilterKey fromId(String id) {
            return keyToFilter.get(id);
        }

        private FilterKey(String id) {
            this.id = id;
        }

        static {
            keyToFilter = new HashMap<String, FilterKey>(FilterKey.values().length);
            for (FilterKey type : FilterKey.values()) {
                keyToFilter.put(type.id, type);
            }
        }
    }
}

