/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view.reviewfilters;

import com.cenqua.crucible.view.reviewfilters.FilterLink;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterState;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ReviewFilterTree {
    private final ReviewFilterState filterState;
    private final ReviewFilters reviewFilters;

    public ReviewFilterTree(ReviewFilterState filterState) {
        this.filterState = filterState;
        this.reviewFilters = new ReviewFilters(filterState.getProject());
    }

    public FilterLink getInboxFilter() {
        return this.filterLinkForKey(ReviewFilters.FilterKey.INBOX);
    }

    public List<FilterLink> getInboxFilterLinks() {
        return this.childFilterLinks(ReviewFilters.FilterKey.INBOX);
    }

    public FilterLink getOutboxFilter() {
        return this.filterLinkForKey(ReviewFilters.FilterKey.OUTBOX);
    }

    public List<FilterLink> getOutboxFilterLinks() {
        return this.childFilterLinks(ReviewFilters.FilterKey.OUTBOX);
    }

    public FilterLink getArchiveFilter() {
        return this.filterLinkForKey(ReviewFilters.FilterKey.ARCHIVE);
    }

    public List<FilterLink> getArchiveFilterLinks() {
        return this.childFilterLinks(ReviewFilters.FilterKey.ARCHIVE);
    }

    public List<FilterLink> getMySnippetFilterLinks() {
        return Arrays.asList(this.filterLinkForKey(ReviewFilters.FilterKey.MY_OPEN_SNIPPETS), this.filterLinkForKey(ReviewFilters.FilterKey.MY_SNIPPETS));
    }

    public List<FilterLink> getEveryonesFilterLinks() {
        return Arrays.asList(this.filterLinkForKey(ReviewFilters.FilterKey.ALL_OPEN_REVIEWS), this.filterLinkForKey(ReviewFilters.FilterKey.ALL_CLOSED_REVIEWS), this.filterLinkForKey(ReviewFilters.FilterKey.ALL_REVIEWS));
    }

    public List<FilterLink> getEveryonesSnippetFilterLinks() {
        return Arrays.asList(this.filterLinkForKey(ReviewFilters.FilterKey.ALL_OPEN_SNIPPETS), this.filterLinkForKey(ReviewFilters.FilterKey.ALL_SNIPPETS));
    }

    public boolean isMyFilter() {
        HashSet<FilterLink> filters = new HashSet<FilterLink>();
        filters.add(this.getInboxFilter());
        filters.add(this.getOutboxFilter());
        filters.addAll(this.getInboxFilterLinks());
        filters.addAll(this.getOutboxFilterLinks());
        filters.addAll(this.getMySnippetFilterLinks());
        return this.isCurrentFilterInList(filters);
    }

    public boolean isEveryonesFilter() {
        HashSet<FilterLink> filters = new HashSet<FilterLink>(this.getEveryonesFilterLinks());
        filters.addAll(this.getEveryonesSnippetFilterLinks());
        return this.isCurrentFilterInList(filters);
    }

    public String getCurrentFilter() {
        ReviewFilters.FilterKey filter = this.filterState.getFilter();
        if (filter == null) {
            return null;
        }
        return filter.id;
    }

    private FilterLink filterLinkForKey(ReviewFilters.FilterKey key) {
        ReviewFilterDef filterDef = this.reviewFilters.getFilterDefByKey(key);
        return this.filterLinkForDef(filterDef);
    }

    private FilterLink filterLinkForDef(ReviewFilterDef filterDef) {
        return new FilterLink(filterDef, this.filterState);
    }

    private List<FilterLink> childFilterLinks(ReviewFilters.FilterKey parentFilter) {
        ReviewFilterDef filterDef = this.reviewFilters.getFilterDefByKey(parentFilter);
        if (!filterDef.isContainer()) {
            throw new IllegalArgumentException("The filter " + (Object)((Object)parentFilter) + " is not a container filter");
        }
        ArrayList<FilterLink> filters = new ArrayList<FilterLink>();
        for (ReviewFilterDef filter : filterDef.getFilters()) {
            filters.add(this.filterLinkForDef(filter));
        }
        return filters;
    }

    private boolean isCurrentFilterInList(Collection<FilterLink> filters) {
        for (FilterLink filter : filters) {
            if (!filter.getId().equals(this.getCurrentFilter())) continue;
            return true;
        }
        return false;
    }
}

