/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view.reviewfilters;

import com.atlassian.crucible.actions.PagedSearch;
import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.ReviewIterator;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.ReviewSort;
import com.cenqua.crucible.view.ReviewRowDetail;
import com.cenqua.crucible.view.StateDO;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.web.UrlHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;

public class ReviewFilterState {
    private ReviewFilters reviewFilters;
    private List<Integer> filteredReviewIds;
    private String title;
    private ReviewFilters.FilterKey filter;
    private HttpSession httpSes;
    private String[] state;
    private String author;
    private String moderator;
    private String creator;
    private String reviewer;
    private String filterName;
    private String filterDescription;
    private String sort = null;
    private String order = null;
    private Review.ReviewType reviewType;
    private final String filterAttrKey;
    private final String filterDefAttrKey;
    private final String filterTitleAttrKey;
    private final String sortAttrKey;
    private final String reverseAttrKey;
    public static final String COMPLETE_ANY = "any";
    public static final String COMPLETE = "complete";
    public static final String COMPLETE_NOT = "incomplete";
    private Project project;
    private boolean orRoles;
    private Boolean complete;
    private final ReviewFilters.FilterKey defaultFilter;
    private ReviewManager reviewManager;
    @Nullable
    private final FecruUser currentUser;

    public ReviewFilterState(@Nullable FecruUser currentUser, ReviewFilters.FilterKey defaultFilter, String actionName) {
        this.currentUser = currentUser;
        this.defaultFilter = defaultFilter;
        this.reviewManager = DefaultReviewManager.get();
        this.reviewFilters = new ReviewFilters(currentUser);
        this.httpSes = CrucibleFilter.getRequest().getSession();
        this.filterAttrKey = "com.atlassian.crucible.actions." + actionName + ".filter";
        this.filterDefAttrKey = "com.atlassian.crucible.actions." + actionName + ".filterDef";
        this.filterTitleAttrKey = "com.atlassian.crucible.actions." + actionName + ".filterTitle";
        this.sortAttrKey = "com.atlassian.crucible.actions." + actionName + ".sort";
        this.reverseAttrKey = "com.atlassian.crucible.actions." + actionName + ".ReviewQueryAction.reverse";
        if (this.httpSes.getAttribute(this.filterAttrKey) == null) {
            this.setFilter(defaultFilter.id);
        }
        if (this.httpSes.getAttribute(this.sortAttrKey) == null) {
            this.setSort(ReviewSort.DUE.name());
        }
        if (this.httpSes.getAttribute(this.reverseAttrKey) == null) {
            this.setOrder("asc");
        }
    }

    public String[] getState() {
        return this.state;
    }

    public Collection getStates() {
        List<State> states = StateManager.INSTANCE.getStates();
        LinkedList<StateDO> wrappedStates = new LinkedList<StateDO>();
        for (State state1 : states) {
            wrappedStates.add(new StateDO(state1, this.state));
        }
        return wrappedStates;
    }

    public void setState(String[] state) {
        this.state = new String[state.length];
        for (int i2 = 0; i2 < state.length; ++i2) {
            this.state[i2] = StateManager.INSTANCE.getStateByName(state[i2]).getName();
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getFilterDescription() {
        return this.filterDescription;
    }

    public boolean getOrRoles() {
        return this.orRoles;
    }

    public void setOrRoles(boolean orRoles) {
        this.orRoles = orRoles;
    }

    public String getComplete() {
        if (this.complete == null) {
            return COMPLETE_ANY;
        }
        return this.complete != false ? COMPLETE : COMPLETE_NOT;
    }

    public void setComplete(String complete) {
        if (COMPLETE.equals(complete)) {
            this.complete = Boolean.TRUE;
            return;
        }
        if (COMPLETE_NOT.equals(complete)) {
            this.complete = Boolean.FALSE;
            return;
        }
        this.complete = null;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getModerator() {
        return this.moderator;
    }

    public void setModerator(String moderator) {
        this.moderator = moderator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getReviewer() {
        return this.reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Review.ReviewType getReviewType() {
        return this.reviewType;
    }

    public void setReviewType(Review.ReviewType reviewType) {
        this.reviewType = reviewType;
    }

    public List<ReviewRowDetail> getFilteredReviewDetails(Principal currentPrincipal, PagedSearch pagedSearch) {
        int start = pagedSearch.getStart();
        int end = pagedSearch.getEnd();
        int countRows = end - start;
        ReviewIterator reviewIterator = this.reviewManager.getReviewIteratorForIds(this.getFilteredReviewIds(), countRows + 10);
        reviewIterator.skip(start);
        ArrayList<ReviewRowDetail> details = new ArrayList<ReviewRowDetail>();
        while (reviewIterator.hasNext() && details.size() <= countRows) {
            Review review = reviewIterator.next();
            if (!ReviewUtil.principalCanDoReviewAction(currentPrincipal, null, UserActionManager.ACTION_VIEW, review)) continue;
            details.add(new ReviewRowDetail(review, this.currentUser));
        }
        return details;
    }

    private List<Integer> getFilteredReviewIds() {
        ReviewFilterDef filterDef = this.getFilterDefByKey(this.getFilter());
        this.applyProjectToFilter(filterDef);
        if (this.filteredReviewIds == null) {
            List<Integer> ids = this.reviewManager.getMatchingReviewIds(filterDef, this.title, ReviewSort.forName(this.getSort()));
            this.filteredReviewIds = "desc".equals(this.getOrder()) ? Lists.reverse(ids) : ids;
        }
        return this.filteredReviewIds;
    }

    public int countFilteredReviews(ReviewFilters.FilterKey filter) {
        ReviewFilterDef filterDef = this.reviewFilters.getFilterDefByKey(filter);
        this.applyProjectToFilter(filterDef);
        return this.reviewManager.getMatchingReviewCount(filterDef, this.title);
    }

    private ReviewFilterDef getFilterDefByKey(ReviewFilters.FilterKey key) {
        ReviewFilterDef fd = this.reviewFilters.getFilterDefByKey(key);
        if (fd != null) {
            this.filterName = fd.filterName;
            if (ReviewFilters.FilterKey.CUSTOM.equals((Object)key)) {
                fd.author = CrucibleUserManager.getUserByName(this.author);
                fd.moderator = CrucibleUserManager.getUserByName(this.moderator);
                fd.creator = CrucibleUserManager.getUserByName(this.creator);
                fd.reviewer = CrucibleUserManager.getUserByName(this.reviewer);
                fd.state = this.state;
                fd.project = this.project;
                fd.orRoles = this.orRoles;
                fd.reviewType = this.reviewType;
                if (fd.reviewer == null && this.complete != null) {
                    fd.allReviewersComplete = this.complete;
                } else {
                    fd.complete = this.complete;
                }
                this.httpSes.setAttribute(this.filterDefAttrKey, (Object)fd);
                this.httpSes.setAttribute(this.filterTitleAttrKey, (Object)this.getTitle());
            } else {
                this.applyProjectToFilter(fd);
                this.author = fd.author != null ? fd.author.getUsername() : null;
                this.moderator = fd.moderator != null ? fd.moderator.getUsername() : null;
                this.creator = fd.creator != null ? fd.creator.getUsername() : null;
                this.reviewer = fd.reviewer != null ? fd.reviewer.getUsername() : null;
                this.state = fd.state;
                this.orRoles = fd.orRoles;
                this.complete = fd.complete;
                this.project = fd.project;
            }
        }
        return fd;
    }

    public void setFilter(String filter) {
        this.httpSes.setAttribute(this.filterAttrKey, (Object)filter);
        this.filter = ReviewFilters.FilterKey.fromId(filter);
        ReviewFilterDef filterDef = this.reviewFilters.getFilterDefByKey(this.filter);
        this.applyProjectToFilter(filterDef);
        if (filterDef != null) {
            this.filterName = filterDef.filterName;
            this.filterDescription = filterDef.filterDescription;
            if (filterDef.isSingleReviewType() && filterDef.reviewType != null) {
                this.reviewType = filterDef.reviewType;
            }
        }
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.httpSes.setAttribute(this.sortAttrKey, (Object)sort);
        this.sort = sort;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.httpSes.setAttribute(this.reverseAttrKey, (Object)order);
        this.order = order;
    }

    private void applyProjectToFilter(ReviewFilterDef filter) {
        filter.project = this.getProject();
        if (filter.isContainer()) {
            for (ReviewFilterDef childFilter : filter.getFilters()) {
                this.applyProjectToFilter(childFilter);
            }
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public ReviewFilters.FilterKey getFilter() {
        return this.filter;
    }

    public void setFilterFromSession() {
        if (this.getFilter() == null) {
            String filterName = (String)this.httpSes.getAttribute(this.filterAttrKey);
            ReviewFilters.FilterKey filter = filterName == null ? this.defaultFilter : ReviewFilters.FilterKey.fromId(filterName);
            this.setFilter(filter.id);
            if (ReviewFilters.FilterKey.CUSTOM.equals((Object)filter)) {
                ReviewFilterDef fd = (ReviewFilterDef)this.httpSes.getAttribute(this.filterDefAttrKey);
                this.author = fd.author != null ? fd.author.getUsername() : null;
                this.moderator = fd.moderator != null ? fd.moderator.getUsername() : null;
                this.creator = fd.creator != null ? fd.creator.getUsername() : null;
                this.reviewer = fd.reviewer != null ? fd.reviewer.getUsername() : null;
                this.state = fd.state;
                this.orRoles = fd.orRoles;
                this.complete = fd.complete;
                this.project = fd.project;
                this.reviewType = fd.reviewType;
                this.setTitle((String)this.httpSes.getAttribute(this.filterTitleAttrKey));
            }
        }
        if (this.getSort() == null && this.httpSes.getAttribute(this.sortAttrKey) != null) {
            this.setSort((String)this.httpSes.getAttribute(this.sortAttrKey));
        }
        if (this.getOrder() == null && this.httpSes.getAttribute(this.reverseAttrKey) != null) {
            this.setOrder((String)this.httpSes.getAttribute(this.reverseAttrKey));
        }
    }

    public String getFilterParams() {
        UrlHelper url = new UrlHelper();
        if (ReviewFilters.FilterKey.CUSTOM.equals((Object)this.getFilter())) {
            url.putParam("title", this.getTitle());
            url.putParam("author", this.author);
            url.putParam("moderator", this.moderator);
            url.putParam("creator", this.creator);
            url.putParam("reviewer", this.reviewer);
            url.putParam("state", this.state);
            url.putParam("orRoles", Boolean.toString(this.orRoles));
            url.putParam(COMPLETE, this.complete);
            url.putParam("project", this.project == null ? null : this.project.getProjKey());
            url.putParam("reviewType", this.reviewType == null ? null : Integer.valueOf(this.reviewType.getId()));
        }
        url.putParam("filter", this.getFilter().id);
        return url.toString();
    }

    public int getNumberOfResults() {
        return this.getFilteredReviewIds() == null ? 0 : this.getFilteredReviewIds().size();
    }
}

