/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view.reviewfilters;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class ReviewFilterDef
implements Serializable {
    public final ReviewFilters.FilterKey id;
    public String[] state;
    public FecruUser author;
    public FecruUser moderator;
    public FecruUser creator;
    public FecruUser reviewer;
    public Boolean complete;
    public Boolean allReviewersComplete;
    public Boolean moderatorIsNotAuthor;
    public String filterName;
    public String filterDescription;
    public Project project;
    public Review.ReviewType reviewType;
    public boolean orRoles = false;
    public long fromDate;
    public long toDate;
    private List<ReviewFilterDef> filters;

    public ReviewFilterDef(ReviewFilters.FilterKey id) {
        this.id = id;
    }

    public ReviewFilterDef(ReviewFilters.FilterKey id, ReviewFilterDef ... childFilters) {
        this.id = id;
        this.filters = Arrays.asList(childFilters);
    }

    public String toString() {
        return "ReviewFilterDef{id=" + (Object)((Object)this.id) + ", state=" + (this.state == null ? null : Arrays.asList(this.state)) + ", author=" + this.author + ", moderator=" + this.moderator + ", creator=" + this.creator + ", reviewer=" + this.reviewer + ", complete=" + this.complete + ", allReviewersComplete=" + this.allReviewersComplete + ", moderatorIsNotAuthor=" + this.moderatorIsNotAuthor + ", filterName='" + this.filterName + '\'' + ", filterDescription='" + this.filterDescription + '\'' + ", project=" + this.project + ", orRoles=" + this.orRoles + ", reviewType=" + (Object)((Object)this.reviewType) + ", fromDate=" + this.fromDate + ", toDate=" + this.toDate + '}';
    }

    public boolean isSingleReviewType() {
        boolean result = true;
        if (this.isContainer()) {
            for (ReviewFilterDef filter : this.filters) {
                result &= this.reviewType != null && this.reviewType.equals((Object)filter.reviewType) && filter.isSingleReviewType();
            }
        }
        return result;
    }

    public boolean isContainer() {
        return this.filters != null && this.filters.size() > 0;
    }

    public List<ReviewFilterDef> getFilters() {
        return this.filters;
    }
}

