/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view.reviewfilters;

import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterState;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.google.common.base.Strings;

public class FilterLink {
    private final ReviewFilters.FilterKey filterKey;
    private final String title;
    private final String description;
    private final ReviewFilterState filterState;

    public FilterLink(ReviewFilterDef filterDef, ReviewFilterState filterState) {
        this.filterKey = filterDef.id;
        this.title = filterDef.filterName;
        this.description = filterDef.filterDescription;
        this.filterState = filterState;
    }

    public int getCount() {
        return this.filterState.countFilteredReviews(this.filterKey);
    }

    public String getId() {
        return this.filterKey.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        if (Strings.isNullOrEmpty((String)this.description)) {
            return this.title;
        }
        return this.description;
    }
}

