/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewIterator;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.util.ReviewSort;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class ReviewsToDo {
    private static final ReviewsToDo EMPTY = new ReviewsToDo(Collections.emptyList(), false);
    private List<Review> reviews;
    private boolean partialList;

    ReviewsToDo(List<Review> reviews, boolean partialList) {
        this.reviews = reviews;
        this.partialList = partialList;
    }

    public List<Review> getReviews() {
        return this.reviews;
    }

    public boolean isPartialList() {
        return this.partialList;
    }

    public int getSize() {
        return this.reviews.size();
    }

    public static ReviewsToDo forCurrentUser(EffectiveUserProvider effectiveUserProvider, CurrentUserPermissions currentUserPermissions, ReviewManager reviewManager, int detailedSize) {
        ReviewFilters filter = new ReviewFilters(effectiveUserProvider.getEffectiveUser());
        List<Integer> reviewIds = reviewManager.getMatchingReviewIds(filter.getFilterDefByKey(ReviewFilters.FilterKey.MY_TODO), null, ReviewSort.DUE);
        if (reviewIds.isEmpty()) {
            return EMPTY;
        }
        int numberToCheck = detailedSize + 1;
        int count = 0;
        ImmutableList.Builder reviewsTodoBuilder = ImmutableList.builder();
        ReviewIterator reviews = reviewManager.getReviewIteratorForIds(reviewIds, numberToCheck);
        while (reviews.hasNext() && count < numberToCheck) {
            Review review = (Review)reviews.next();
            if (!currentUserPermissions.canViewReview(review)) continue;
            if (count < detailedSize) {
                reviewsTodoBuilder.add((Object)review);
            }
            ++count;
        }
        return new ReviewsToDo((List<Review>)reviewsTodoBuilder.build(), count > detailedSize);
    }
}

