/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.MaybeReview;
import com.cenqua.fisheye.config.SpringContext;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;

public class ReviewRowDetail {
    private MaybeReview maybeReview = null;
    private final Review review;
    @Nullable
    private final FecruUser currentUser;
    private final Supplier<Integer> reviewCommentCountSupplier = Suppliers.memoize((Supplier)new Supplier<Integer>(){

        public Integer get() {
            return ReviewRowDetail.this.countReviewComments();
        }
    });
    private final Supplier<Integer> readReviewCommentCountSupplier = Suppliers.memoize((Supplier)new Supplier<Integer>(){

        public Integer get() {
            return ReviewRowDetail.this.countReadReviewComments();
        }
    });
    private final Supplier<Boolean> commentingAllowedSupplier;

    public ReviewRowDetail(Review review, @Nullable FecruUser currentUser) {
        this.review = review;
        this.commentingAllowedSupplier = Suppliers.memoize(() -> SpringContext.getComponent(ReviewService.class, "reviewService").hasPermission(review.getPermId(), UserActionManager.ACTION_COMMENT));
        this.currentUser = currentUser;
    }

    public Review getReview() {
        return this.review;
    }

    public MaybeReview getMaybeReview() {
        if (this.maybeReview == null) {
            this.maybeReview = new MaybeReview(this.getReview(), true);
        }
        return this.maybeReview;
    }

    public String getPermaId() {
        return this.review.getPermaId();
    }

    public Integer getId() {
        return this.review.getId();
    }

    public String getName() {
        return this.review.getName();
    }

    public String getDescription() {
        return this.review.getDescription();
    }

    public Date getCreateDate() {
        return this.review.getCreateDate();
    }

    public String getState() {
        return this.review.getStateName();
    }

    public boolean isClosedState() {
        return this.getState().equals("Closed");
    }

    public boolean isOpenMetaState() {
        return this.review.getState().isOpenMetaState();
    }

    public boolean isDraftState() {
        return this.getState().equals("Draft");
    }

    public boolean isApprovalState() {
        return this.getState().equals("Approval");
    }

    public FecruUser getAuthor() {
        return this.review.getAuthor();
    }

    public FecruUser getModerator() {
        return this.review.getModerator();
    }

    public boolean isModerated() {
        return this.review.isModerated();
    }

    public FecruUser getCreator() {
        return this.review.getCreator();
    }

    public int getActiveCount() {
        return this.getActiveReviewers().size();
    }

    public Set<FecruUser> getActiveReviewers() {
        return this.getReview().getActiveReviewers();
    }

    public Set<FecruUser> getCompletedReviewers() {
        return this.getReview().getCompletedReviewers();
    }

    public int getCompletedCount() {
        return this.getCompletedReviewers().size();
    }

    public int getFileCount() {
        return ((Number)HibernateUtil.currentSession().createFilter(this.review.getFrxs(), "select count(*)").list().get(0)).intValue();
    }

    public int getCountReviewers() {
        return this.getCompletedCount() + this.getActiveCount();
    }

    public int getReviewCommentCount() {
        return (Integer)this.reviewCommentCountSupplier.get();
    }

    private CommentManager getCommentManager() {
        return DefaultCommentManager.getInstance();
    }

    public int getReadReviewCommentCount() {
        if (this.getReviewCommentCount() == 0) {
            return 0;
        }
        return (Integer)this.readReviewCommentCountSupplier.get();
    }

    private int countReviewComments() {
        return this.getCommentManager().getReviewCommentCount(this.getReview(), null, false, false, null, null);
    }

    private int countReadReviewComments() {
        if (null == this.currentUser) {
            return 0;
        }
        return this.getCommentManager().getReviewCommentCount(this.getReview(), null, false, false, null, this.currentUser);
    }

    public int getUnreadReviewCommentCount() {
        return this.isCommentingAllowed() && !this.getReview().isSnippet() ? this.getReviewCommentCount() - this.getReadReviewCommentCount() : 0;
    }

    public boolean isReviewParticipant() {
        return this.getReview().isParticipant(this.currentUser);
    }

    public boolean isCommentingAllowed() {
        return (Boolean)this.commentingAllowedSupplier.get();
    }
}

