/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.view.ReviewDO;

public class ReviewParticipantDO {
    private final ReviewParticipant participant;
    private final ReviewDO reviewDO;
    private final FecruUser user;
    private static final long ONE_MINUTE_IN_MS = 60000L;

    public ReviewParticipantDO(ReviewParticipant participant, ReviewDO reviewDO) {
        this.participant = participant;
        this.reviewDO = reviewDO;
        this.user = this.participant.getUser();
    }

    public ReviewParticipant getParticipant() {
        return this.participant;
    }

    public ReviewDO getReviewDO() {
        return this.reviewDO;
    }

    public Review getReview() {
        return this.reviewDO.getReview();
    }

    public FecruUser getUser() {
        return this.user;
    }

    public int getAuthoredCommentCount() {
        return DefaultCommentManager.getInstance().comments(this.getReview()).where(DiscussionClauses.and(DiscussionClauses.visibleToAll(), DiscussionClauses.author(this.user), new DiscussionClause[0])).count();
    }

    public int getAuthoredDefectCount() {
        return DefaultCommentManager.getInstance().comments(this.getReview()).where(DiscussionClauses.and(DiscussionClauses.visibleToAll(), DiscussionClauses.author(this.user), DiscussionClauses.defect())).count();
    }

    public int getAuthoredNonDefectCount() {
        return DefaultCommentManager.getInstance().comments(this.getReview()).where(DiscussionClauses.and(DiscussionClauses.visibleToAll(), DiscussionClauses.author(this.user), DiscussionClauses.not(DiscussionClauses.defect()))).count();
    }

    public Comment getLatestComment() {
        return this.getReviewDO().getLatestCommentPerUser().get(this.getParticipant().getUser());
    }

    private long zeroIfNull(Long l2) {
        return l2 == null ? 0L : l2;
    }

    public long getTimeSpent() {
        return this.zeroIfNull(this.getParticipant().getTimeSpent());
    }

    public long getTimeSubmitted() {
        return this.zeroIfNull(this.getParticipant().getTimeSubmitted());
    }

    public long getTimeToSubmit() {
        return Math.max(this.getTimeSpent() - this.getTimeSubmitted(), 0L);
    }

    public boolean getHasSpentTime() {
        return this.getTimeSpent() >= 60000L;
    }

    public boolean getHasLoggedTime() {
        return this.getTimeSubmitted() >= 60000L;
    }

    public boolean getHasTimeToSubmit() {
        return this.getTimeSpent() - this.getTimeSubmitted() >= 60000L;
    }
}

