/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.jira.issue.JiraIssueService;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileReadStatus;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.discussion.CommentOperator;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.view.ProjectDO;
import com.cenqua.crucible.view.ReviewParticipantDO;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class ReviewDO {
    private final Review review;
    private final Principal principal;
    private List<ReviewParticipantDO> reviewParticipantDOs;
    private List<ReviewParticipantDO> reviewersDOS;
    private JiraIssueService jiraIssueService;
    private final CurrentUserPermissions currentUserPermissions;
    private Integer generalCommentCount = null;
    private Integer unreadGeneralCommentCount = null;
    private Integer totalCommentCount = null;
    private Integer totalDefectCount = null;
    private Integer totalUnreadCount = null;
    private FecruUser currentUser;
    private ReviewParticipant currentParticipant;
    private ReviewParticipantDO currentParticipantDO;
    private Map<FecruUser, Comment> latestCommentPerUser;
    private ReviewParticipantDO authorPDO;
    private ReviewParticipantDO moderatorPDO;

    public ReviewDO(Review review, Principal principal, CurrentUserPermissions currentUserPermissions, JiraIssueService jiraIssueService) {
        this.review = review;
        this.principal = principal;
        this.jiraIssueService = jiraIssueService;
        this.currentUserPermissions = currentUserPermissions;
    }

    public Review getReview() {
        return this.review;
    }

    public ProjectDO getProjectDO() {
        return new ProjectDO(this.review.getProject());
    }

    public boolean isModifiable() {
        return this.currentUserPermissions.canModifyReview(this.review);
    }

    public boolean isCommentable() {
        return this.currentUserPermissions.canCommentReview(this.review);
    }

    public int getGeneralCommentCount() {
        if (this.generalCommentCount == null) {
            this.generalCommentCount = DefaultCommentManager.getInstance().comments(this.review).excludeFRXComments().excludeInlineComments().where(DiscussionClauses.visibleToAll()).count();
        }
        return this.generalCommentCount;
    }

    public int getUnreadGeneralCommentCount() {
        if (this.unreadGeneralCommentCount == null) {
            this.unreadGeneralCommentCount = !this.isCommentable() ? Integer.valueOf(0) : Integer.valueOf(DefaultCommentManager.getInstance().comments(this.review).excludeFRXComments().excludeInlineComments().where(DiscussionClauses.and(DiscussionClauses.visibleToAll(), DiscussionClauses.unread(this.getCurrentUser()), new DiscussionClause[0])).count());
        }
        return this.unreadGeneralCommentCount;
    }

    public int getCommentTotalCount() {
        if (this.totalCommentCount == null) {
            this.totalCommentCount = DefaultCommentManager.getInstance().comments(this.review).where(DiscussionClauses.visibleToAll()).count();
        }
        return this.totalCommentCount;
    }

    public int getDefectTotalCount() {
        if (this.totalDefectCount == null) {
            this.totalDefectCount = DefaultCommentManager.getInstance().comments(this.review).where(DiscussionClauses.and(DiscussionClauses.visibleToAll(), DiscussionClauses.defect(), new DiscussionClause[0])).count();
        }
        return this.totalDefectCount;
    }

    public int getTotalUnreadCount() {
        if (this.totalUnreadCount == null) {
            this.totalUnreadCount = !this.isCommentable() ? Integer.valueOf(0) : Integer.valueOf(DefaultCommentManager.getInstance().comments(this.review).where(DiscussionClauses.and(DiscussionClauses.visibleToAll(), DiscussionClauses.unread(this.getCurrentUser()), new DiscussionClause[0])).count());
        }
        return this.totalUnreadCount;
    }

    public String getJiraIssueKey() {
        return this.review.getJiraIssueKey();
    }

    public String getJiraIssueUrl() {
        return this.jiraIssueService.getJiraIssueUrl(this.getJiraIssueKey(), this.getProjectDO().getProject());
    }

    public String getBestSuggestedJiraIssueKey() {
        return this.getReview().getBestSuggestedJiraIssueKey();
    }

    public FecruUser getCurrentUser() {
        if (this.currentUser == null) {
            this.currentUser = CrucibleUserManager.getUserByName(this.principal.getUserName());
        }
        return this.currentUser;
    }

    public ReviewParticipant getParticipant() {
        if (this.currentParticipant == null) {
            this.currentParticipant = this.getReview().getParticipant(this.getCurrentUser());
        }
        return this.currentParticipant;
    }

    public ReviewParticipantDO getParticipantDO() {
        if (this.currentParticipantDO == null && this.getParticipant() != null) {
            this.currentParticipantDO = new ReviewParticipantDO(this.getParticipant(), this);
        }
        return this.currentParticipantDO;
    }

    public boolean getHasEverCompleted() {
        ReviewParticipant p2 = this.getParticipant();
        if (p2 == null) {
            return false;
        }
        for (FileRevisionExtraInfo frx : this.getReview().getFrxs()) {
            FileReadStatus status = p2.getReadStatus(frx);
            if (status == null || status.getLastUnreadDateTime() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isNewSinceComplete() {
        ReviewParticipant p2 = this.getParticipant();
        if (p2 == null) {
            return true;
        }
        for (FileRevisionExtraInfo frx : this.getReview().getFrxs()) {
            FileReadStatus status = p2.getReadStatus(frx);
            if (status == null) {
                return true;
            }
            Long unreadTime = status.getLastUnreadDateTime();
            if (unreadTime == null) continue;
            Long updatedTime = 0L;
            for (FRXRevision rev : frx.getFrxRevisions()) {
                updatedTime = Math.max(rev.getDateTimeAdded(), updatedTime);
            }
            if (updatedTime.compareTo(unreadTime) < 0) continue;
            return true;
        }
        return false;
    }

    public Map<FecruUser, Comment> getLatestCommentPerUser() {
        if (this.latestCommentPerUser == null) {
            this.latestCommentPerUser = new HashMap<FecruUser, Comment>();
            DefaultCommentManager.getInstance().comments(this.getReview()).where(DiscussionClauses.visibleToAll()).visit(new CommentOperator(){

                @Override
                public void operate(Comment comment) {
                    Comment existing = (Comment)ReviewDO.this.latestCommentPerUser.get(comment.getUser());
                    if (existing == null || existing.getUpdatedDate().before(comment.getUpdatedDate())) {
                        ReviewDO.this.latestCommentPerUser.put(comment.getUser(), comment);
                    }
                }
            });
        }
        return this.latestCommentPerUser;
    }

    public ReviewParticipantDO getAuthorPDO() {
        if (this.authorPDO == null) {
            this.authorPDO = new ReviewParticipantDO(this.getReview().getAuthorP(), this);
        }
        return this.authorPDO;
    }

    public ReviewParticipantDO getModeratorPDO() {
        ReviewParticipant mod;
        if (this.isModerated() && this.moderatorPDO == null && (mod = this.getReview().getModeratorP()) != null) {
            this.moderatorPDO = new ReviewParticipantDO(mod, this);
        }
        return this.moderatorPDO;
    }

    public boolean isModerated() {
        return this.getReview().isModerated();
    }

    public List<ReviewParticipantDO> getReviewParticipantDOs() {
        if (this.reviewParticipantDOs == null) {
            this.reviewParticipantDOs = new ArrayList<ReviewParticipantDO>();
            for (ReviewParticipant participant : this.getReview().getParticipants()) {
                this.reviewParticipantDOs.add(new ReviewParticipantDO(participant, this));
            }
        }
        return this.reviewParticipantDOs;
    }

    public List<ReviewParticipantDO> getReviewerDOs() {
        if (this.reviewersDOS == null) {
            this.reviewersDOS = new ArrayList<ReviewParticipantDO>(this.getReviewParticipantDOs());
            Iterator<ReviewParticipantDO> participantDOIterator = this.reviewersDOS.iterator();
            while (participantDOIterator.hasNext()) {
                ReviewParticipantDO participantDO = participantDOIterator.next();
                if (participantDO.getParticipant().isReviewer()) continue;
                participantDOIterator.remove();
            }
        }
        return this.reviewersDOS;
    }

    public Long getTimeSpent() {
        long t2 = 0L;
        for (ReviewParticipant p2 : this.getReview().getParticipants()) {
            t2 += p2.getTimeSpent() == null ? 0L : p2.getTimeSpent();
        }
        return t2;
    }

    public List<Review> getLinkedReviews() {
        return this.getReview().getLinkedReviews();
    }

    private TimeZone getUserTimeZone() {
        return AppConfig.getUserTimeZone(this.principal.getUserName());
    }

    public boolean isDueWithinAWorkDay() {
        return ISO8601DateHelper.getElapsedWorkingDays(new Date(), this.review.getDueDate(), this.getUserTimeZone()) < 1;
    }

    public Integer getReminderDaysBefore() {
        if (this.review.getReminderDate() == null) {
            return null;
        }
        return ISO8601DateHelper.getElapsedWorkingDays(this.review.getReminderDate(), this.review.getDueDate(), this.getUserTimeZone());
    }

    public boolean getShouldShowReminder() {
        FecruUser authorOrModerator;
        if (!this.review.isOverDue()) {
            return false;
        }
        Set<FecruUser> activeReviewers = this.review.getActiveReviewers();
        if (!activeReviewers.isEmpty()) {
            return activeReviewers.size() != 1 || !activeReviewers.contains(this.getCurrentUser());
        }
        FecruUser fecruUser = authorOrModerator = this.review.isModerated() ? this.review.getModerator() : this.review.getAuthor();
        return this.getCurrentUser() != authorOrModerator;
    }
}

