/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.FileRevisionToReviewMapper;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RevInfoDO {
    private final Review review;
    private final Source source;
    private final Path path;
    private final int latestCrucibleRevisionId;
    private FileHistoryExplorer fileHistoryExplorer;
    private CrucibleRevision selectedRev;
    private boolean inThisReview = false;
    private Set<CrucibleRevision> cruRevsInReview = new HashSet<CrucibleRevision>();
    private Map<String, Collection<RepositorySource.AncestorAnnotationDO>> branchMap = Collections.emptyMap();
    private ContentManager contentManager;
    private boolean fileHistoryImmediatelyAvailable = false;

    public RevInfoDO(Review review, Source source, Path path, int latestCrucibleRevisionId, FileHistoryExplorer fileHistoryExplorer, ContentManager contentManager) {
        this.review = review;
        this.fileHistoryExplorer = fileHistoryExplorer;
        this.path = path;
        this.latestCrucibleRevisionId = latestCrucibleRevisionId;
        this.contentManager = contentManager;
        if (source.isAvailable()) {
            this.source = source;
            this.processFileRevisions(review);
        } else {
            this.source = null;
            Logs.APP_LOG.error((Object)source.getReason());
        }
    }

    public boolean isFileHistoryImmediatelyAvailable() {
        return this.fileHistoryImmediatelyAvailable;
    }

    private void processFileRevisions(Review review) {
        List<CrucibleRevision> cruFrsInReview = review.getRevisions();
        for (CrucibleRevision fr : cruFrsInReview) {
            if (!fr.getSourceName().equals(this.source.getName())) continue;
            this.cruRevsInReview.add(fr);
        }
        try {
            this.branchMap = this.annotateFileHistory();
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Problem getting previous revisions", (Throwable)e2);
            this.branchMap = Collections.emptyMap();
        }
    }

    public boolean isInThisReview() {
        return this.inThisReview;
    }

    public CrucibleRevision getSelectedRev() {
        return this.selectedRev;
    }

    public Map<String, Collection<RepositorySource.AncestorAnnotationDO>> getBranchMap() {
        return this.branchMap;
    }

    public Collection<String> getBranches() {
        return this.branchMap.keySet();
    }

    private Map<String, Collection<RepositorySource.AncestorAnnotationDO>> annotateFileHistory() throws SourceException {
        if (this.fileHistoryExplorer == null) {
            return this.annotateBriefHistory();
        }
        this.fileHistoryImmediatelyAvailable = true;
        List<String> branches = this.fileHistoryExplorer.getBranchNames();
        FileRevisionToReviewMapper finder = new FileRevisionToReviewMapper(this.source);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        ImmutableSet.Builder keys = ImmutableSet.builder();
        for (String branch : branches) {
            keys.addAll((Iterable)this.fileHistoryExplorer.getInfoMap().get(branch));
        }
        Map<RevInfoKey, CrucibleRevision> keyToRevisionMap = this.contentManager.getCrucibleRevisions(this.source, (Set<RevInfoKey>)keys.build(), false);
        for (String branch : branches) {
            List<RevInfoKey> revs = this.fileHistoryExplorer.getInfoMap().get(branch);
            for (RevInfoKey revInfoKey : revs) {
                CrucibleRevision cruRev = keyToRevisionMap.get(revInfoKey);
                this.contentManager.checkRevisionDetailsIfQuick(cruRev, this.source);
                Collection<Review> reviews = finder.findReviewsForRevision(revInfoKey);
                if (reviews.isEmpty()) {
                    result.put((Object)branch, (Object)new RepositorySource.AncestorAnnotationDO(cruRev, this.currentlySelected(cruRev), Collections.emptyList()));
                    continue;
                }
                result.put((Object)branch, (Object)new RepositorySource.AncestorAnnotationDO(cruRev, this.currentlySelected(cruRev), new ArrayList<Review>(reviews)));
            }
        }
        if (this.selectedRev == null) {
            this.findMissingSelectedRevision(finder, (Multimap<String, RepositorySource.AncestorAnnotationDO>)result);
        }
        return result.asMap();
    }

    private void findMissingSelectedRevision(FileRevisionToReviewMapper finder, Multimap<String, RepositorySource.AncestorAnnotationDO> result) {
        List<FileRevisionExtraInfo> frxs = FRXManager.getFRExtraInfos(this.path.getPath(), this.review);
        if (frxs.size() > 0) {
            FileRevisionExtraInfo frx = frxs.get(0);
            CrucibleRevision cruRev = frx.getFileRevision();
            this.inThisReview = true;
            this.selectedRev = cruRev;
            String br = cruRev.getDetails().get("branch");
            if (br == null) {
                br = "";
            }
            result.put((Object)br, (Object)new RepositorySource.AncestorAnnotationDO(cruRev, true, new ArrayList<Review>(finder.findReviewsForRevision(cruRev.getRevInfoKey()))));
        }
    }

    private Map<String, Collection<RepositorySource.AncestorAnnotationDO>> annotateBriefHistory() {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        CrucibleRevision cruRevision = this.contentManager.getLazyCrucibleRevisionById(this.latestCrucibleRevisionId);
        FileRevisionToReviewMapper finder = new FileRevisionToReviewMapper(this.source);
        Collection<Review> reviews = finder.findReviewsForRevision(cruRevision.getRevInfoKey());
        RepositorySource.AncestorAnnotationDO ann = new RepositorySource.AncestorAnnotationDO(this.latestCrucibleRevisionId, cruRevision.getRevision(), cruRevision.getRevisionDisplayName(), cruRevision.getAuthorName(), cruRevision.getCommitDate(), this.currentlySelected(cruRevision), new ArrayList<Review>(reviews));
        result.put((Object)"", (Object)ann);
        if (this.selectedRev == null) {
            this.findMissingSelectedRevision(finder, (Multimap<String, RepositorySource.AncestorAnnotationDO>)result);
        }
        return result.asMap();
    }

    private boolean currentlySelected(CrucibleRevision fr) {
        boolean sel = this.cruRevsInReview.contains(fr);
        if (sel) {
            this.inThisReview = true;
            this.selectedRev = fr;
        }
        return sel;
    }
}

