/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.view.PatchDO;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class PatchListDO {
    private final List<Patch> patches;
    private final Principal principal;
    private final SourceFactory sourceFactory;

    public PatchListDO(List<Patch> patches, Principal principal, SourceFactory sourceFactory) {
        this.patches = Ordering.from((Comparator)new Comparator<Patch>(){

            @Override
            public int compare(Patch o1, Patch o2) {
                return o1.getId() != null && o2.getId() != null ? o1.getId().compareTo(o2.getId()) : 0;
            }
        }).sortedCopy(patches);
        this.principal = principal;
        this.sourceFactory = sourceFactory;
    }

    public List<PatchDO> getAll() {
        return Lists.transform(this.patches, (Function)new PatchToPatchDO());
    }

    public PatchListDO getAvailableForAdding() {
        return new PatchListDO((List<Patch>)ImmutableList.copyOf((Collection)Collections2.filter(this.patches, (Predicate)new Predicate<Patch>(){

            public boolean apply(Patch patch) {
                return patch.isAvailableForAdding();
            }
        })), this.principal, this.sourceFactory);
    }

    public List<PatchGroupDO> getGroupedBySource() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (PatchDO patchDO : this.getAll()) {
            String sourceName = patchDO.getSourceName();
            if (sourceName == null) continue;
            builder.put((Object)sourceName, (Object)patchDO);
        }
        ImmutableMultimap groupedPatchDOs = builder.build();
        ImmutableList.Builder groups = ImmutableList.builder();
        for (String key : groupedPatchDOs.keySet()) {
            ImmutableCollection patchDOs = groupedPatchDOs.get((Object)key);
            groups.add((Object)new PatchGroupDO(key, (Collection<PatchDO>)patchDOs));
        }
        return groups.build();
    }

    private class PatchToPatchDO
    implements Function<Patch, PatchDO> {
        private PatchToPatchDO() {
        }

        public PatchDO apply(@Nullable Patch patch) {
            return new PatchDO(patch, PatchListDO.this.principal, PatchListDO.this.sourceFactory);
        }
    }

    public class PatchGroupDO {
        private final String source;
        private final Collection<PatchDO> patchDOs;

        public PatchGroupDO(String source, Collection<PatchDO> patchDOs) {
            this.source = source;
            this.patchDOs = patchDOs;
        }

        public String getSource() {
            return this.source;
        }

        public String getSourceName() {
            return PatchListDO.this.sourceFactory.getSource(this.source, PatchListDO.this.principal).getDisplayName();
        }

        public String getPatchSourceId() {
            return this.source.replace("PATCH:", "");
        }

        public Collection<PatchDO> getPatchDOs() {
            return this.patchDOs;
        }
    }
}

