/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.util.PatchAnchorHelper;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.util.Pair;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PatchDO {
    private Patch patch;
    private Principal user;
    private List<CrucibleRevision> filesInReview;
    private List<CrucibleRevision> diffRevisions;
    private List<Pair<Path, Integer>> rootCandidates;
    private Integer candidateStripCount;
    private SourceFactory sourceFactory;

    public PatchDO(Patch patch, Principal user, SourceFactory sourceFactory) {
        this.patch = patch;
        this.user = user;
        this.sourceFactory = sourceFactory;
    }

    public String getSourceName() {
        return this.patch.getSourceName();
    }

    public Integer getPatchId() {
        return this.patch.getId();
    }

    public List<CrucibleRevision> getDiffRevisions() {
        if (this.diffRevisions == null) {
            try {
                this.diffRevisions = new LinkedList<CrucibleRevision>();
                for (DiffRevisionsInfo dri : this.patch.getDiffRevisions()) {
                    this.diffRevisions.add(this.patch.getFileRevisionFromDRI(dri));
                }
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)"Problem getting patch information.", (Throwable)e2);
            }
            catch (PatchException e3) {
                Logs.APP_LOG.error((Object)"Problem getting patch information.", (Throwable)e3);
            }
        }
        return this.diffRevisions;
    }

    private List<CrucibleRevision> getFilesInReview() {
        if (this.filesInReview == null) {
            this.filesInReview = this.patch.getReview().getRevisions();
        }
        return this.filesInReview;
    }

    public boolean isAllItemsInReview() {
        return this.filesInReview.size() != 0 && this.patch.getFileRevisions() != null && this.getFilesInReview().containsAll(this.getDiffRevisions());
    }

    public boolean isSomeItemsInReview() {
        List<CrucibleRevision> filesInReview = this.getFilesInReview();
        if (this.isAllItemsInReview() || this.patch.getFileRevisions() == null) {
            return false;
        }
        for (CrucibleRevision o2 : filesInReview) {
            if (!this.getDiffRevisions().contains(o2)) continue;
            return true;
        }
        return false;
    }

    public String getFileName() {
        return this.patch.getUploadItem().getOriginalName();
    }

    public boolean isAnchored() {
        return this.patch.isAnchored();
    }

    public String getAnchorSourceName() {
        return this.patch.getAnchorSource();
    }

    public boolean isAnchorSourcePathBased() {
        RepositoryEngine repoEngine = ((RepositorySource)this.getAnchoredSource(this.patch)).getRepoEngine();
        return repoEngine instanceof Svn2RepositoryEngine || repoEngine instanceof P4RepositoryEngine;
    }

    public String getAnchorPath() {
        return this.patch.getAnchorPath();
    }

    public Integer getStripCount() {
        return this.patch.getStripCount();
    }

    public List<Pair<Path, Integer>> getCandidateRoots() throws Exception {
        if (this.rootCandidates == null) {
            this.calculateRootCandidates();
        }
        return this.rootCandidates;
    }

    public int getCandidateRootsGroupCount() throws Exception {
        HashSet<Integer> counts = new HashSet<Integer>();
        for (Pair<Path, Integer> pair : this.getCandidateRoots()) {
            counts.add(pair.getSecond());
        }
        return counts.size();
    }

    public Integer getCandidateStripCount() throws Exception {
        if (this.candidateStripCount == null) {
            this.calculateRootCandidates();
        }
        return this.candidateStripCount;
    }

    private void calculateRootCandidates() throws Exception {
        Source source;
        if (!Strings.isNullOrEmpty((String)this.getAnchorSourceName()) && (source = this.getAnchoredSource(this.patch)) != null && source.isAvailable() && source instanceof RepositorySource) {
            RepositorySource repSource = (RepositorySource)source;
            Pair<Integer, Map<Path, Integer>> rootsPair = repSource.getRootPaths(this.patch);
            this.candidateStripCount = rootsPair.getFirst();
            this.rootCandidates = new ArrayList<Pair<Path, Integer>>();
            for (Map.Entry<Path, Integer> entry : rootsPair.getSecond().entrySet()) {
                this.rootCandidates.add(Pair.newInstance(entry.getKey(), entry.getValue()));
            }
            Collections.sort(this.rootCandidates, PatchAnchorHelper.ROOTS_COMPARATOR);
            return;
        }
        this.candidateStripCount = 0;
        this.rootCandidates = new ArrayList<Pair<Path, Integer>>();
    }

    private Source getAnchoredSource(Patch p2) {
        return p2 == null ? null : CrucibleFilter.getSource(p2.getAnchorSource());
    }

    public Collection<Source> getRepositories() {
        ArrayList<Source> possibleSources = new ArrayList<Source>();
        for (Source source : this.sourceFactory.getSources(this.user)) {
            if (!(source instanceof RepositorySource)) continue;
            possibleSources.add(source);
        }
        Collections.sort(possibleSources, new Comparator<Source>(){

            @Override
            public int compare(Source o1, Source o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return possibleSources;
    }
}

