/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import java.util.HashMap;
import java.util.Set;

public class ParticipantStats {
    private Review review;
    private HashMap participants = new HashMap();

    public ParticipantStats(Review review) {
        this.review = review;
        this.mapParticipantStats();
    }

    private void mapParticipantStats() {
        Set<ReviewParticipant> team = this.review.getTeam();
        for (ReviewParticipant p2 : team) {
            FecruUser user = p2.getUser();
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            int totalDraftComments = DefaultCommentManager.getInstance().countReviewGeneralComment(this.review, user, Boolean.TRUE, Boolean.FALSE, null) + DefaultCommentManager.getInstance().getReviewFrxsCommentCount(this.review, user, Boolean.TRUE, Boolean.FALSE, null);
            stats.put("totalDraftComments", totalDraftComments);
            int totalPostedComments = DefaultCommentManager.getInstance().countReviewGeneralComment(this.review, user, Boolean.FALSE, Boolean.FALSE, null) + DefaultCommentManager.getInstance().getReviewFrxsCommentCount(this.review, user, Boolean.FALSE, Boolean.FALSE, null);
            stats.put("totalPostedComments", totalPostedComments);
            int totalPostedDefectComments = DefaultCommentManager.getInstance().countReviewGeneralComment(this.review, user, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE) + DefaultCommentManager.getInstance().getReviewFrxsCommentCount(this.review, user, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE);
            stats.put("totalPostedDefectComments", totalPostedDefectComments);
            this.participants.put(user, stats);
        }
    }

    public HashMap getParticipantStats() {
        return this.participants;
    }
}

