/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.view.FRXDO;
import com.cenqua.crucible.view.InlineCommentDetailDO;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.LinePair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class LineDO {
    private final LinePair linepair;
    private LinkedHashMap<Integer, InlineCommentDetailDO> commentsMap = new LinkedHashMap();
    private LinkedHashMap<Integer, InlineCommentDetailDO> hiddenCommentsMap = new LinkedHashMap();
    private final List<InlineCommentDetailDO> invisibleComments;
    private final FRXDO frxDO;

    public LineDO(LinePair linepair, FRXDO frxDO, List<InlineCommentDetailDO> comments, List<InlineCommentDetailDO> invisibleComments) {
        this.linepair = linepair;
        this.frxDO = frxDO;
        this.addComments(comments);
        this.invisibleComments = invisibleComments;
    }

    public boolean isWholeFile() {
        return this.frxDO.isWholeFile();
    }

    private String makeLineId(String type, int line) {
        return this.makeLineId(type, Integer.toString(line), null);
    }

    private String makeLineId(String type, int start, int end) {
        return this.makeLineId(type, Integer.toString(start), Integer.toString(end));
    }

    private String makeLineId(String type, String start, String end) {
        StringBuilder sb = new StringBuilder(this.frxDO.getId().toString());
        sb.append("_line").append(type).append(start);
        if (end != null) {
            sb.append(",").append(end);
        }
        return sb.toString();
    }

    public LinePair getLinePair() {
        return this.linepair;
    }

    public Section getSection() {
        return this.linepair.getSection();
    }

    public List<InlineCommentDetailDO> getHiddenComments() {
        return new ArrayList<InlineCommentDetailDO>(this.hiddenCommentsMap.values());
    }

    public boolean isHiddenCommentsEmpty() {
        return this.hiddenCommentsMap.isEmpty();
    }

    public List<InlineCommentDetailDO> getComments() {
        return new ArrayList<InlineCommentDetailDO>(this.commentsMap.values());
    }

    public boolean isHasComment() {
        return this.getComments().size() > 0;
    }

    private void addComments(List<InlineCommentDetailDO> comments) {
        for (InlineCommentDetailDO icDO : comments) {
            if (icDO.isVisible()) {
                this.commentsMap.put(icDO.getId(), icDO);
                continue;
            }
            this.hiddenCommentsMap.put(icDO.getId(), icDO);
        }
    }

    public List<InlineCommentDetailDO> getInvisibleComments() {
        return this.invisibleComments;
    }

    public boolean isSkippedPrevious() {
        return this.linepair.isStartOfSection() && this.getSection().isSkippedPrevious();
    }
}

