/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.util.LineRangeUtil;
import com.cenqua.crucible.view.CommentDO;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.util.Collection;
import java.util.SortedSet;

public class InlineCommentDetailDO {
    private InlineCommentRevisionDetail toICRD;
    private InlineCommentRevisionDetail fromICRD;
    private int lastTo;
    private int lastFrom;
    private SortedSet<Integer> toLineRange;
    private SortedSet<Integer> fromLineRange;
    private Comment comment;
    private FecruUser currentUser;
    private final UnreadManager unreadManager;
    private final CurrentUserPermissions currentUserPermissions;
    private boolean visible = false;
    private Principal currentPrincipal;
    private boolean matched = false;

    public boolean isVisible() {
        return this.visible;
    }

    public void addVisible(boolean visible) {
        this.visible |= visible;
    }

    public InlineCommentDetailDO(UnreadManager unreadManager, FecruUser currentUser, Principal currentPrincipal, CurrentUserPermissions currentUserPermissions) {
        this.unreadManager = unreadManager;
        this.currentUser = currentUser;
        this.currentPrincipal = currentPrincipal;
        this.currentUserPermissions = currentUserPermissions;
    }

    public void setToICRD(InlineCommentRevisionDetail toICRD) {
        this.toICRD = toICRD;
        if (toICRD != null) {
            this.comment = toICRD.getInlineComment().getComment();
        }
    }

    public void setFromICRD(InlineCommentRevisionDetail fromICRD) {
        this.fromICRD = fromICRD;
        if (fromICRD != null) {
            this.comment = fromICRD.getInlineComment().getComment();
        }
    }

    public Integer getId() {
        return this.comment == null ? null : this.comment.getId();
    }

    public boolean isDraft() {
        return this.comment != null && this.comment.isDraft();
    }

    public CommentDO getCommentDO() {
        return this.comment != null ? new CommentDO(this.unreadManager, this.comment, this.currentUser, this.currentPrincipal, this.currentUserPermissions) : null;
    }

    public String getToLineRange() {
        if (this.toICRD != null) {
            return LineRangeUtil.generateLineRange(this.toLineRange);
        }
        return "";
    }

    public void addToLineRange(Collection<Integer> lines) {
        if (this.toLineRange == null) {
            this.toLineRange = new IntAVLTreeSet();
        }
        if (lines != null && lines.size() > 0) {
            this.toLineRange.addAll(lines);
        }
    }

    public String getFromLineRange() {
        if (this.fromICRD != null) {
            return LineRangeUtil.generateLineRange(this.fromLineRange);
        }
        return "";
    }

    public void addFromLineRange(Collection<Integer> lines) {
        if (this.fromLineRange == null) {
            this.fromLineRange = new IntAVLTreeSet();
        }
        if (lines != null && lines.size() > 0) {
            this.fromLineRange.addAll(lines);
        }
    }

    public String getToRevisionStr() {
        return this.toICRD != null ? this.toICRD.getFrxRevision().getRevision().getRevisionDisplayName() : "";
    }

    public String getFromRevisionStr() {
        return this.fromICRD != null ? this.fromICRD.getFrxRevision().getRevision().getRevisionDisplayName() : "";
    }

    public FRXRevision getToFrxRevision() {
        return this.toICRD == null ? null : this.toICRD.getFrxRevision();
    }

    public FRXRevision getFromFrxRevision() {
        return this.fromICRD == null ? null : this.fromICRD.getFrxRevision();
    }

    public String getRevisionStr() {
        if (this.isFromOnly()) {
            return this.getFromRevisionStr();
        }
        if (this.isToOnly() || this.toICRD.equals(this.fromICRD)) {
            return this.getToRevisionStr();
        }
        return this.getFromRevisionStr() + "-" + this.getToRevisionStr();
    }

    public FecruUser getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(FecruUser currentUser) {
        this.currentUser = currentUser;
    }

    public String getLinesPerRevisionString() {
        StringBuilder str = new StringBuilder("");
        if (this.fromICRD != null) {
            str.append(" Revision ").append(this.getFromRevisionStr());
            if (!this.fromLineRange.isEmpty()) {
                str.append(", ").append(this.fromLineRange.size() == 1 ? "line " : "lines ").append(this.getFromLineRange());
            }
        }
        if (this.toICRD != null) {
            str.append(" Revision ").append(this.getToRevisionStr());
            if (!this.toLineRange.isEmpty()) {
                str.append(", ").append(this.toLineRange.size() == 1 ? "line " : "lines ").append(this.getToLineRange());
            }
        }
        return str.toString();
    }

    public String getPath() {
        if (this.toICRD != null) {
            return this.toICRD.getFrxRevision().getRevision().getPath();
        }
        if (this.fromICRD != null) {
            return this.fromICRD.getFrxRevision().getRevision().getPath();
        }
        return null;
    }

    public int getLastTo() {
        return this.lastTo;
    }

    public void setLastTo(int lastTo) {
        if (lastTo > this.lastTo) {
            this.lastTo = lastTo;
        }
    }

    public int getLastFrom() {
        return this.lastFrom;
    }

    public void setLastFrom(int lastFrom) {
        if (lastFrom > this.lastFrom) {
            this.lastFrom = lastFrom;
        }
    }

    public boolean isFromOnly() {
        return this.toICRD == null && this.fromICRD != null;
    }

    public boolean isToOnly() {
        return this.toICRD != null && this.fromICRD == null;
    }

    public boolean isLastFromLine(int line) {
        if (this.lastFrom != line) {
            return false;
        }
        if (this.isLineRangeEmpty(this.fromLineRange)) {
            return false;
        }
        if (this.isLineRangeEmpty(this.toLineRange)) {
            this.matched = true;
            return true;
        }
        if (this.matched) {
            return true;
        }
        this.matched = true;
        return false;
    }

    private boolean isLineRangeEmpty(SortedSet lineRange) {
        return lineRange == null || lineRange.isEmpty();
    }

    public boolean isLastToLine(int line) {
        if (this.lastTo != line) {
            return false;
        }
        if (this.isLineRangeEmpty(this.fromLineRange)) {
            this.matched = true;
            return true;
        }
        if (this.isLineRangeEmpty(this.toLineRange)) {
            return false;
        }
        if (this.matched) {
            return true;
        }
        this.matched = true;
        return false;
    }

    public int getGutterLine() {
        if (this.isLineRangeEmpty(this.toLineRange) && !this.isLineRangeEmpty(this.fromLineRange)) {
            return this.lastFrom;
        }
        return this.lastTo;
    }

    public FileRevisionExtraInfo getFrx() {
        return this.toICRD != null ? this.toICRD.getFrxRevision().getFrx() : this.fromICRD.getFrxRevision().getFrx();
    }
}

