/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.PatchRevision;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.Source;
import com.google.common.base.Strings;

public class FRXRevisionDO {
    private final FecruUser currentUser;
    private final FRXRevision frxRevision;
    private final Principal currentPrincipal;
    private final boolean newSinceLastComplete;
    private Integer commentCount = null;
    private Integer unreadCommentCount = null;
    private final ContentManager contentManager;
    private final Source source;
    private CrucibleRevision anchoredRevision;
    private Source anchorSource;
    private final CurrentUserPermissions currentUserPermissions;

    public FRXRevisionDO(FRXRevision frxRevision, FecruUser currentUser, Principal currentPrincipal, CurrentUserPermissions currentUserPermissions, boolean newSinceLastComplete, ContentManager contentManager, Source source) {
        this.frxRevision = frxRevision;
        this.currentUser = currentUser;
        this.currentPrincipal = currentPrincipal;
        this.newSinceLastComplete = newSinceLastComplete;
        this.contentManager = contentManager;
        this.source = source;
        this.currentUserPermissions = currentUserPermissions;
    }

    public Integer getId() {
        return this.frxRevision.getId();
    }

    public CrucibleRevision getCrucibleRevision() {
        return this.frxRevision.getRevision();
    }

    public int getCommentCount() {
        if (this.commentCount == null) {
            this.commentCount = this.frxRevision.getCommentCount();
        }
        return this.commentCount;
    }

    public int getUnreadCommentCount() {
        if (this.unreadCommentCount == null) {
            if (!this.currentUserPermissions.canCommentReview(this.frxRevision.getFrx().getReview())) {
                this.unreadCommentCount = 0;
            } else {
                int readCommentCount = this.frxRevision.getReadInlineCommentCount(this.currentUser);
                this.unreadCommentCount = this.getCommentCount() - readCommentCount;
            }
        }
        return this.unreadCommentCount;
    }

    public boolean isNewSinceLastComplete() {
        return this.newSinceLastComplete;
    }

    public boolean isAnchored() throws Exception {
        return this.getAnchoredRevision() != null;
    }

    public CrucibleRevision getAnchoredRevision() throws Exception {
        if (!Strings.isNullOrEmpty((String)this.getAnchoredSourceName()) && this.anchoredRevision == null) {
            if (!this.isPatch()) {
                throw new IllegalArgumentException("Only patch revisions can be anchored. " + this.source.getName() + " is not a patch source.");
            }
            PatchRevision patchRevision = PatchRevision.fromCrucibleRevision(this.getCrucibleRevision());
            this.anchoredRevision = ((PatchSource)this.source).getRevisionAnchor(this.contentManager, this.frxRevision.getRevision(), patchRevision.isFrom, this.getAnchorSource());
        }
        return this.anchoredRevision;
    }

    public boolean isPatch() {
        return this.source instanceof PatchSource;
    }

    public String getAnchoredSourceName() {
        if (!this.isPatch()) {
            return null;
        }
        return ((PatchSource)this.source).getAnchoredSourceName(this.frxRevision.getRevision());
    }

    private Source getAnchorSource() {
        if (!Strings.isNullOrEmpty((String)this.getAnchoredSourceName()) && this.anchorSource == null) {
            this.anchorSource = this.contentManager.getSource(this.getAnchoredSourceName(), this.currentPrincipal);
        }
        return this.anchorSource;
    }

    public String getChangeSetId() throws Exception {
        String csid;
        CrucibleRevision fr = !this.isPatch() ? this.getCrucibleRevision() : this.getAnchoredRevision();
        String string = csid = fr == null ? null : fr.getDetail("changeset");
        if (csid != null) {
            return csid;
        }
        try {
            return this.source.isAvailable() ? this.source.getChangeSetId(fr) : null;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

