/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.revision.source.UploadSource;
import com.cenqua.crucible.util.SourceUtils;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.Path;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FRXNavList {
    private static final String PATH_SEPARATOR = "/";
    private static final String ROOT_PATH = "/";
    private static final String NORMALIZED_ROOT_PATH = new Path("/").getPath();
    private static final Joiner JOINER_ON_PATH_SEPARATOR = Joiner.on((String)"/");
    private static final Comparator<FRXDO> FRXDO_PATH_COMPARATOR = new Comparator<FRXDO>(){

        @Override
        public int compare(FRXDO x2, FRXDO y2) {
            int pathResult;
            String ySource;
            String xSource = x2.getFrx().getFileRevision().getSourceName();
            int sourceResult = xSource.compareTo(ySource = y2.getFrx().getFileRevision().getSourceName());
            if (sourceResult != 0) {
                return sourceResult;
            }
            if (this.isNotGit(x2, y2)) {
                int branchResult;
                String xBranch = x2.getFrx().getFileRevision().getBranch();
                String yBranch = y2.getFrx().getFileRevision().getBranch();
                if (xBranch != null && yBranch != null && (branchResult = xBranch.compareTo(yBranch)) != 0) {
                    return branchResult;
                }
            }
            if ((pathResult = x2.getFePath().compareTo(y2.getFePath())) == 0) {
                if (x2.isDir() && y2.isDir()) {
                    return 0;
                }
                if (x2.isDir()) {
                    return 1;
                }
                if (y2.isDir()) {
                    return -1;
                }
                return 0;
            }
            return pathResult;
        }

        private boolean isNotGit(FRXDO x2, FRXDO y2) {
            assert (x2.getSource().equals(y2.getSource()));
            return !SourceUtils.isGit(x2.getSource());
        }
    };
    private List<FRXNavListNode> flattenedNodes = null;
    private final Map<Integer, FRXDO> frxDOs;
    private final Principal currentPrincipal;
    private final SourceFactory sourceFactory;
    private final Map<String, FRXNavTreeNode> sourceRoots = new TreeMap<String, FRXNavTreeNode>();

    public FRXNavList(Iterator<FRXDO> frxs, SourceFactory sourceFactory, Principal currentPrincipal) {
        this.sourceFactory = sourceFactory;
        this.currentPrincipal = currentPrincipal;
        this.frxDOs = new LinkedHashMap<Integer, FRXDO>();
        while (frxs.hasNext()) {
            FRXDO frxDO = frxs.next();
            if (frxDO == null) continue;
            this.frxDOs.put(frxDO.getId(), frxDO);
        }
        this.buildNavList(this.frxDOs.values());
    }

    private void buildNavList(Collection<FRXDO> frxDos) {
        ArrayList<FRXDO> list = new ArrayList<FRXDO>(frxDos);
        Collections.sort(list, FRXDO_PATH_COMPARATOR);
        for (FRXDO frxDO : list) {
            Path path = frxDO.getFePath();
            CrucibleRevision fileRevision = frxDO.getFrx().getFileRevision();
            String branch = fileRevision.getBranch();
            String source = fileRevision.getSourceName();
            FRXNavTreeNode added = this.addPath(source, branch, path);
            added.extension = path.getExtension();
            added.frxId = frxDO.getId();
            added.commentCount = frxDO.getTotalCommentCount();
            added.unreadCommentCount = frxDO.getTotalUnreadCommentCount();
        }
    }

    private FRXNavTreeNode getSourceNode(String sourceName, String branch) {
        if (Strings.isNullOrEmpty((String)sourceName)) {
            throw new IllegalArgumentException("sourceName cannot be null");
        }
        if (sourceName.startsWith("UPLOAD:")) {
            sourceName = "UPLOAD:";
        }
        Source source = this.sourceFactory.getSource(sourceName, this.currentPrincipal);
        String sourceRootKey = Strings.isNullOrEmpty((String)branch) || SourceUtils.isGit(source) ? sourceName : sourceName + "-" + branch;
        FRXNavTreeNode sourceNode = this.sourceRoots.get(sourceRootKey);
        if (sourceNode == null) {
            String name = sourceName;
            if (source != null) {
                name = source instanceof PatchSource ? source.getDisplayName() : (source instanceof UploadSource ? "Attachments" : (SourceUtils.isGit(source) ? source.getName() : (!Strings.isNullOrEmpty((String)branch) ? source.getName() + " (" + branch + ")" : source.getName())));
            }
            sourceNode = new FRXNavTreeNode(name, -1);
            sourceNode.isSourceNode = true;
            this.sourceRoots.put(sourceRootKey, sourceNode);
        }
        return sourceNode;
    }

    private FRXNavTreeNode addPath(String source, String branch, Path path) {
        FRXNavTreeNode node = this.getSourceNode(source, branch);
        ArrayList<String> componentsIncludingRoot = new ArrayList<String>(Arrays.asList(NORMALIZED_ROOT_PATH));
        componentsIncludingRoot.addAll(Arrays.asList(path.getComponents()));
        for (int i2 = 0; i2 < componentsIncludingRoot.size(); ++i2) {
            boolean isFrxComponent;
            String component = (String)componentsIncludingRoot.get(i2);
            FRXNavTreeNode tmpNode = node.getNode(component);
            boolean isUnseenComponent = tmpNode == null;
            boolean bl = isFrxComponent = i2 == componentsIncludingRoot.size() - 1;
            if (isUnseenComponent || isFrxComponent) {
                tmpNode = new FRXNavTreeNode(component, node.depth + 1);
                tmpNode.isInReview = isFrxComponent;
                node.addNode(tmpNode);
            }
            node = tmpNode;
        }
        return node;
    }

    public List<FRXNavListNode> getNavList() {
        if (this.flattenedNodes == null) {
            this.flattenedNodes = new ArrayList<FRXNavListNode>();
            for (FRXNavTreeNode sourceNode : this.sourceRoots.values()) {
                List<FRXNavListNode> sourceNodes = this.addSourceNodes(sourceNode);
                this.flattenedNodes.addAll(sourceNodes);
            }
        }
        return this.flattenedNodes;
    }

    private List<FRXNavListNode> addSourceNodes(FRXNavTreeNode sourceNode) {
        FRXNavListNode node;
        ArrayList<FRXNavListNode> nodes = new ArrayList<FRXNavListNode>();
        if (!sourceNode.isLeaf()) {
            this.addChildNodes(sourceNode, nodes, 0);
        }
        if (nodes.size() > 1 && (node = (FRXNavListNode)nodes.get(1)).getPath().equals("/") && !node.isInReview()) {
            nodes.remove(1);
            for (int i2 = 1; i2 < nodes.size(); ++i2) {
                FRXNavListNode fRXNavListNode = (FRXNavListNode)nodes.get(i2);
                fRXNavListNode.depth = fRXNavListNode.depth - 1;
            }
        }
        return nodes;
    }

    private void addChildNodes(FRXNavTreeNode node, List<FRXNavListNode> nodes, int compressionCount) {
        int depth = node.depth - compressionCount;
        FRXNavListNode listNode = new FRXNavListNode(node.name, node.frxId, depth, node.isLeaf(), node.commentCount, node.unreadCommentCount, node.extension);
        listNode.isInReview = node.isInReview;
        listNode.isSourceNode = node.isSourceNode;
        if (this.frxDOs != null && node.frxId >= 0) {
            listNode.setFrxDO(this.frxDOs.get(node.frxId));
        }
        nodes.add(listNode);
        while (!this.sourceRoots.values().contains(node) && node.hasOneChild() && !node.isInReview) {
            if ((node = node.getFirst()).isLeaf() || node.frxId >= 0) {
                this.addChildNodes(node, nodes, compressionCount);
                return;
            }
            listNode.addPath(node.name);
            ++compressionCount;
        }
        List<FRXNavTreeNode> children = node.getNodes();
        Collections.sort(children, new Comparator<FRXNavTreeNode>(){

            @Override
            public int compare(FRXNavTreeNode n1, FRXNavTreeNode n2) {
                if (n1.isLeaf() && n2.isLeaf()) {
                    FRXDO do1 = (FRXDO)FRXNavList.this.frxDOs.get(n1.frxId);
                    FRXDO do2 = (FRXDO)FRXNavList.this.frxDOs.get(n2.frxId);
                    if (do1.isDir() == do2.isDir()) {
                        return n1.name.compareTo(n2.name);
                    }
                    return do1.isDir() ? -1 : 1;
                }
                if (!n1.isLeaf() && !n2.isLeaf()) {
                    return n1.name.compareTo(n2.name);
                }
                return n1.isLeaf() ? 1 : -1;
            }
        });
        for (FRXNavTreeNode n2 : children) {
            this.addChildNodes(n2, nodes, compressionCount);
        }
    }

    public static class FRXNavListNode {
        private final List<String> paths = new ArrayList<String>();
        private final Integer frxId;
        private int depth;
        private final boolean isLeaf;
        private final int commentCount;
        private final int unreadCommentCount;
        private final String extension;
        private FRXDO frxDO;
        private boolean isInReview = false;
        private boolean isSourceNode = false;

        public FRXNavListNode(String path, Integer frxId, int depth, boolean isLeaf, int commentCount, int unreadCommentCount, String extension) {
            this.addPath(path);
            this.frxId = frxId;
            this.depth = depth;
            this.isLeaf = isLeaf;
            this.commentCount = commentCount;
            this.unreadCommentCount = unreadCommentCount;
            this.extension = extension;
        }

        public String getPath() {
            if (this.paths.size() == 1 && this.paths.get(0).equals(NORMALIZED_ROOT_PATH)) {
                return "/";
            }
            if (this.paths.size() > 1 && this.paths.get(0).equals(NORMALIZED_ROOT_PATH)) {
                return JOINER_ON_PATH_SEPARATOR.join(this.paths.subList(1, this.paths.size()));
            }
            return JOINER_ON_PATH_SEPARATOR.join(this.paths);
        }

        public boolean isInReview() {
            return this.isInReview;
        }

        public boolean isSourceNode() {
            return this.isSourceNode;
        }

        public void addPath(String p2) {
            if (NORMALIZED_ROOT_PATH.equals(p2) || !Strings.isNullOrEmpty((String)p2)) {
                this.paths.add(p2);
            }
        }

        public String getExtension() {
            return this.extension;
        }

        public Integer getFrxId() {
            return this.frxId;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public int getCommentCount() {
            return this.commentCount;
        }

        public int getUnreadCommentCount() {
            return this.unreadCommentCount;
        }

        public FRXDO getFrxDO() {
            return this.frxDO;
        }

        public void setFrxDO(FRXDO frxDO) {
            this.frxDO = frxDO;
        }
    }

    private static class FRXNavTreeNode {
        final Multimap<String, FRXNavTreeNode> nodes = ArrayListMultimap.create();
        final String name;
        final Integer depth;
        int frxId = -1;
        int commentCount;
        int unreadCommentCount;
        String extension;
        boolean isInReview = false;
        boolean isSourceNode = false;

        FRXNavTreeNode(String name, int depth) {
            this.name = name;
            this.depth = depth;
        }

        boolean isLeaf() {
            return this.nodes.isEmpty();
        }

        boolean hasOneChild() {
            return this.nodes.size() == 1;
        }

        void addNode(FRXNavTreeNode node) {
            this.nodes.put((Object)node.name, (Object)node);
        }

        List<FRXNavTreeNode> getNodes() {
            return new ArrayList<FRXNavTreeNode>(this.nodes.values());
        }

        FRXNavTreeNode getFirst() {
            return (FRXNavTreeNode)this.nodes.values().iterator().next();
        }

        FRXNavTreeNode getNode(String name) {
            Collection nodesForName = this.nodes.get((Object)name);
            return nodesForName == null || nodesForName.isEmpty() ? null : (FRXNavTreeNode)nodesForName.iterator().next();
        }
    }
}

