/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.atlassian.crucible.spi.data.FisheyeReviewItemData;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.scm.SCMSource;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileReadStatus;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.tetris.GutterComment;
import com.cenqua.crucible.tetris.TetrisGrid;
import com.cenqua.crucible.tetris.TetrisLine;
import com.cenqua.crucible.view.DiffDO;
import com.cenqua.crucible.view.FRXCommentDO;
import com.cenqua.crucible.view.FRXRevisionDO;
import com.cenqua.crucible.view.InlineCommentDetailDO;
import com.cenqua.crucible.view.LineDO;
import com.cenqua.crucible.view.RevInfoDO;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.diff.view.LinePair;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;

public class FRXDO {
    private final FileRevisionExtraInfo frx;
    private final CurrentUserPermissions currentUserPermissions;
    private Map<Comment, InlineCommentDetailDO> icCommentMap;
    private List<GutterComment> gutterComments;
    private List<FRXCommentDO> frxComments;
    private List<InlineCommentDetailDO> inlineCommentDetails;
    private AnnotatedFileHistory annotatedFileHistory = new AnnotatedFileHistory();
    private Integer commentCount;
    private Integer unreadCommentCount;
    private LinkedList<LineDO> lines;
    private final FecruUser currentUser;
    private FRXRevision fromFrxRevision;
    private FRXRevision toFrxRevision;
    private int diffContext;
    private boolean ignore_BL = true;
    private boolean ignore_w = false;
    private boolean ignore_b = true;
    private String keywordOpts;
    private String errorMsg;
    private final Source source;
    private DiffDO diffDO;
    private DiffPrinter diffPrinterCache;
    private boolean sideBySide;
    private boolean softWrap;
    private final boolean displayable;
    private final boolean allowContentFetch;
    private String latestRevIdent;
    private Integer latestCruRevId;
    private Boolean anySuccessorRevisions;
    private Boolean wholeFile;
    private final ContentManager contentManager;
    private final UnreadManager unreadManager;
    private final UnreadFileManager unreadFileManager;
    private final UserProfileManager userProfileManager;
    private Principal currentPrincipal;
    private CrucibleRevision anchoredRevision;
    private Source anchorSource;
    private String anchoredSourceName;
    private ReviewParticipant currentParticipant;
    private Boolean markedLeaveUnread;
    private static final int MAX_TRUNCATED_PATH_LENGTH = 40;

    protected FRXDO() {
        this.frx = null;
        this.currentUser = null;
        this.source = null;
        this.displayable = false;
        this.allowContentFetch = false;
        this.contentManager = null;
        this.unreadManager = null;
        this.unreadFileManager = null;
        this.diffContext = this.getUserProfile().getContext();
        this.userProfileManager = null;
        this.currentUserPermissions = null;
    }

    public FRXDO(ContentManager contentManager, UnreadManager unreadManager, UnreadFileManager unreadFileManager, UserProfileManager userProfileManager, FileRevisionExtraInfo frx, FecruUser currentUser, Principal principal, CurrentUserPermissions currentUserPermissions, String keywordOpts, boolean sideBySide, boolean softWrap, SourceFactory sourceFactory, boolean displayable, boolean allowContentFetch) {
        this.allowContentFetch = allowContentFetch;
        this.frx = frx;
        this.fromFrxRevision = frx.getShowAsDiff() != false ? frx.getFromFRXRevision() : frx.getFileFRXRevision();
        this.toFrxRevision = frx.getFileFRXRevision();
        this.softWrap = softWrap;
        this.setSideBySide(sideBySide);
        this.displayable = displayable;
        this.contentManager = contentManager;
        this.unreadManager = unreadManager;
        this.unreadFileManager = unreadFileManager;
        this.userProfileManager = userProfileManager;
        this.currentUserPermissions = currentUserPermissions;
        this.currentUser = currentUser;
        this.currentPrincipal = principal;
        this.diffContext = this.getUserProfile().getContext();
        this.source = sourceFactory.getSource(this.getToRevision().getSourceName(), principal);
        if (!this.source.isAvailable()) {
            this.errorMsg = this.source.getReason();
        }
        if (!this.isSliderFixedMinimum() && this.isNewSinceComplete()) {
            FRXRevision newFromRev = null;
            boolean lastNew = false;
            for (FRXRevision rev : frx.getFrxRevisions()) {
                boolean thisNew = this.isNewSinceComplete(rev);
                if (lastNew) {
                    if (thisNew) continue;
                    newFromRev = null;
                    break;
                }
                if (thisNew) {
                    lastNew = true;
                    continue;
                }
                newFromRev = rev;
            }
            if (newFromRev != null) {
                this.fromFrxRevision = newFromRev;
            }
        }
        this.setKeywordOpts(keywordOpts);
        if (allowContentFetch) {
            this.mapInlineComments();
        }
    }

    public boolean isSliderFixedMinimum() {
        return this.isPatch() && (!this.isAnchoredPatch() || this.isAnchorFailure());
    }

    public UserProfile getUserProfile() {
        try {
            if (this.getCurrentUser() == null) {
                return UserProfileManager.DEFAULT_PROFILE;
            }
            return this.userProfileManager.getProfile(this.getCurrentUser().getUsername());
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)("DbException: " + e2.getMessage()), (Throwable)e2);
            return UserProfileManager.DEFAULT_PROFILE;
        }
    }

    public Integer getId() {
        return this.getFrx().getId();
    }

    public FileRevisionExtraInfo getFrx() {
        return this.frx;
    }

    public Review getReview() {
        return this.frx.getReview();
    }

    public String getPermaId() {
        return this.frx.getPermaId();
    }

    public List<FRXRevisionDO> getFrxRevisionDOs() {
        ArrayList<FRXRevisionDO> dos = new ArrayList<FRXRevisionDO>();
        for (FRXRevision frxRevision : this.getFrxRevisions()) {
            dos.add(new FRXRevisionDO(frxRevision, this.currentUser, this.currentPrincipal, this.currentUserPermissions, this.isNewSinceComplete(frxRevision), this.contentManager, this.source));
        }
        return dos;
    }

    public CrucibleRevision getFromRevision() {
        if (this.fromFrxRevision == null) {
            return null;
        }
        return this.fromFrxRevision.getRevision();
    }

    public FRXRevision getFromFrxRevision() {
        return this.fromFrxRevision;
    }

    public void setFromFrxRevision(FRXRevision fromFrxRevision) {
        if (this.isSliderFixedMinimum()) {
            return;
        }
        this.fromFrxRevision = fromFrxRevision;
    }

    public CrucibleRevision getToRevision() {
        return this.toFrxRevision.getRevision();
    }

    public FRXRevision getToFrxRevision() {
        return this.toFrxRevision;
    }

    public void setToFrxRevision(FRXRevision toFrxRevision) {
        this.toFrxRevision = toFrxRevision;
    }

    public boolean areFromRevisionAndToRevisionEqual() {
        return this.getFromRevision() != null && this.getToRevision() != null && this.getFromRevision().getPath().equals(this.getToRevision().getPath()) && this.getFromRevision().getRevision().equals(this.getToRevision().getRevision());
    }

    public String getVisibleFrxRevisionsStr() {
        String id = "";
        if (this.fromFrxRevision != null) {
            id = id + this.fromFrxRevision.getId();
        }
        id = id + "-" + this.toFrxRevision.getId();
        return id;
    }

    public int getDiffContext() {
        return this.diffContext;
    }

    public void setDiffContext(int diffContext) {
        this.diffContext = diffContext;
        this.diffPrinterCache = null;
    }

    public boolean isIgnore_BL() {
        return this.ignore_BL;
    }

    public void setIgnore_BL(boolean ignore_BL) {
        this.ignore_BL = ignore_BL;
        this.diffPrinterCache = null;
    }

    public boolean isIgnore_w() {
        return this.ignore_w;
    }

    public void setIgnore_w(boolean ignore_w) {
        this.ignore_w = ignore_w;
        this.diffPrinterCache = null;
    }

    public boolean isIgnore_b() {
        return this.ignore_b;
    }

    public void setIgnore_b(boolean ignore_b) {
        this.ignore_b = ignore_b;
        this.diffPrinterCache = null;
    }

    public boolean isSoftWrap() {
        return this.softWrap;
    }

    public void setSoftWrap(boolean softWrap) {
        this.softWrap = softWrap;
        this.diffPrinterCache = null;
    }

    public DiffOpts getDiffOption() {
        DiffOpts opts = new DiffOpts();
        opts.setSideBySide(this.sideBySide);
        opts.setSoftWrap(this.softWrap);
        opts.setIgnoreBlankLines(this.ignore_BL);
        if (this.ignore_b) {
            opts.setWhitespaceOpts(DiffOpts.WhitespaceOpts.IgnoreSignificant);
        } else if (this.ignore_w) {
            opts.setWhitespaceOpts(DiffOpts.WhitespaceOpts.IgnoreAll);
        }
        return opts;
    }

    public String getKeywordOpts() {
        return this.keywordOpts;
    }

    public void setKeywordOpts(String keywordOpts) {
        this.diffPrinterCache = null;
        this.keywordOpts = keywordOpts;
    }

    public Path getFePath() {
        return this.getToRevision().getFePath();
    }

    public String getPath() {
        return this.getToRevision().getPath();
    }

    public String getPathTruncated() {
        Path path = this.getFePath();
        Path prefix = this.getTruncatedToRevisionParentPath();
        String basename = path.getName();
        StringBuilder pathTruncated = new StringBuilder();
        if (!path.isRoot()) {
            pathTruncated.append("/");
        }
        pathTruncated.append(prefix.getPath());
        if (!prefix.isRoot()) {
            pathTruncated.append("/");
        }
        pathTruncated.append(basename);
        if (this.isDir()) {
            pathTruncated.append("/");
        }
        return pathTruncated.toString();
    }

    public ReviewParticipant getParticipant() {
        Review review;
        if (this.currentParticipant == null && (review = this.getReview()) != null) {
            this.currentParticipant = review.getParticipant(this.getCurrentUser());
        }
        return this.currentParticipant;
    }

    public FecruUser getCurrentUser() {
        return this.currentUser;
    }

    public boolean isComplete() {
        ReviewParticipant p2 = this.getParticipant();
        return p2 != null && p2.isRead(this.frx);
    }

    public boolean isMarkedLeaveUnread() {
        if (this.markedLeaveUnread == null) {
            ReviewParticipant p2 = this.getParticipant();
            this.markedLeaveUnread = this.unreadFileManager.isMarkedLeaveUnread(p2, this.frx);
        }
        return this.markedLeaveUnread;
    }

    public String getReadStatusText() {
        if (this.isComplete()) {
            return "read";
        }
        if (this.isMarkedLeaveUnread() && this.getUserProfile().isAutoMarkFilesRead()) {
            return "leaveUnread";
        }
        return "unread";
    }

    public boolean isNewSinceComplete() {
        ReviewParticipant p2 = this.getParticipant();
        if (p2 == null) {
            return true;
        }
        FileReadStatus status = p2.getReadStatus(this.frx);
        if (status == null) {
            return true;
        }
        Long unreadTime = status.getLastUnreadDateTime();
        if (unreadTime == null) {
            return false;
        }
        Long updatedTime = 0L;
        for (FRXRevision rev : this.getFrxRevisions()) {
            updatedTime = Math.max(rev.getDateTimeAdded(), updatedTime);
        }
        return updatedTime.compareTo(unreadTime) >= 0;
    }

    public boolean isNewSinceComplete(FRXRevision rev) {
        ReviewParticipant p2 = this.getParticipant();
        if (p2 == null) {
            return true;
        }
        FileReadStatus status = p2.getReadStatus(this.frx);
        if (status == null) {
            return true;
        }
        Long unreadTime = status.getLastUnreadDateTime();
        if (unreadTime == null) {
            return true;
        }
        Long updatedTime = rev.getDateTimeAdded();
        return updatedTime.compareTo(unreadTime) >= 0;
    }

    public boolean getHasEverCompleted() {
        ReviewParticipant p2 = this.getParticipant();
        if (p2 == null) {
            return false;
        }
        FileReadStatus status = p2.getReadStatus(this.frx);
        return status != null && status.getLastUnreadDateTime() != null;
    }

    public boolean isPatch() {
        return this.source instanceof PatchSource;
    }

    public boolean isMisalignedPatch() throws IOException {
        return this.isPatch() && !((PatchSource)this.source).hasFullContent(this.toFrxRevision.getRevision()) && (this.fromFrxRevision == this.toFrxRevision || this.getFrxRevisions().indexOf(this.fromFrxRevision) != 0);
    }

    public String getAnchoredSourceName() {
        if (this.anchoredSourceName == null && this.isPatch()) {
            this.anchoredSourceName = ((PatchSource)this.source).getAnchoredSourceName(this.getToRevision());
        }
        return this.anchoredSourceName;
    }

    public boolean isAnchorFailure() {
        boolean isAnchoredPatch = this.isAnchoredPatch();
        boolean isAnchoredFile = this.isAdded() || isAnchoredPatch && this.isAnchoredRevision();
        return isAnchoredPatch && !isAnchoredFile;
    }

    public boolean isAnchoredPatch() {
        return this.isPatch() && !Strings.isNullOrEmpty((String)this.getAnchoredSourceName());
    }

    private boolean isAnchoredRevision() {
        return !this.getFrxRevisions().isEmpty() && this.getFrxRevisions().get(0).getRevision().getDetail("ANCHORED_REV") != null;
    }

    private Source getAnchorSource() {
        if (this.anchorSource == null) {
            this.anchorSource = this.contentManager.getSource(this.getAnchoredSourceName(), this.currentPrincipal);
        }
        return this.anchorSource;
    }

    public boolean isRepositorySource() {
        return this.source instanceof RepositorySource;
    }

    public boolean isSCMSource() {
        return this.source instanceof SCMSource;
    }

    public boolean isSideBySide() throws Exception {
        DiffPrinter diffPrinter;
        DiffPrinter diffPrinter2 = diffPrinter = this.allowContentFetch ? this.getDiffPrinter() : null;
        return this.allowContentFetch ? this.isDisplayDiff() && diffPrinter != null && diffPrinter.isSideBySide() : this.isSetToSideBySide() && !this.isWholeFile();
    }

    public boolean isSetToSideBySide() throws Exception {
        return this.isDisplayDiff() && this.getDiffOption().sideBySide();
    }

    public boolean isStoreDiffs() {
        if (this.isRepositorySource()) {
            RepositoryHandle repositoryHandle = ((RepositorySource)this.source).getRepositoryHandle();
            return repositoryHandle != null && repositoryHandle.getCfg().isStoreDiffs();
        }
        return false;
    }

    public int getDiffColumns() throws Exception {
        boolean tetris = true;
        int blame = this.isShowBlame() ? 2 : 0;
        int lineNumbers = this.isWholeFile() ? 1 : 2;
        boolean content = true;
        boolean navHandles = true;
        int singleRevisionCols = 1 + blame + lineNumbers + 1 + 1;
        return singleRevisionCols * (this.isSideBySide() ? 2 : 1) + this.getPluginGuttersCount();
    }

    public boolean isAnySuccessorRevisions() {
        if (this.anySuccessorRevisions == null) {
            this.anySuccessorRevisions = this.source.isAvailable() && this.source.isAnySuccessorRevisions(this.frx.getFileRevision());
        }
        return this.anySuccessorRevisions;
    }

    public String getLatestRevIdent() {
        this.initLatestRevs();
        return this.latestRevIdent;
    }

    public Integer getLatestCruRevId() {
        if (this.latestCruRevId == null) {
            this.initLatestRevs();
        }
        return this.latestCruRevId;
    }

    private void initLatestRevs() {
        if (this.latestRevIdent == null) {
            String string = this.latestRevIdent = this.source.isAvailable() ? this.source.getLatestRevIdent(this.getToRevision()) : null;
        }
        if (this.latestCruRevId == null && this.latestRevIdent != null) {
            CrucibleRevision rev = this.contentManager.getCrucibleRevision(this.source, this.toFrxRevision.getRevision().getPath(), this.latestRevIdent);
            if (rev != null) {
                this.latestCruRevId = rev.getId();
            } else {
                Logs.APP_LOG.error((Object)("Could not find revision " + this.toFrxRevision.getRevision().getPath() + " " + this.latestRevIdent + " in " + this.source.getDisplayName()));
            }
        }
    }

    public String getLink() {
        return this.getToRevision().getDetail("revisionLink");
    }

    public String getChangeSetId() {
        String csid = this.getToRevision().getDetail("changeset");
        if (csid != null) {
            return csid;
        }
        try {
            return this.source.isAvailable() ? this.source.getChangeSetId(this.getToRevision()) : null;
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)"Exception getting Changeset Id", (Throwable)e2);
            return null;
        }
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public boolean isDisplayable() {
        return this.displayable;
    }

    public boolean isUpToDate() {
        return !this.contentManager.needsUpdate(this.getToRevision());
    }

    public Source getSource() {
        return this.source;
    }

    @Nullable
    public CrucibleRevision getFirstRevision() {
        return (CrucibleRevision)Iterables.getFirst(this.frx.getCrucibleRevisions(), null);
    }

    private static boolean isTrue(Boolean value) {
        return value != null && value != false;
    }

    public boolean isFromDeleted() {
        if (this.getFromRevision() == null) {
            return false;
        }
        Boolean d2 = this.getFromRevision().isDeletion();
        return d2 != null && d2 != false;
    }

    public FisheyeReviewItemData.CommitType getCommitType() {
        CrucibleRevision firstRevision = this.getFirstRevision();
        if (FRXDO.isTrue(this.getToRevision().isCopied())) {
            return FisheyeReviewItemData.CommitType.Copied;
        }
        if (FRXDO.isTrue(this.getToRevision().isMoved())) {
            return FisheyeReviewItemData.CommitType.Moved;
        }
        if (FRXDO.isTrue(this.getToRevision().isDeletion())) {
            return FisheyeReviewItemData.CommitType.Deleted;
        }
        if (firstRevision != null && FRXDO.isTrue(firstRevision.isAdded()) && !this.frx.getShowAsDiff().booleanValue()) {
            return FisheyeReviewItemData.CommitType.Added;
        }
        if (FRXDO.isTrue(this.getToRevision().isModified())) {
            return FisheyeReviewItemData.CommitType.Modified;
        }
        return FisheyeReviewItemData.CommitType.Unknown;
    }

    public boolean isAdded() {
        return this.getCommitType() == FisheyeReviewItemData.CommitType.Added;
    }

    public boolean isChanged() {
        return this.getCommitType() == FisheyeReviewItemData.CommitType.Modified;
    }

    public boolean isMoved() {
        return this.getCommitType() == FisheyeReviewItemData.CommitType.Moved;
    }

    public boolean isCopied() {
        return this.getCommitType() == FisheyeReviewItemData.CommitType.Copied;
    }

    public boolean isDeleted() {
        return this.getCommitType() == FisheyeReviewItemData.CommitType.Deleted;
    }

    public boolean isText() {
        return !this.isBinary() && !this.isDir() && !this.isOversize();
    }

    public boolean isDir() {
        return this.getFrx().isDir();
    }

    public boolean isBinary() {
        Boolean fromBinary;
        boolean deleted = this.isDeleted();
        CrucibleRevision toRevision = this.getToRevision();
        Boolean toBinary = toRevision.isBinary();
        boolean toIsBinary = toBinary != null && !deleted ? toBinary.booleanValue() : this.guessIfBinary(toRevision.getFileName());
        CrucibleRevision fromRevision = this.getFromRevision();
        Boolean bl = fromBinary = fromRevision == null ? null : fromRevision.isBinary();
        if (fromRevision != null && fromBinary != null) {
            if (deleted) {
                return fromBinary;
            }
            return toIsBinary || fromBinary != false;
        }
        return toIsBinary;
    }

    private boolean guessIfBinary(String fileName) {
        return AppConfig.getsConfig().getRawMimeMap().isBinaryType(fileName.toLowerCase(Locale.US));
    }

    public boolean isWholeFile() {
        if (this.wholeFile == null) {
            this.wholeFile = this.getFromFrxRevision() == null || this.getToFrxRevision() == null ? Boolean.valueOf(true) : (this.isPatch() && (!this.isAnchoredPatch() || this.isAnchorFailure()) ? Boolean.valueOf(false) : Boolean.valueOf(this.getFromFrxRevision().equals(this.getToFrxRevision())));
        }
        return this.wholeFile;
    }

    public boolean isDisplayDiff() throws FileRevisionException {
        return this.isText();
    }

    public boolean isOversize() {
        return Boolean.TRUE.equals(this.getToRevision().isOversize()) || this.getFromRevision() != null && Boolean.TRUE.equals(this.getFromRevision().isOversize());
    }

    public boolean isDisplayBinary() {
        return (this.isBinary() || this.isOversize()) && !this.isDeleted() && !this.isDir();
    }

    public boolean isDiffable() {
        return this.getToRevision().getDetail("diffRevision") != null && this.getToRevision().getDetail("diffPath") != null;
    }

    private Map<FRXRevision, List<TetrisLine>> getTetrisGrid(FRXRevision currentRev, FRXRevision excludeRev) throws Exception {
        if (Logs.isDebugMode()) {
            Logs.APP_LOG.debug((Object)("getting grid for " + currentRev + " excluding " + excludeRev));
        }
        TetrisGrid grid = new TetrisGrid();
        for (FRXRevision rev : this.frx.getFrxRevisions()) {
            if (rev.equals(excludeRev) && !rev.equals(currentRev)) continue;
            HunkList hunkList = this.getHunkList(rev, currentRev);
            grid.setHunkList(rev, hunkList);
        }
        return grid.getTetrisGrid();
    }

    public void mapInlineComments() {
        Map<FRXRevision, List<TetrisLine>> toTetrisMap;
        Map<FRXRevision, List<TetrisLine>> fromTetrisMap;
        if (this.gutterComments == null) {
            this.gutterComments = new ArrayList<GutterComment>();
        }
        if (this.icCommentMap == null) {
            this.icCommentMap = new HashMap<Comment, InlineCommentDetailDO>();
        }
        if (this.inlineCommentDetails == null) {
            this.inlineCommentDetails = new ArrayList<InlineCommentDetailDO>();
        }
        try {
            if (!this.isDisplayDiff()) {
                return;
            }
            fromTetrisMap = this.getFromFrxRevision() == null || this.getFromFrxRevision().equals(this.getToFrxRevision()) ? null : this.getTetrisGrid(this.getFromFrxRevision(), this.getToFrxRevision());
            toTetrisMap = this.getToFrxRevision() == null ? null : this.getTetrisGrid(this.getToFrxRevision(), this.getFromFrxRevision());
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Error mapping comments. Cannot display comments on review " + this.getReview().getPermaId() + ". Error: " + e2.getMessage()), (Throwable)e2);
            return;
        }
        this.mapGutterComments(toTetrisMap, fromTetrisMap);
        this.mapInlineCommentsFromGutterComments(this.gutterComments);
    }

    private void mapInlineCommentsFromGutterComments(List<GutterComment> gutterComments) {
        if (this.icCommentMap == null) {
            this.icCommentMap = new HashMap<Comment, InlineCommentDetailDO>();
        } else {
            this.icCommentMap.clear();
        }
        if (this.inlineCommentDetails == null) {
            this.inlineCommentDetails = new ArrayList<InlineCommentDetailDO>();
        } else {
            this.inlineCommentDetails.clear();
        }
        for (GutterComment gutterComment : gutterComments) {
            FRXRevision icdoRev;
            FRXRevision gutterCommRev;
            if (gutterComment.getFrxRevision() == null) continue;
            Comment comment = gutterComment.getCommentDetail().getInlineComment().getComment();
            InlineCommentDetailDO icDO = this.icCommentMap.get(comment);
            if (icDO == null) {
                icDO = new InlineCommentDetailDO(this.unreadManager, this.currentUser, this.currentPrincipal, this.currentUserPermissions);
                this.icCommentMap.put(comment, icDO);
            }
            if ((gutterCommRev = gutterComment.getFrxRevision()).equals(this.toFrxRevision)) {
                icdoRev = icDO.getToFrxRevision();
                if (icdoRev == null || gutterComment.getCommentDetail().getFrxRevision().getOrder() >= icdoRev.getOrder()) {
                    icDO.setToICRD(gutterComment.getCommentDetail());
                    icDO.addToLineRange(gutterComment.getLineRange());
                    icDO.setLastTo(gutterComment.getGutterLine());
                }
            } else if (gutterCommRev.equals(this.fromFrxRevision) && ((icdoRev = icDO.getFromFrxRevision()) == null || gutterComment.getCommentDetail().getFrxRevision().getOrder() < icdoRev.getOrder())) {
                icDO.setFromICRD(gutterComment.getCommentDetail());
                icDO.addFromLineRange(gutterComment.getLineRange());
                icDO.setLastFrom(gutterComment.getGutterLine());
            }
            icDO.addVisible(!gutterComment.getLineRange().isEmpty());
        }
        this.inlineCommentDetails.addAll(this.icCommentMap.values());
        Collections.sort(this.inlineCommentDetails, OldestFirstComparator.INSTANCE);
    }

    private void mapGutterComments(Map<FRXRevision, List<TetrisLine>> toTetrisMap, Map<FRXRevision, List<TetrisLine>> fromTetrisMap) {
        if (this.gutterComments == null) {
            this.gutterComments = new ArrayList<GutterComment>();
        } else {
            this.gutterComments.clear();
        }
        for (FRXRevision frxRev : this.getFrxRevisions()) {
            boolean checkToMap = toTetrisMap != null && (!frxRev.equals(this.getFromFrxRevision()) || frxRev.equals(this.getToFrxRevision()));
            boolean checkFromMap = fromTetrisMap != null && (!frxRev.equals(this.getToFrxRevision()) || frxRev.equals(this.getFromFrxRevision()));
            for (InlineCommentRevisionDetail icrd : frxRev.getInlineCommentRevisionDetails()) {
                if (icrd.getInlineComment().isDraft() && !icrd.getInlineComment().getComment().getUser().equals(this.currentUser) || icrd.getInlineComment().isDeleted()) continue;
                IntAVLTreeSet newToLines = new IntAVLTreeSet();
                IntAVLTreeSet newFromLines = new IntAVLTreeSet();
                SortedSet<Integer> commentLines = icrd.getIndividualLines();
                if (!(!this.isPatch() || this.isAnchoredPatch() && !this.isAnchorFailure() || frxRev.equals(this.getToFrxRevision()) || frxRev.equals(this.getFromFrxRevision()))) {
                    this.gutterComments.add(new GutterComment((SortedSet<Integer>)newToLines, this.toFrxRevision, icrd, -1));
                    continue;
                }
                for (Integer line : commentLines) {
                    List<TetrisLine> tetrisLines;
                    if (checkToMap) {
                        tetrisLines = toTetrisMap.get(frxRev);
                        if (tetrisLines == null) continue;
                        if (tetrisLines.isEmpty()) {
                            newToLines.add(line);
                        } else {
                            TetrisLine toTetrisLine = tetrisLines.get(line - 1);
                            if (toTetrisLine.isEqual()) {
                                newToLines.add(toTetrisLine.getStartLine() + 1);
                            }
                        }
                    }
                    if (!checkFromMap || (tetrisLines = fromTetrisMap.get(frxRev)) == null) continue;
                    if (tetrisLines.isEmpty()) {
                        newFromLines.add(line);
                        continue;
                    }
                    TetrisLine fromTetrisLine = tetrisLines.get(line - 1);
                    if (!fromTetrisLine.isEqual()) continue;
                    newFromLines.add(fromTetrisLine.getStartLine() + 1);
                }
                if (checkToMap) {
                    int toGutterLine = commentLines.last();
                    if (toTetrisMap.get(frxRev) != null) {
                        toGutterLine = newToLines.isEmpty() ? toTetrisMap.get(frxRev).get(commentLines.last() - 1).getEndLine() + 1 : (Integer)newToLines.last();
                    }
                    GutterComment toGutterComment = new GutterComment((SortedSet<Integer>)newToLines, this.toFrxRevision, icrd, toGutterLine);
                    this.gutterComments.add(toGutterComment);
                    checkFromMap = false;
                }
                if (!checkFromMap) continue;
                int fromGutterLine = commentLines.last();
                if (fromTetrisMap.get(frxRev) != null) {
                    fromGutterLine = newFromLines.isEmpty() ? fromTetrisMap.get(frxRev).get(commentLines.last() - 1).getEndLine() + 1 : (Integer)newFromLines.last();
                }
                GutterComment fromGutterComment = new GutterComment((SortedSet<Integer>)newFromLines, this.fromFrxRevision, icrd, fromGutterLine);
                this.gutterComments.add(fromGutterComment);
            }
        }
    }

    public InlineCommentDetailDO getIcDOFromComment(Comment comment) {
        return this.icCommentMap == null ? null : this.icCommentMap.get(comment);
    }

    public List<InlineCommentDetailDO> getFromCommentsOnLine(int line) {
        ArrayList<InlineCommentDetailDO> commentDetails = new ArrayList<InlineCommentDetailDO>();
        for (InlineCommentDetailDO rcdo : this.icCommentMap.values()) {
            if (!rcdo.isLastFromLine(line)) continue;
            commentDetails.add(rcdo);
        }
        return commentDetails;
    }

    public List<InlineCommentDetailDO> getToCommentsOnLine(int line) {
        ArrayList<InlineCommentDetailDO> commentDetails = new ArrayList<InlineCommentDetailDO>();
        for (InlineCommentDetailDO rcdo : this.icCommentMap.values()) {
            if (!rcdo.isLastToLine(line)) continue;
            commentDetails.add(rcdo);
        }
        return commentDetails;
    }

    public List<InlineCommentDetailDO> getToCommentsOnLastLine(int line) {
        ArrayList<InlineCommentDetailDO> commentDetails = new ArrayList<InlineCommentDetailDO>();
        for (InlineCommentDetailDO rcdo : this.icCommentMap.values()) {
            if (rcdo.getLastTo() != line) continue;
            commentDetails.add(rcdo);
        }
        return commentDetails;
    }

    public List<InlineCommentDetailDO> getFromCommentsOnLastLine(int line) {
        ArrayList<InlineCommentDetailDO> commentDetails = new ArrayList<InlineCommentDetailDO>();
        for (InlineCommentDetailDO rcdo : this.icCommentMap.values()) {
            if (rcdo.getLastFrom() != line) continue;
            commentDetails.add(rcdo);
        }
        return commentDetails;
    }

    public List<InlineCommentDetailDO> getAllCommentsBetweenLines(int startTo, int startFrom, int endTo, int endFrom) {
        int i2;
        ArrayList<InlineCommentDetailDO> commentDetails = new ArrayList<InlineCommentDetailDO>();
        if (this.anySkippedCommonLines(startTo, endTo)) {
            for (InlineCommentDetailDO rcdo : this.icCommentMap.values()) {
                int lastTo = rcdo.getLastTo();
                if (lastTo != -1 && lastTo > startTo && lastTo < endTo && rcdo.isVisible()) {
                    commentDetails.add(rcdo);
                    continue;
                }
                for (i2 = startTo + 1; i2 < endTo; ++i2) {
                    rcdo.isLastToLine(i2);
                }
                for (i2 = startFrom + 1; i2 < endFrom; ++i2) {
                    rcdo.isLastFromLine(i2);
                }
            }
        }
        if (this.anySkippedCommonLines(startFrom, endFrom)) {
            for (InlineCommentDetailDO rcdo : this.icCommentMap.values()) {
                int lastFrom = rcdo.getLastFrom();
                if (lastFrom != -1 && lastFrom > startFrom && lastFrom < endFrom && rcdo.isVisible()) {
                    commentDetails.add(rcdo);
                    continue;
                }
                for (i2 = startTo + 1; i2 < endTo; ++i2) {
                    rcdo.isLastToLine(i2);
                }
                for (i2 = startFrom + 1; i2 < endFrom; ++i2) {
                    rcdo.isLastFromLine(i2);
                }
            }
        }
        return ImmutableSet.copyOf(commentDetails).asList();
    }

    private boolean anySkippedCommonLines(int start, int end) {
        return end - start > 1;
    }

    private List<InlineCommentDetailDO> getCommentsAfterLine(LinePair.Line to, LinePair.Line from) {
        ArrayList<InlineCommentDetailDO> commentDetails = new ArrayList<InlineCommentDetailDO>();
        for (InlineCommentDetailDO icdo : this.icCommentMap.values()) {
            int lastTo = icdo.getLastTo() - 1;
            int lastFrom = icdo.getLastFrom() - 1;
            if ((lastTo == -1 || to == null || lastTo <= to.getLineNumber()) && (lastFrom == -1 || from == null || lastFrom <= from.getLineNumber() || !icdo.isVisible())) continue;
            commentDetails.add(icdo);
        }
        return commentDetails;
    }

    public List<InlineCommentDetailDO> getInlineCommentDetails() {
        return this.inlineCommentDetails;
    }

    public int getTotalCommentCount() {
        if (this.commentCount == null) {
            this.commentCount = DefaultCommentManager.getInstance().comments(this.frx).where(DiscussionClauses.visibleToAll()).count();
        }
        return this.commentCount;
    }

    public int getTotalUnreadCommentCount() {
        if (this.unreadCommentCount == null) {
            this.unreadCommentCount = this.getReview() == null || !this.isCanCommentReview() ? Integer.valueOf(0) : Integer.valueOf(DefaultCommentManager.getInstance().comments(this.frx).where(DiscussionClauses.and(DiscussionClauses.visibleToAll(), DiscussionClauses.unread(this.currentUser), new DiscussionClause[0])).count());
        }
        return this.unreadCommentCount;
    }

    public List<FRXCommentDO> getFrxComments() {
        if (this.frxComments == null) {
            this.frxComments = new ArrayList<FRXCommentDO>();
            for (FRXComment rcomment : this.frx.getFrxComments()) {
                if (rcomment.isDraft() && !rcomment.getComment().getUser().equals(this.currentUser) || rcomment.isDeleted()) continue;
                FRXCommentDO rcdo = new FRXCommentDO(this.unreadManager, this.currentUser, this.currentPrincipal, this.currentUserPermissions, rcomment);
                this.frxComments.add(rcdo);
            }
        }
        return this.frxComments;
    }

    public List<Comment> getUserVisibleComments() {
        return DefaultCommentManager.getInstance().comments(this.getFrx()).where(DiscussionClauses.visibleTo(this.getCurrentUser())).collect();
    }

    public boolean isHasComments() {
        return !this.icCommentMap.isEmpty() || !this.getFrxComments().isEmpty();
    }

    public boolean getCanProvideAnnotatedFileHistory() {
        return this.source.isAvailable() && this.source.isDirectoryBrowseCapable();
    }

    public RevInfoDO getRevInfoDO() {
        return this.annotatedFileHistory.getRevInfoDO();
    }

    public List<InlineCommentDetailDO> getCommentsAfterLastLine() throws Exception {
        LinePair lastLinePair = this.getLines().getLast().getLinePair();
        return this.getCommentsAfterLine(lastLinePair.getTo(), lastLinePair.getFrom());
    }

    public boolean isNoChange() throws Exception {
        return this.isDisplayDiff() && (this.getLines() == null || this.getLines().isEmpty());
    }

    public DiffDO getDiffDO() {
        if (this.diffDO == null) {
            this.diffDO = new DiffDO(this);
        }
        return this.diffDO;
    }

    public void resetDiff() {
        this.diffDO = null;
        this.lines = null;
        this.wholeFile = null;
    }

    public LinkedList<LineDO> getLines() throws Exception {
        if (this.lines == null) {
            this.lines = this.getDiffDO().mapCommentsToDiff();
        }
        return this.lines;
    }

    public DiffPrinter getDiffPrinter() throws Exception {
        if (!this.allowContentFetch) {
            throw new UnsupportedOperationException("This FRXDO is not allowed to fetch it's content");
        }
        if (this.diffPrinterCache == null && this.isDisplayDiff()) {
            this.diffPrinterCache = this.source.getDiffPrinter(this.contentManager, this.frx, this.getFromRevision(), this.getToRevision(), this.getKeywordOpts(), this.getDiffOption(), this.getDiffContext());
        }
        return this.diffPrinterCache;
    }

    private int getPluginGuttersCount() throws Exception {
        if (this.allowContentFetch) {
            DiffPrinter diffPrinter = this.getDiffPrinter();
            return diffPrinter != null ? diffPrinter.getPluginGutters().size() : 0;
        }
        return DiffPrinter.getPluginGutters(this.getFromRevision(), this.getToRevision(), this.getDiffOption()).size();
    }

    private HunkList getHunkList(FRXRevision from, FRXRevision to) throws Exception {
        CrucibleRevision fromRev = from == null ? null : from.getRevision();
        CrucibleRevision toRev = to == null ? null : to.getRevision();
        return this.source.getHunkList(this.contentManager, this.frx, fromRev, toRev, this.getKeywordOpts(), this.getDiffOption(), this.getDiffContext());
    }

    public void setSideBySide(boolean sideBySide) {
        this.sideBySide = sideBySide;
        this.diffPrinterCache = null;
    }

    public boolean isCanCommentReview() {
        return this.currentUserPermissions.canCommentReview(this.getReview());
    }

    public boolean isCanModifyReview() {
        return this.currentUserPermissions.canModifyReview(this.getReview());
    }

    public List<FRXRevision> getFrxRevisions() {
        return this.frx.getFrxRevisions();
    }

    public int getFrxRevisionsCount() {
        return this.getFrxRevisions().size();
    }

    public boolean isShowBlame() {
        return this.isRepositorySource() && this.isStoreDiffs();
    }

    public Path getTruncatedToRevisionParentPath() {
        Path path = this.getToRevision().getFePath();
        String basename = path.getName();
        return path.getParent().abbreviate(40 - basename.length());
    }

    public Set<String> getAllAuthorNames() {
        HashSet<String> authors = new HashSet<String>();
        for (CrucibleRevision fr : this.getFrx().getCrucibleRevisions()) {
            authors.add(fr.getAuthorName());
        }
        return authors;
    }

    public Set<String> getRevisionStrings() {
        HashSet<String> revisions = new HashSet<String>();
        for (CrucibleRevision fr : this.getFrx().getCrucibleRevisions()) {
            revisions.add(fr.getRevision());
        }
        return revisions;
    }

    public static class OldestFirstComparator
    implements Comparator<InlineCommentDetailDO> {
        public static final OldestFirstComparator INSTANCE = new OldestFirstComparator();

        @Override
        public int compare(InlineCommentDetailDO o1, InlineCommentDetailDO o2) {
            long b2;
            long a2 = o1.getCommentDO().getCreateDate().getTime();
            if (a2 > (b2 = o2.getCommentDO().getCreateDate().getTime())) {
                return 1;
            }
            if (a2 < b2) {
                return -1;
            }
            return 0;
        }
    }

    private class AnnotatedFileHistory {
        private RevInfoDO revInfoDO = null;

        private AnnotatedFileHistory() {
        }

        public RevInfoDO getRevInfoDO() {
            if (this.revInfoDO == null) {
                FileHistoryExplorer fhe = FRXDO.this.source.getFileHistoryExplorer(FRXDO.this.frx.getFileRevision().getRevInfoKey(), null);
                this.revInfoDO = new RevInfoDO(FRXDO.this.getReview(), FRXDO.this.source, FRXDO.this.frx.getFileRevision().getFePath(), FRXDO.this.frx.getFileRevision().getId(), fhe, FRXDO.this.contentManager);
            }
            return this.revInfoDO;
        }
    }
}

