/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.configuration.metrics.MetricsConfig;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.reports.commentsDefects.DefectReportDO;
import com.cenqua.fisheye.config.SpringContext;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CommentReportDO {
    private int w = 200;
    private int h = 100;
    private Project project;
    private Period period = new Period();
    private int maxSegments = 5;

    public CommentReportDO() {
        this.period.lastFortnight();
        this.setProjectByKey("CR");
    }

    public void setH(int h2) {
        this.h = h2;
    }

    public void setW(int w2) {
        this.w = w2;
    }

    public void setFrom(String from) {
        this.period.setFromStr(from);
    }

    public void setTo(String to) {
        this.period.setToStr(to);
    }

    public void setProjectByKey(String projKey) {
        ProjectManager pm = (ProjectManager)SpringContext.getComponent("projectManager");
        this.project = pm.getProjectByKey(projKey);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public Date getTo() {
        return this.period.getTo();
    }

    public String getToStr() {
        return this.period.getToStr();
    }

    public Date getFrom() {
        return this.period.getFrom();
    }

    public String getFromStr() {
        return this.period.getFromStr();
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Project getProject() {
        return this.project;
    }

    public long getTotalComments() {
        return DefaultCommentManager.getInstance().countComments(this.getFrom(), this.getTo(), false, this.project);
    }

    public long getTotalDefects() {
        return DefaultCommentManager.getInstance().countComments(this.getFrom(), this.getTo(), true, this.project);
    }

    public List<DefectReportDO> getDefectReport() {
        return DefaultCommentManager.getInstance().getDefectReports(this.project, this.period, "rank");
    }

    public Map<String, FieldDefinition> getMetrics() {
        MetricsConfig mc = MetricsManager.INSTANCE.getConfig(MetricsManager.INSTANCE.getLatestVersion());
        if (mc != null && mc.isValid()) {
            return mc.getCommentFields();
        }
        return null;
    }

    public int getMaxSegments() {
        return this.maxSegments;
    }

    public void setMaxSegments(int maxSegments) {
        this.maxSegments = maxSegments;
    }
}

