/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CustomFieldList;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.util.CommentComparators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class CommentDO {
    protected Comment comment;
    private final Principal principal;
    private String message;
    private final FecruUser currentUser;
    private final boolean readByCurrentUser;
    private boolean markedLeaveUnreadByCurrentUser;
    private final UnreadManager unreadManager;
    private final CurrentUserPermissions currentUserPermissions;
    private List<Comment> visibleChildren = null;
    private Integer commentCount = null;

    public CommentDO(UnreadManager unreadManager, Comment comment, FecruUser user, Principal principal, CurrentUserPermissions currentUserPermissions) {
        this.comment = comment;
        this.principal = principal;
        this.currentUserPermissions = currentUserPermissions;
        this.message = comment.getMessage();
        this.currentUser = user;
        this.readByCurrentUser = !currentUserPermissions.canCommentReview(comment.getReview()) || comment.isRead(this.currentUser);
        this.unreadManager = unreadManager;
        this.markedLeaveUnreadByCurrentUser = unreadManager.isMarkedLeaveUnread(this.currentUser, comment);
    }

    public String getLinkedIssue() {
        return this.comment.getJiraIssueKey();
    }

    public boolean isDraft() {
        return this.comment.isDraft();
    }

    public boolean isDeleted() {
        return this.comment.isDeleted();
    }

    public boolean isVisibleToAll() {
        return this.comment.isVisibleToAll();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Comment getComment() {
        return this.comment;
    }

    public Review getReview() {
        return this.comment.getReview();
    }

    public Integer getId() {
        return this.comment.getId();
    }

    public FecruUser getUser() {
        return this.comment.getUser();
    }

    public Date getCreateDate() {
        return this.comment.getCreateDate();
    }

    public boolean getHasVisibleChildren() {
        return !this.getVisibleChildren().isEmpty();
    }

    public List<Comment> getVisibleChildren() {
        if (this.visibleChildren == null) {
            this.visibleChildren = new LinkedList<Comment>();
            for (Comment reply : this.comment.getComments()) {
                if (!reply.isVisible(this.currentUser)) continue;
                this.visibleChildren.add(reply);
            }
            Collections.sort(this.visibleChildren, CommentComparators.oldestFirst);
        }
        return this.visibleChildren;
    }

    public List<CommentDO> getCommentThread() {
        List<CommentDO> thread = this.getCommentDescendants();
        thread.add(0, this);
        return thread;
    }

    public List<CommentDO> getCommentDescendants() {
        ArrayList<CommentDO> thread = new ArrayList<CommentDO>();
        TreeSet<Comment> children = new TreeSet<Comment>(CommentComparators.oldestFirst);
        children.addAll(this.getVisibleChildren());
        for (Comment c2 : children) {
            CommentDO commentDO = new CommentDO(this.unreadManager, c2, this.currentUser, this.principal, this.currentUserPermissions);
            thread.addAll(commentDO.getCommentThread());
        }
        return thread;
    }

    public int getThreadDepth() {
        int depth = 0;
        Comment c2 = this.getComment();
        while ((c2 = c2.getReplyToComment()) != null) {
            ++depth;
        }
        return depth;
    }

    public int getCount() {
        if (this.commentCount == null) {
            this.commentCount = DefaultCommentManager.getInstance().comments(this.comment).where(DiscussionClauses.visibleToAll()).count();
        }
        return this.commentCount;
    }

    public boolean isNegative() {
        return this.comment.isNegative();
    }

    public boolean isPositive() {
        return this.comment.isPositive();
    }

    public boolean isDefectRaised() {
        return this.comment.isDefectRaised();
    }

    public String getDefectStatus() {
        return this.comment.isDefectApproved() ? "approved" : "pending approval";
    }

    public boolean isReadByCurrentUser() {
        return this.readByCurrentUser;
    }

    public boolean isMarkedLeaveUnreadByCurrentUser() {
        return this.markedLeaveUnreadByCurrentUser;
    }

    public boolean isReadStatusModifiable() {
        boolean commentCreator = this.comment.getUser().equals(this.currentUser);
        boolean canModify = this.currentUserPermissions.canCommentReview(this.getReview());
        return !commentCreator && canModify;
    }

    public String getReadStatusText() {
        if (this.isReadByCurrentUser()) {
            return "read";
        }
        if (this.isMarkedLeaveUnreadByCurrentUser()) {
            return "leaveUnread";
        }
        return "unread";
    }

    public CommentDO getReplyTo() {
        Comment replyTo = this.comment.getReplyToComment();
        return replyTo == null ? null : new CommentDO(this.unreadManager, replyTo, this.currentUser, this.principal, this.currentUserPermissions);
    }

    public boolean isJiraLinkButtonVisibleToCurrentUser() {
        for (ReviewParticipant p2 : this.getReview().getParticipants()) {
            if (!p2.getUser().equals(this.currentUser)) continue;
            return true;
        }
        return false;
    }

    public String getPermaId() {
        return this.getComment().getPermaId();
    }

    public CustomFieldList getMetrics() {
        return this.getComment();
    }
}

