/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.rep.RepositoryHandle;
import javax.annotation.Nullable;

public final class SourceUtils {
    public static boolean isGit(Source source) {
        return SourceUtils.getRepositoryType(source) == ScmType.GIT;
    }

    public static String getSourceType(Source source) {
        ScmType type = SourceUtils.getRepositoryType(source);
        return type != null ? type.getId() : "other";
    }

    @Nullable
    private static ScmType getRepositoryType(Source source) {
        RepositoryHandle handle;
        if (source instanceof RepositorySource && (handle = ((RepositorySource)source).getRepositoryHandle()) != null) {
            return handle.getCfg().getRepositoryType();
        }
        return null;
    }
}

