/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.crucible.event.ReviewItemRevisionDataChangedEventImpl;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.crucible.spi.services.ReviewContentTooLargeException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.discussion.FRXDiscussionBrowser;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.FileRevisionToReviewMapper;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.util.Pair;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ReviewCreationHelper {
    private final Review review;
    private final Source source;
    private final List<CrucibleRevision> addedItems = new LinkedList<CrucibleRevision>();
    private final List<CrucibleRevision> removedItems = new LinkedList<CrucibleRevision>();
    private final List<CrucibleRevision> unremovedItems = new LinkedList<CrucibleRevision>();
    private final List<String> messages = new LinkedList<String>();
    private ContentManager contentManager;
    private final NotificationManager notificationManager;
    private final SPIUtils spiUtils;
    private final CommentManager commentManager;
    private final EventPublisher eventPublisher;

    public ReviewCreationHelper(Source source, Review review, ContentManager contentManager, NotificationManager notificationManager, SPIUtils spiUtils, CommentManager commentManager, EventPublisher eventPublisher) throws SourceException {
        this.source = source;
        this.review = review;
        this.contentManager = contentManager;
        this.notificationManager = notificationManager;
        this.spiUtils = spiUtils;
        this.commentManager = commentManager;
        this.eventPublisher = eventPublisher;
        if (!source.isAvailable()) {
            throw source.getException();
        }
    }

    public List<CrucibleRevision> getAddedItems() {
        return this.addedItems;
    }

    public List<CrucibleRevision> getUnremovedItems() {
        return this.unremovedItems;
    }

    public List<CrucibleRevision> getRemovedItems() {
        return this.removedItems;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    private void visitAncestors(RevInfoKey fr, final AncestorsVisitor v2, final FileRevisionToReviewMapper finder) throws FileRevisionException {
        if (!this.source.isAvailable()) {
            throw new FileRevisionException(this.source.getReason());
        }
        this.source.searchAncestors(fr, new Predicate<RevInfoKey>(){

            public boolean apply(RevInfoKey revKey) {
                if (v2.shouldCheckReviews()) {
                    Collection<Review> reviews = finder.findReviewsForRevision(revKey);
                    if (reviews.isEmpty()) {
                        return !v2.visitRevision(revKey);
                    }
                    return !v2.visitReviewedRevision(revKey, reviews);
                }
                return !v2.visitRevision(revKey);
            }
        });
    }

    public Map<RevInfoKey, RevInfoKey> firstReviewedDiffAncestors(List<RevInfoKey> keys) throws FileRevisionException {
        HashMap<RevInfoKey, RevInfoKey> keyMap = new HashMap<RevInfoKey, RevInfoKey>();
        if (keys == null || keys.isEmpty()) {
            return keyMap;
        }
        FileRevisionToReviewMapper finder = new FileRevisionToReviewMapper(this.source);
        finder.seedKeys(keys);
        class Guesser
        implements AncestorsVisitor {
            RevInfoKey first;
            RevInfoKey guess;

            Guesser() {
            }

            @Override
            public boolean shouldCheckReviews() {
                return true;
            }

            @Override
            public boolean visitRevision(RevInfoKey fr) {
                if (this.first == null) {
                    this.first = fr;
                }
                return true;
            }

            @Override
            public boolean visitReviewedRevision(RevInfoKey fr, Collection<Review> reviews) {
                if (this.first == null) {
                    this.first = fr;
                }
                this.guess = fr;
                return false;
            }

            @Override
            public void reset() {
                this.first = null;
                this.guess = null;
            }
        }
        Guesser v2 = new Guesser();
        for (RevInfoKey key : keys) {
            v2.reset();
            this.visitAncestors(key, v2, finder);
            RevInfoKey first = v2.guess != null ? v2.guess : v2.first;
            keyMap.put(key, first);
        }
        return keyMap;
    }

    public Map<RevInfoKey, RevInfoKey> firstBranchPointDiffAncestors(List<RevInfoKey> keys) throws FileRevisionException {
        HashMap<RevInfoKey, RevInfoKey> keyMap = new HashMap<RevInfoKey, RevInfoKey>();
        if (keys == null || keys.isEmpty()) {
            return keyMap;
        }
        FileRevisionToReviewMapper finder = new FileRevisionToReviewMapper(this.source);
        finder.seedKeys(keys);
        class Guesser
        implements AncestorsVisitor {
            RevInfoKey first;
            RevInfoKey guess;
            String firstBranch;
            RevisionCache revCache;

            Guesser() {
            }

            @Override
            public boolean shouldCheckReviews() {
                return false;
            }

            @Override
            public boolean visitRevision(RevInfoKey fr) {
                if (this.first == null) {
                    this.first = fr;
                }
                if (!this.getBranch(fr).equals(this.getFirstBranch())) {
                    this.guess = fr;
                    return false;
                }
                return true;
            }

            @Override
            public boolean visitReviewedRevision(RevInfoKey fr, Collection<Review> reviews) {
                throw new IllegalStateException("firstBranchPointDiffAncestors should not check revisions for reviews");
            }

            @Override
            public void reset() {
                this.first = null;
                this.guess = null;
                this.firstBranch = null;
            }

            private String getFirstBranch() throws DbException {
                if (this.firstBranch == null) {
                    this.firstBranch = this.getBranch(this.first);
                }
                return this.firstBranch;
            }

            private String getBranch(RevInfoKey key) throws DbException {
                return this.getRevCache().getFileRevision(key).getBranch();
            }

            private RevisionCache getRevCache() {
                if (this.revCache == null) {
                    this.revCache = ((RepositorySource)ReviewCreationHelper.this.source).getRepoEngine().getRevisionCache();
                }
                return this.revCache;
            }
        }
        Guesser v2 = new Guesser();
        for (RevInfoKey key : keys) {
            v2.reset();
            this.visitAncestors(key, v2, finder);
            keyMap.put(key, v2.guess);
        }
        return keyMap;
    }

    private Map<RevInfoKey, RevInfoKey> firstDiffAncestors(List<RevInfoKey> keys) throws FileRevisionException {
        HashMap<RevInfoKey, RevInfoKey> keyMap = new HashMap<RevInfoKey, RevInfoKey>();
        if (keys == null || keys.isEmpty()) {
            return keyMap;
        }
        FileRevisionToReviewMapper finder = new FileRevisionToReviewMapper(this.source);
        finder.seedKeys(keys);
        class Guesser
        implements AncestorsVisitor {
            RevInfoKey first;

            Guesser() {
            }

            @Override
            public boolean shouldCheckReviews() {
                return false;
            }

            @Override
            public boolean visitRevision(RevInfoKey fr) {
                this.first = fr;
                return false;
            }

            @Override
            public boolean visitReviewedRevision(RevInfoKey fr, Collection<Review> reviews) {
                throw new IllegalStateException("firstDiffAncestors should not check revisions for reviews");
            }

            @Override
            public void reset() {
                this.first = null;
            }
        }
        Guesser v2 = new Guesser();
        for (RevInfoKey key : keys) {
            v2.reset();
            this.visitAncestors(key, v2, finder);
            keyMap.put(key, v2.first);
        }
        return keyMap;
    }

    public boolean removeRevisions(FecruUser currentUser, Collection<CrucibleRevision> revisions, boolean removeDanglingFrom) {
        for (CrucibleRevision revision : revisions) {
            if (this.removeRevision(currentUser, revision, removeDanglingFrom)) continue;
            this.unremovedItems.add(revision);
        }
        return this.unremovedItems.isEmpty();
    }

    public boolean removeFrx(FecruUser currentUser, Integer frxId) {
        FileRevisionExtraInfo frx = FRXManager.getById(frxId);
        CrucibleRevision fr = frx.getFileRevision();
        List<CrucibleRevision> revisions = frx.getCrucibleRevisions();
        ReviewItemRevisionDataChangedEventImpl event = this.createReviewItemRevisionDataRemovedEvent(frx.getFrxRevisions(), currentUser);
        boolean removed = this.review.removeFRX(frx);
        if (!removed) {
            this.messages.add("Could not remove '" + frx.getFileRevision().getPath() + "'. It has already been removed or it has comments.");
            return false;
        }
        LogManager.logReviewFrxRemoved(this.review, currentUser, frx, revisions);
        this.fireReviewItemRevisionDataChangedEvent(event);
        this.removedItems.add(fr);
        return true;
    }

    public void removeAllRevisions(FecruUser currentUser) {
        ArrayList<FileRevisionExtraInfo> frxs = new ArrayList<FileRevisionExtraInfo>(this.review.getFrxs());
        ReviewItemRevisionDataChangedEventImpl event = new ReviewItemRevisionDataChangedEventImpl(this.review.getPermId(), this.spiUtils.createUserData(currentUser), this.spiUtils);
        for (FileRevisionExtraInfo frx : frxs) {
            CrucibleRevision fr = frx.getFileRevision();
            ArrayList<CrucibleRevision> frs = new ArrayList<CrucibleRevision>();
            for (FRXRevision frxRev : frx.getFrxRevisions()) {
                frs.add(frxRev.getRevision());
            }
            this.removedItems.addAll(frs);
            this.review.removeFRX(frx);
            LogManager.logReviewFrxRemoved(this.review, currentUser, frx, frs);
            event.addRemovedRevisions(frx.getFrxRevisions());
        }
        this.fireReviewItemRevisionDataChangedEvent(event);
        frxs.clear();
    }

    private boolean removeRevision(FecruUser currentUser, CrucibleRevision rev, boolean removeDiff) {
        if (rev != null) {
            FRXDiscussionBrowser comments;
            FileRevisionExtraInfo frx = this.review.getFRX(rev);
            if (frx == null) {
                this.messages.add(String.format("Could not remove '%s' %s. It has already been removed", rev.getFePath(), rev.getRevision()));
                return false;
            }
            FRXRevision frxRevision = frx.getFRXRevision(rev);
            if (removeDiff && frxRevision.getOrder() == 1 && frx.getShowAsDiff().booleanValue()) {
                FRXRevision fromFrxRev = frx.getFromFRXRevision();
                CrucibleRevision fromRev = fromFrxRev.getRevision();
                if (frx.getFrxRevisions().size() == 2) {
                    this.removeRevision(currentUser, rev, false);
                }
                frxRevision = fromFrxRev;
                rev = fromRev;
            }
            boolean changeDiffMode = frx.getFrxRevisions().size() == 2;
            ReviewItemRevisionDataChangedEventImpl event = this.createReviewItemRevisionDataRemovedEvent(Collections.singleton(frxRevision), currentUser);
            boolean canDeleteFrx = true;
            if (frx.getFrxRevisions().size() == 1 && (comments = this.commentManager.comments(frx)).where(DiscussionClauses.visibleToAll()).count() > 0) {
                canDeleteFrx = false;
            }
            if (canDeleteFrx && this.review.removeRevision(rev)) {
                LogManager.logReviewRevisionRemoved(this.review, currentUser, frxRevision, frx);
                if (frx.getCrucibleRevisions().size() == 0) {
                    LogManager.logReviewFrxRemoved(this.review, currentUser, frx, Collections.singletonList(rev));
                }
                this.fireReviewItemRevisionDataChangedEvent(event);
                this.removedItems.add(rev);
                if (changeDiffMode) {
                    frx.setShowAsDiff(false);
                }
                return true;
            }
            this.messages.add("Could not remove '" + rev.getPath() + "' " + rev.getRevision() + ". It has already been removed or it has comments.");
            return false;
        }
        return true;
    }

    private ReviewItemRevisionDataChangedEventImpl createReviewItemRevisionDataRemovedEvent(Collection<FRXRevision> frxRevs, FecruUser currentUser) {
        ReviewItemRevisionDataChangedEventImpl event = new ReviewItemRevisionDataChangedEventImpl(this.review.getPermId(), this.spiUtils.createUserData(currentUser), this.spiUtils);
        event.addRemovedRevisions(frxRevs);
        return event;
    }

    private void addRevision(FecruUser currentUser, FileRevisionExtraInfo existingFrx, CrucibleRevision min, CrucibleRevision max, Review.AttachMethod attachMethod) throws SourceException {
        FileRevisionExtraInfo frx;
        boolean newlyAddedFrx = existingFrx == null;
        boolean minAdded = false;
        boolean maxAdded = false;
        FRXRevisionManager frxRevManager = new FRXRevisionManager();
        if (newlyAddedFrx) {
            frx = this.review.addRevision(max);
            maxAdded = true;
        } else {
            frx = existingFrx;
        }
        Logs.APP_LOG.debug((Object)(" newlyAddedFrx: " + newlyAddedFrx + " attachMethod: " + (Object)((Object)attachMethod) + " source:  " + this.source + " max: " + max + " min: " + min + " frx: " + frx));
        boolean minEqualsMax = min.getId().equals(max.getId());
        if (attachMethod == Review.AttachMethod.SINGLE_REVISION) {
            maxAdded = this.addSingleCrucibleRevision(max, frxRevManager, frx, Optional.empty());
        } else if (attachMethod == Review.AttachMethod.ITERATION || attachMethod == Review.AttachMethod.DIFF_TO_PREVIOUS || attachMethod == Review.AttachMethod.SPECIFIC_DIFF) {
            int maxInsertIndex = this.source.getInsertIndex(frx.getCrucibleRevisions(), max, null);
            Logs.APP_LOG.debug((Object)(" maxInsertIndex: " + maxInsertIndex));
            if ((newlyAddedFrx || attachMethod == Review.AttachMethod.SPECIFIC_DIFF || maxInsertIndex == 0 || max.equals(frx.getFromRevision()) && Boolean.TRUE.equals(frx.getShowAsDiff())) && !minEqualsMax) {
                minAdded = this.addSingleCrucibleRevision(min, frxRevManager, frx, Optional.empty());
                maxInsertIndex = this.source.getInsertIndex(frx.getCrucibleRevisions(), max, null);
            }
            if ((newlyAddedFrx || maxInsertIndex == -1) && minEqualsMax) {
                maxAdded = frx.getShowAsDiff();
                frx.setShowAsDiff(false);
            }
            if (frxRevManager.createFRXRevisionAndUnread(frx, maxInsertIndex, max) != null) {
                maxAdded = true;
            }
        } else if (attachMethod == Review.AttachMethod.WHOLE_FILE || minEqualsMax) {
            this.addSingleCrucibleRevision(max, frxRevManager, frx, Optional.of(false));
            maxAdded = true;
        } else if (newlyAddedFrx) {
            frxRevManager.createFRXRevisionAndUnread(frx, 0, min);
            frxRevManager.createFRXRevisionAndUnread(frx, 1, max);
            minAdded = true;
            maxAdded = true;
        } else {
            List<CrucibleRevision> crucibleRevisions = frx.getCrucibleRevisions();
            if (!crucibleRevisions.contains(min)) {
                minAdded = this.addSingleCrucibleRevision(min, frxRevManager, frx, Optional.empty());
            }
            if (!crucibleRevisions.contains(max)) {
                maxAdded = this.addSingleCrucibleRevision(max, frxRevManager, frx, Optional.empty());
            }
        }
        ArrayList<FRXRevision> frxRevs = new ArrayList<FRXRevision>();
        if (maxAdded) {
            this.addedItems.add(max);
            this.notify(max, frx, currentUser, this.notificationManager);
            frxRevs.add(frx.getFRXRevision(max));
        }
        if (minAdded) {
            this.addedItems.add(min);
            if (!maxAdded) {
                this.notify(min, frx, currentUser, this.notificationManager);
            }
            if (!minEqualsMax) {
                FRXRevision frxRevision = frx.getFRXRevision(min);
                frxRevs.add(frxRevision);
            }
        }
        if (newlyAddedFrx) {
            LogManager.logReviewFrxAdded(this.review, currentUser, frx);
        } else {
            if (!maxAdded) {
                Logs.APP_LOG.debug((Object)(max.getPath() + " " + max.getRevision() + " is already included in this review."));
            } else {
                LogManager.logReviewRevisionAdded(this.review, currentUser, frx.getFRXRevision(max));
            }
            if (!minEqualsMax) {
                if (!minAdded) {
                    Logs.APP_LOG.debug((Object)(min.getPath() + " " + min.getRevision() + " is already included in this review."));
                } else {
                    LogManager.logReviewRevisionAdded(this.review, currentUser, frx.getFRXRevision(min));
                }
            }
        }
        if (!frxRevs.isEmpty()) {
            this.fireReviewItemRevisionDataAddedEvent(frxRevs, currentUser);
        }
    }

    private boolean addSingleCrucibleRevision(CrucibleRevision revision, FRXRevisionManager frxRevManager, FileRevisionExtraInfo frx, Optional<Boolean> showAsDiff) throws SourceException {
        showAsDiff.ifPresent(value -> frx.setShowAsDiff((Boolean)value));
        int insertIndex = this.source.getInsertIndex(frx.getCrucibleRevisions(), revision, null);
        return frxRevManager.createFRXRevisionAndUnread(frx, insertIndex, revision) != null;
    }

    private void notify(CrucibleRevision fr, FileRevisionExtraInfo frx, FecruUser user, NotificationManager notificationManager) {
        FRXRevision frxRev = frx.getFRXRevision(fr);
        notificationManager.noteFRXRevisionAdded(this.review, frxRev, user);
    }

    private void fireReviewItemRevisionDataAddedEvent(List<FRXRevision> frxRevs, FecruUser currentUser) {
        ReviewItemRevisionDataChangedEventImpl event = new ReviewItemRevisionDataChangedEventImpl(this.review.getPermId(), this.spiUtils.createUserData(currentUser), this.spiUtils);
        event.addAddedRevisions(frxRevs);
        this.fireReviewItemRevisionDataChangedEvent(event);
    }

    private void fireReviewItemRevisionDataChangedEvent(ReviewItemRevisionDataChangedEventImpl event) {
        this.eventPublisher.publish((Object)event);
    }

    public void addRevisions(FecruUser currentUser, Collection<CrucibleRevision> revisions, Review.AttachMethod attachMethod, String fromRevisionStr, MetadataFilter metadataFilter) throws SourceException, ReviewContentTooLargeException {
        if (attachMethod == null) {
            attachMethod = Review.AttachMethod.ITERATION;
        }
        if (StringUtils.isEmpty((String)this.review.getDefaultSource())) {
            this.review.setDefaultSource(this.source.getName());
        }
        this.review.checkRoomForMoreContentExists();
        Collection<CrucibleRevision> textualRevisions = metadataFilter.filter(this.contentManager, this.source, revisions);
        List<Pair<Path, List<CrucibleRevision>>> list = this.source.groupFileRevisions(textualRevisions);
        AddRevisionsCalculator addRevisionsCalculator = new AddRevisionsCalculator(currentUser, textualRevisions, attachMethod, fromRevisionStr, list);
        addRevisionsCalculator.calculate(new RevisionsCalculatorOperator(addRevisionsCalculator){
            final List<RevInfoKey> firstDiffsToLoad;
            final List<RevInfoKey> firstReviewedDiffsToLoad;
            final List<RevInfoKey> firstBranchPointDiffsToLoad;
            {
                this.firstDiffsToLoad = new ArrayList<RevInfoKey>();
                this.firstReviewedDiffsToLoad = new ArrayList<RevInfoKey>();
                this.firstBranchPointDiffsToLoad = new ArrayList<RevInfoKey>();
            }

            @Override
            public void cleanUp() throws SourceException {
                this.calculator.firstDiffsToLoad = this.firstDiffsToLoad;
                this.calculator.firstReviewedDiffsToLoad = this.firstReviewedDiffsToLoad;
                this.calculator.firstBranchPointDiffsToLoad = this.firstBranchPointDiffsToLoad;
            }

            @Override
            void ifNotSingleRevision() {
                RevInfoKey minRik = this.min.getRevInfoKey();
                this.firstDiffsToLoad.add(minRik);
            }

            @Override
            void ifReviewedDiff() {
                this.firstReviewedDiffsToLoad.add(this.max.getRevInfoKey());
            }

            @Override
            void ifLastBranchPointDiff() {
                this.firstBranchPointDiffsToLoad.add(this.max.getRevInfoKey());
            }

            @Override
            void ifSpecificDiff() {
            }

            @Override
            void loopCleanup() {
            }
        });
        addRevisionsCalculator.calculate(new RevisionsCalculatorOperator(addRevisionsCalculator){
            final Set<RevInfoKey> revInfoKeysToLoad;
            {
                this.revInfoKeysToLoad = Sets.newHashSet();
            }

            @Override
            public void cleanUp() {
                this.calculator.keyToRevisionMap = ReviewCreationHelper.this.contentManager.getCrucibleRevisions(ReviewCreationHelper.this.source, this.revInfoKeysToLoad, false);
            }

            @Override
            void ifNotSingleRevision() throws FileRevisionException {
                RevInfoKey minRik = this.min.getRevInfoKey();
                RevInfoKey rik = this.calculator.getFirstDiffAncestorsMap().get(minRik);
                this.calculator.getFirstDiffAncestorsMap().put(minRik, rik);
                if (rik != null) {
                    this.revInfoKeysToLoad.add(rik);
                }
            }

            @Override
            void ifReviewedDiff() throws FileRevisionException {
                RevInfoKey maxRik = this.max.getRevInfoKey();
                RevInfoKey firstReviewedRik = this.calculator.getFirstReviewedDiffAncestorsMap().get(maxRik);
                if (firstReviewedRik != null) {
                    this.revInfoKeysToLoad.add(firstReviewedRik);
                    this.calculator.getFirstReviewedDiffAncestorsMap().put(maxRik, firstReviewedRik);
                }
            }

            @Override
            void ifSpecificDiff() {
                RevInfoKey specifiedRevInfoKey = new RevInfoKey(this.path, this.calculator.fromRevisionStr);
                this.revInfoKeysToLoad.add(specifiedRevInfoKey);
            }

            @Override
            void ifLastBranchPointDiff() throws FileRevisionException {
                RevInfoKey maxRik = this.max.getRevInfoKey();
                RevInfoKey firstBranchPointRik = this.calculator.getFirstBranchPointDiffAncestorsMap().get(maxRik);
                if (firstBranchPointRik != null) {
                    this.revInfoKeysToLoad.add(firstBranchPointRik);
                    this.calculator.getFirstBranchPointDiffAncestorsMap().put(maxRik, firstBranchPointRik);
                }
            }

            @Override
            void loopCleanup() {
            }
        });
        addRevisionsCalculator.calculate(new RevisionsCalculatorOperator(addRevisionsCalculator){

            @Override
            public void cleanUp() {
            }

            @Override
            void ifNotSingleRevision() throws FileRevisionException {
                RevInfoKey rikMin = this.calculator.getFirstDiffAncestorsMap().get(this.min.getRevInfoKey());
                if (rikMin != null) {
                    this.min = this.calculator.keyToRevisionMap.get(rikMin);
                }
            }

            @Override
            void ifReviewedDiff() throws FileRevisionException {
                CrucibleRevision lastReviewed = this.calculator.keyToRevisionMap.get(this.calculator.getFirstReviewedDiffAncestorsMap().get(this.max.getRevInfoKey()));
                if (lastReviewed != null) {
                    this.min = lastReviewed;
                }
            }

            @Override
            void ifSpecificDiff() {
                RevInfoKey specifiedRevInfoKey = new RevInfoKey(this.path, this.calculator.fromRevisionStr);
                CrucibleRevision specified = this.calculator.keyToRevisionMap.get(specifiedRevInfoKey);
                if (specified != null) {
                    if (specified.getCommitDate() == null || this.min.getCommitDate() == null || this.max.getCommitDate() == null || specified.getCommitDate().before(this.max.getCommitDate())) {
                        this.min = specified;
                    } else {
                        this.max = specified;
                    }
                }
            }

            @Override
            void ifLastBranchPointDiff() throws FileRevisionException {
                CrucibleRevision lastBranchPoint = this.calculator.keyToRevisionMap.get(this.calculator.getFirstBranchPointDiffAncestorsMap().get(this.max.getRevInfoKey()));
                this.min = lastBranchPoint != null ? lastBranchPoint : this.max;
            }

            @Override
            void loopCleanup() throws SourceException {
                FileRevisionExtraInfo existing = null;
                for (FileRevisionExtraInfo frx : ReviewCreationHelper.this.review.getFrxs()) {
                    if (!frx.getFileRevision().getSourceName().equals(this.max.getSourceName())) continue;
                    boolean isWholeFile = this.calculator.attachMethod.equals((Object)Review.AttachMethod.WHOLE_FILE);
                    boolean isOnAncestryLine = ReviewCreationHelper.this.source.isOnAncestryLine(frx.getCrucibleRevisions(), isWholeFile ? null : this.min, this.max);
                    if (!isOnAncestryLine) continue;
                    existing = frx;
                    break;
                }
                ReviewCreationHelper.this.addRevision(this.calculator.currentUser, existing, this.min, this.max, this.calculator.attachMethod);
            }
        });
    }

    private static abstract class RevisionsCalculatorOperator {
        protected AddRevisionsCalculator calculator;
        protected CrucibleRevision min;
        protected CrucibleRevision max;
        protected Path path;

        protected RevisionsCalculatorOperator(AddRevisionsCalculator calculator) {
            this.calculator = calculator;
        }

        abstract void cleanUp() throws SourceException;

        abstract void ifNotSingleRevision() throws SourceException;

        abstract void ifReviewedDiff() throws SourceException;

        abstract void ifLastBranchPointDiff() throws SourceException;

        void ifSpecificDiff() {
        }

        void loopCleanup() throws SourceException {
        }

        void doLoop(Path path, CrucibleRevision min, CrucibleRevision max) throws SourceException {
            this.min = min;
            this.max = max;
            this.path = path;
            if (this.calculator.attachMethod != Review.AttachMethod.SINGLE_REVISION && this.calculator.attachMethod != Review.AttachMethod.WHOLE_FILE) {
                this.ifNotSingleRevision();
                if (this.calculator.attachMethod == Review.AttachMethod.REVIEWED_DIFF) {
                    this.ifReviewedDiff();
                } else if (this.calculator.attachMethod == Review.AttachMethod.SPECIFIC_DIFF && !Strings.isNullOrEmpty((String)this.calculator.fromRevisionStr)) {
                    this.ifSpecificDiff();
                } else if (this.calculator.attachMethod == Review.AttachMethod.LAST_BRANCH_POINT) {
                    this.ifLastBranchPointDiff();
                }
            }
            this.loopCleanup();
        }
    }

    private class AddRevisionsCalculator {
        final FecruUser currentUser;
        final Collection<CrucibleRevision> revisions;
        final Review.AttachMethod attachMethod;
        final String fromRevisionStr;
        final List<Pair<Path, List<CrucibleRevision>>> list;
        private Map<RevInfoKey, RevInfoKey> firstDiffAncestorsMap;
        private Map<RevInfoKey, RevInfoKey> firstReviewedDiffAncestorsMap;
        private Map<RevInfoKey, RevInfoKey> firstBranchPointDiffAncestorsMap;
        Map<RevInfoKey, CrucibleRevision> keyToRevisionMap;
        public List<RevInfoKey> firstDiffsToLoad;
        public List<RevInfoKey> firstReviewedDiffsToLoad;
        public List<RevInfoKey> firstBranchPointDiffsToLoad;

        private AddRevisionsCalculator(FecruUser currentUser, Collection<CrucibleRevision> revisions, Review.AttachMethod attachMethod, String fromRevisionStr, List<Pair<Path, List<CrucibleRevision>>> list) {
            this.currentUser = currentUser;
            this.revisions = revisions;
            this.attachMethod = attachMethod;
            this.fromRevisionStr = fromRevisionStr;
            this.list = list;
        }

        void calculate(RevisionsCalculatorOperator operator) throws SourceException {
            for (Pair<Path, List<CrucibleRevision>> pair : this.list) {
                List<CrucibleRevision> crucibleRevisions = pair.getSecond();
                Path path = pair.getFirst();
                CrucibleRevision min = crucibleRevisions.get(0);
                CrucibleRevision max = crucibleRevisions.get(crucibleRevisions.size() - 1);
                operator.doLoop(path, min, max);
            }
            operator.cleanUp();
        }

        public Map<RevInfoKey, RevInfoKey> getFirstDiffAncestorsMap() throws FileRevisionException {
            if (this.firstDiffAncestorsMap == null) {
                this.firstDiffAncestorsMap = ReviewCreationHelper.this.firstDiffAncestors(this.firstDiffsToLoad);
            }
            return this.firstDiffAncestorsMap;
        }

        public Map<RevInfoKey, RevInfoKey> getFirstReviewedDiffAncestorsMap() throws FileRevisionException {
            if (this.firstReviewedDiffAncestorsMap == null) {
                this.firstReviewedDiffAncestorsMap = ReviewCreationHelper.this.firstReviewedDiffAncestors(this.firstReviewedDiffsToLoad);
            }
            return this.firstReviewedDiffAncestorsMap;
        }

        public Map<RevInfoKey, RevInfoKey> getFirstBranchPointDiffAncestorsMap() throws FileRevisionException {
            if (this.firstBranchPointDiffAncestorsMap == null) {
                this.firstBranchPointDiffAncestorsMap = ReviewCreationHelper.this.firstBranchPointDiffAncestors(this.firstBranchPointDiffsToLoad);
            }
            return this.firstBranchPointDiffAncestorsMap;
        }
    }

    private static interface AncestorsVisitor {
        public boolean shouldCheckReviews();

        public boolean visitRevision(RevInfoKey var1);

        public boolean visitReviewedRevision(RevInfoKey var1, Collection<Review> var2);

        public void reset();
    }

    public static enum MetadataFilter {
        NONE{

            @Override
            public Collection<CrucibleRevision> filter(ContentManager contentManager, Source source, Collection<CrucibleRevision> revisions) {
                return revisions;
            }
        }
        ,
        ALL{

            @Override
            public Collection<CrucibleRevision> filter(ContentManager contentManager, Source source, Collection<CrucibleRevision> revisions) {
                if (source instanceof RepositorySource) {
                    LinkedList<CrucibleRevision> filteredRevisions = new LinkedList<CrucibleRevision>(revisions);
                    Iterator iterator = filteredRevisions.iterator();
                    while (iterator.hasNext()) {
                        CrucibleRevision next = (CrucibleRevision)iterator.next();
                        contentManager.checkRevisionDetailsSynchronously(next, source);
                        if (!next.isMetadataOnlyChange()) continue;
                        if (next.getStoredPath() != null) {
                            Logs.APP_LOG.debug((Object)("Excluding " + next.getRevInfoKey() + " since its a metadata only change"));
                        }
                        iterator.remove();
                    }
                    return filteredRevisions;
                }
                return revisions;
            }
        }
        ,
        ALL_AND_FAIL{

            @Override
            public Collection<CrucibleRevision> filter(ContentManager contentManager, Source source, Collection<CrucibleRevision> revisions) {
                Collection<CrucibleRevision> filteredRevisions = ALL.filter(contentManager, source, revisions);
                if (filteredRevisions.size() == 0 && revisions.size() != 0) {
                    throw new IllegalArgumentException("At least one revision being added must be a textual change");
                }
                return filteredRevisions;
            }
        };


        abstract Collection<CrucibleRevision> filter(ContentManager var1, Source var2, Collection<CrucibleRevision> var3);
    }
}

