/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.crucible.spi.services.ReviewContentTooLargeException;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.source.PatchRevision;
import java.io.IOException;
import java.util.List;

public class PatchReviewCreationHelper {
    public static FileRevisionExtraInfo addPatchRevisionToReview(CrucibleRevision toRevision, Review review) {
        if (PatchRevision.fromCrucibleRevision((CrucibleRevision)toRevision).isFrom) {
            throw new IllegalArgumentException("Trying to add a from revision explicitly");
        }
        List<FileRevisionExtraInfo> pathFrxes = FRXManager.getFRExtraInfos(toRevision.getPath(), review, toRevision.getSourceName());
        FileRevisionExtraInfo frxToAddTo = null;
        block0: for (FileRevisionExtraInfo pathFrx : pathFrxes) {
            for (CrucibleRevision revision : pathFrx.getCrucibleRevisions()) {
                PatchRevision patchRevision = PatchRevision.fromCrucibleRevision(revision);
                if (patchRevision.isFrom || patchRevision.patchId == PatchRevision.fromCrucibleRevision((CrucibleRevision)toRevision).patchId) continue;
                frxToAddTo = pathFrx;
                continue block0;
            }
        }
        CrucibleRevision fromRevision = FileRevisionManager.findRevision(toRevision.getSourceName(), toRevision.getPath(), PatchRevision.fromCrucibleRevision(toRevision).getFromRevision().toString());
        if (fromRevision != null) {
            if (frxToAddTo == null) {
                frxToAddTo = review.addRevision(fromRevision);
            }
            frxToAddTo.addRevision(PatchReviewCreationHelper.findFrxIndex(frxToAddTo, toRevision), toRevision);
        } else if (frxToAddTo == null) {
            frxToAddTo = review.addRevision(toRevision);
            frxToAddTo.setShowAsDiff(false);
        } else {
            frxToAddTo.addRevision(PatchReviewCreationHelper.findFrxIndex(frxToAddTo, toRevision), toRevision);
        }
        return frxToAddTo;
    }

    private static int findFrxIndex(FileRevisionExtraInfo frxToAddTo, CrucibleRevision toRevision) {
        List<CrucibleRevision> frxRevisions = frxToAddTo.getCrucibleRevisions();
        long targetId = PatchRevision.fromCrucibleRevision((CrucibleRevision)toRevision).patchId;
        int index = 0;
        for (CrucibleRevision revision : frxRevisions) {
            PatchRevision patchRevision = PatchRevision.fromCrucibleRevision(revision);
            if (!patchRevision.isFrom && (long)patchRevision.patchId > targetId) break;
            ++index;
        }
        return index;
    }

    public static void addAllPatchRevsToReview(Patch patch, Review review, FecruUser user, NotificationManager notificationManager) throws FileRevisionException, ReviewContentTooLargeException {
        review.checkRoomForMoreContentExists();
        try {
            List<DiffRevisionsInfo> dris = patch.getDiffRevisions();
            for (DiffRevisionsInfo dri : dris) {
                FileRevisionExtraInfo frx = PatchReviewCreationHelper.addPatchRevisionToReview(patch.getFileRevisionFromDRI(dri), review);
                notificationManager.noteFRXRevisionAdded(review, frx.getFileFRXRevision(), user);
                LogManager.logReviewFrxAdded(review, user, frx);
            }
            patch.setAvailableForAdding(true);
        }
        catch (PatchException | IOException e2) {
            throw new FileRevisionException(e2);
        }
    }
}

