/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.fecru.util.EggTimer;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cache.RevisionIdentifier;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.ContentRoot;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.util.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

public class PatchAnchorHelper {
    private static final int ANCHOR_TIMEOUT_MILLIS = 10000;
    @VisibleForTesting
    static final String ONLY_ADDED_REVISION_ANCHOR_ERROR_MSG = "Patch contains added revisions only. You have to specify repository to which it should be anchored.";
    public static final PatchAnchorResult SOURCE_FIND_ERROR = PatchAnchorResult.error("Couldn't find source to anchor the patch");
    public static final String ANCHORED = "ANCHORED";
    public static final String ANCHORED_PATH = "ANCHORED_PATH";
    public static final String ANCHORED_REVISION = "ANCHORED_REV";
    public static final String ANCHORED_VALIDATED = "ANCHORED_VALIDATED";
    public static final Comparator<Pair<Path, Integer>> ROOTS_COMPARATOR = new Comparator<Pair<Path, Integer>>(){

        @Override
        public int compare(Pair<Path, Integer> p1, Pair<Path, Integer> p2) {
            int result = p2.getSecond().compareTo(p1.getSecond());
            if (result != 0) {
                return result;
            }
            return p1.getFirst().compareTo(p2.getFirst());
        }
    };
    private static final String FAILURE_PREFIX = "Crucible tried to anchor your patch to ";

    public void unanchorPatch(Patch patch) throws IOException, DbException {
        HibernateUtil.ensureTransaction();
        patch.setAnchored(false);
        patch.setAnchorPath(null);
        patch.setAnchorSource(null);
        patch.setStripCount(null);
        this.unanchorRevisions(patch, true);
    }

    private void unanchorRevisions(Patch patch, boolean invalidate) throws IOException, DbException {
        HibernateUtil.ensureTransaction();
        for (CrucibleRevision fr : patch.getFileRevisions()) {
            fr.getDetails().remove(ANCHORED);
            fr.getDetails().remove(ANCHORED_PATH);
            fr.getDetails().remove(ANCHORED_REVISION);
            if (invalidate) {
                fr.getDetails().remove(ANCHORED_VALIDATED);
                continue;
            }
            fr.getDetails().put(ANCHORED_VALIDATED, "true");
        }
    }

    private boolean isPatchContainingNewRevisionsOnly(Patch patch) {
        return patch.getFileRevisions().stream().allMatch(crucibleRevision -> crucibleRevision.isAdded());
    }

    public PatchAnchorResult anchorPatch(ContentManager contentManager, Patch patch, PatchSource patchSource, Source source) throws IOException {
        return this.anchorPatch(contentManager, patch, patchSource, source, null);
    }

    public PatchAnchorResult anchorPatch(ContentManager contentManager, Patch patch, PatchSource patchSource, Source source, EggTimer timer) throws IOException {
        if (!this.isSourceAvailable(source)) {
            return PatchAnchorResult.error(String.format("Can anchor patch by id %d to source %s", patch.getId(), source.getName()));
        }
        if (this.isPatchContainingNewRevisionsOnly(patch)) {
            patch.setAnchored(true);
            patch.setAnchorPath("");
            patch.setAnchorSource(source.getName());
            return PatchAnchorResult.success((RepositorySource)source);
        }
        return this.findSourceAndAnchorPatch(contentManager, patch, patchSource, Collections.singletonList(source), timer, Optional.empty());
    }

    public PatchAnchorResult findSourceAndAnchorPatch(ContentManager contentManager, Patch patch, PatchSource patchSource, Iterable<Source> sources, EggTimer timer, Optional<Source> maybePrimarySource) throws IOException {
        PatchAnchorResult attemptedAnchor = null;
        if (this.isPatchContainingNewRevisionsOnly(patch)) {
            return PatchAnchorResult.error(ONLY_ADDED_REVISION_ANCHOR_ERROR_MSG);
        }
        ImmutableSortedSet sortedSources = maybePrimarySource.isPresent() ? ImmutableSortedSet.copyOf((Comparator)new SourceRelevanceComparator(patch, maybePrimarySource.get()), sources) : sources;
        for (Source source : sortedSources) {
            if (!this.isSourceAvailable(source)) continue;
            AnchorCandidate candidate = this.getBestAnchorCandidateForRepo((RepositorySource)source, patch, timer);
            if (candidate != null) {
                attemptedAnchor = this.anchorPatchRevisions(contentManager, patch, patchSource, candidate.anchorSource, candidate.stripCount, candidate.anchorPath);
                if (attemptedAnchor.worked) break;
            }
            if (timer == null || !timer.isTimeExpired()) continue;
            break;
        }
        if (attemptedAnchor != null && attemptedAnchor.worked) {
            return attemptedAnchor;
        }
        if (timer == null || !timer.isTimeExpired()) {
            return attemptedAnchor == null ? PatchAnchorResult.error(PatchAnchorHelper.getNoPathsMessage(Iterables.size((Iterable)sortedSources) == 1 ? (Source)Iterables.getOnlyElement((Iterable)sortedSources) : null)) : attemptedAnchor;
        }
        if (attemptedAnchor == null) {
            return PatchAnchorResult.timeOut(null, PatchAnchorHelper.getTimedOutMessage(null));
        }
        return PatchAnchorResult.timeOut(attemptedAnchor.anchorSource, PatchAnchorHelper.getTimedOutMessage(attemptedAnchor.anchorSource));
    }

    private boolean isSourceAvailable(Source source) {
        return source instanceof RepositorySource && source.isAvailable();
    }

    private AnchorCandidate getBestAnchorCandidateForRepo(RepositorySource source, Patch patch, EggTimer eggTimer) throws IOException {
        RevisionCache<? extends ChangeSet> revisionCache = source.getRepoEngine().getRevisionCache();
        Pair<Integer, Map<Path, Integer>> rootsPair = source.getRootPaths(patch, eggTimer);
        int stripCount = rootsPair.getFirst();
        long latest = 0L;
        int matchedPaths = 0;
        AnchorCandidate bestCandidate = null;
        for (Path root : rootsPair.getSecond().keySet()) {
            long date;
            int currentMatchedPaths = rootsPair.getSecond().get(root);
            if (currentMatchedPaths > matchedPaths) {
                latest = this.getDateFor(root, revisionCache);
                matchedPaths = currentMatchedPaths;
                bestCandidate = new AnchorCandidate(source, root.toString(), stripCount);
            } else if (currentMatchedPaths == matchedPaths && currentMatchedPaths > 0 && (date = this.getDateFor(root, revisionCache)) > latest) {
                latest = date;
                bestCandidate = new AnchorCandidate(source, root.toString(), stripCount);
            }
            if (eggTimer == null || !eggTimer.isTimeExpired()) continue;
            return bestCandidate;
        }
        return bestCandidate;
    }

    private long getDateFor(Path path, RevisionCache<? extends ChangeSet> revisionCache) {
        DirInfo dirInfo = revisionCache.findDirInfo(path);
        if (dirInfo == null) {
            return -1L;
        }
        return (Long)dirInfo.getSubTreeDateRange().getMax().getOrElse((Object)-1L);
    }

    public PatchAnchorResult anchorPatchRevisions(ContentManager contentManager, Patch patch, PatchSource patchSource, RepositorySource anchorSource, int stripCount, String anchorPath) throws IOException {
        Path path;
        HashMap<Path, RevisionIdentifier> patchRevisions = new HashMap<Path, RevisionIdentifier>();
        for (CrucibleRevision fr : patch.getFileRevisions()) {
            boolean from = fr.getRevision().endsWith("F");
            DiffRevisionsInfo dri = patch.getDiffRevisionInfo(fr);
            if (!from || dri == null) continue;
            path = this.getAnchoredPath(dri.getPath(), anchorPath, stripCount);
            RevisionIdentifier revision = new RevisionIdentifier(dri.getFromRevisionName(), dri.getFromRevisionType());
            patchRevisions.put(path, revision);
        }
        Map<Path, String> revsForPaths = anchorSource.getRepoEngine().getRevisionCache().resolveRevisionsForPatch(patchRevisions);
        if (revsForPaths == null || revsForPaths.isEmpty()) {
            if (patch.isAnchored() && patch.getAnchorSource().equals(anchorSource.getName())) {
                this.unanchorRevisions(patch, false);
            }
            return PatchAnchorResult.error(anchorSource, PatchAnchorHelper.getNoRevisionsMessage(anchorSource, anchorPath));
        }
        HashMap<CrucibleRevision, CrucibleRevision> revsForFrs = new HashMap<CrucibleRevision, CrucibleRevision>();
        for (CrucibleRevision fr : patch.getFileRevisions()) {
            path = null;
            String revisionString = null;
            boolean from = fr.getRevision().endsWith("F");
            DiffRevisionsInfo dri = patch.getDiffRevisionInfo(fr);
            if (from && dri != null) {
                path = this.getAnchoredPath(dri.getPath(), anchorPath, stripCount);
                revisionString = revsForPaths.get(path);
            }
            if (revisionString == null) {
                if (path == null) continue;
                Logs.APP_LOG.debug((Object)("No revision found for patch at '" + path + "' for patch " + patch.getId()));
                continue;
            }
            CrucibleRevision candidateAnchor = contentManager.getCrucibleRevision(anchorSource, path.getPath(), revisionString);
            if (candidateAnchor == null) continue;
            boolean contentValid = false;
            try {
                contentValid = patchSource.validateAnchorContent(anchorSource, fr, candidateAnchor);
            }
            catch (Exception e2) {
                Logs.APP_LOG.debug((Object)("Anchoring to '" + anchorSource.getName() + "' found conflicts with patch contents"), (Throwable)e2);
            }
            if (!contentValid) {
                if (patch.isAnchored() && patch.getAnchorSource().equals(anchorSource.getName())) {
                    this.unanchorRevisions(patch, false);
                }
                return PatchAnchorResult.error(anchorSource, PatchAnchorHelper.getConflictMessage(anchorSource, path, revisionString));
            }
            revsForFrs.put(fr, candidateAnchor);
        }
        if (revsForFrs.isEmpty()) {
            if (patch.isAnchored() && patch.getAnchorSource().equals(anchorSource.getName())) {
                this.unanchorRevisions(patch, false);
            }
            return PatchAnchorResult.error(anchorSource, PatchAnchorHelper.getNoRevisionsMessage(anchorSource, anchorPath));
        }
        if (!anchorSource.isAvailable()) {
            return PatchAnchorResult.error(anchorSource, PatchAnchorHelper.getAnchorUnavailableMessage(anchorSource));
        }
        HibernateUtil.ensureTransaction();
        patch.setAnchored(true);
        patch.setAnchorSource(anchorSource.getName());
        patch.setStripCount(stripCount);
        patch.setAnchorPath(anchorPath);
        for (CrucibleRevision fr : patch.getFileRevisions()) {
            fr.getDetails().put(ANCHORED, "true");
            fr.getDetails().put(ANCHORED_VALIDATED, "true");
            CrucibleRevision anchorRevision = (CrucibleRevision)revsForFrs.get(fr);
            if (anchorRevision != null) {
                fr.getDetails().put(ANCHORED_PATH, anchorRevision.getPath());
                fr.getDetails().put(ANCHORED_REVISION, anchorRevision.getRevision());
                continue;
            }
            fr.getDetails().remove(ANCHORED_PATH);
            fr.getDetails().remove(ANCHORED_REVISION);
        }
        return PatchAnchorResult.success(anchorSource);
    }

    public String getAnchoredPath(String path, String anchorPath, int stripCount) {
        return new Path(anchorPath, new Path(path).trimFirst(stripCount)).getPath();
    }

    public Path getAnchoredPath(Path path, String anchorPath, int stripCount) {
        return new Path(this.getAnchoredPath(path.toString(), anchorPath, stripCount));
    }

    private static String getNoPathsMessage(Source anchorSource) {
        String message = anchorSource != null ? "Crucible tried to anchor your patch to '" + anchorSource.getDisplayName() + "', but did not find any matching paths." : "Crucible tried to anchor your patch to FishEye, but did not find matching paths in any repository.";
        return message;
    }

    private static String getNoRevisionsMessage(Source anchorSource, String anchorPath) {
        return "Crucible tried to anchor your patch to '" + anchorSource.getDisplayName() + "', but did not find any matching revisions" + (!new Path(anchorPath).isRoot() ? " under '" + anchorPath + "'" : "") + ".";
    }

    private static String getConflictMessage(Source anchorSource, Path path, String rev) {
        return "Crucible tried to anchor your patch to '" + anchorSource.getDisplayName() + "', but there was conflicting content in '" + path + "' at revision '" + rev + "'.";
    }

    private static String getAnchorUnavailableMessage(Source anchorSource) {
        String reason = anchorSource.getReason();
        if (Strings.isNullOrEmpty((String)reason)) {
            reason = "The repository is unavailable.";
        }
        return "Crucible tried to anchor your patch to '" + anchorSource.getDisplayName() + "', but failed. " + reason;
    }

    private static String getTimedOutMessage(Source anchorSource) {
        if (anchorSource != null) {
            return String.format("%s '%s', but the search for an anchor location took too long and was stopped.", FAILURE_PREFIX, anchorSource.getDisplayName());
        }
        return "The search for an anchor location took too long and was stopped.";
    }

    public boolean ensurePatchesValidated(SourceFactory sourceFactory, ContentManager contentManager, Iterable<Patch> patches, Principal principal) throws IOException {
        boolean updated = false;
        for (Patch patch : patches) {
            if (!patch.isAnchored()) continue;
            boolean validated = true;
            for (CrucibleRevision fr : patch.getFileRevisions()) {
                if ("true".equals(fr.getDetails().get(ANCHORED_VALIDATED))) continue;
                validated = false;
                break;
            }
            if (validated) continue;
            HibernateUtil.ensureTransaction();
            PatchSource patchSource = (PatchSource)sourceFactory.getSource("PATCH:" + patch.getId(), principal);
            RepositorySource anchorSource = (RepositorySource)sourceFactory.getSource(patch.getAnchorSource(), principal);
            if (anchorSource == null || patchSource == null || !anchorSource.isAvailable()) continue;
            this.anchorPatchRevisions(contentManager, patch, patchSource, anchorSource, patch.getStripCount(), patch.getAnchorPath());
            updated = true;
        }
        if (updated) {
            HibernateUtil.commitTransaction();
        }
        return updated;
    }

    private class SourceRelevanceComparator
    implements Comparator<Source> {
        private String primaryRepository = null;
        private HashSet<String> preferredRepositories = new HashSet();

        public SourceRelevanceComparator(Patch patch, Source primarySource) {
            Project p2 = patch.getReview().getProject();
            this.primaryRepository = primarySource == null ? p2.getDefaultRepositoryName() : primarySource.getName();
            for (ContentRoot cr : p2.getContentRoots()) {
                this.preferredRepositories.add(cr.getRepName());
            }
        }

        @Override
        public int compare(Source o1, Source o2) {
            return this.rank(o1.getName()) - this.rank(o2.getName());
        }

        private int rank(String name) {
            return this.primaryRepository != null && this.primaryRepository.equals(name) ? 1 : (this.preferredRepositories.contains(name) ? 2 : 3);
        }
    }

    public static class PatchAnchorResult {
        public final RepositorySource anchorSource;
        public final boolean worked;
        public final boolean timeExpired;
        public final String errorMsg;

        public PatchAnchorResult(RepositorySource anchorSource, boolean worked, boolean timeExpired, String errorMsg) {
            this.anchorSource = anchorSource;
            this.worked = worked;
            this.timeExpired = timeExpired;
            this.errorMsg = errorMsg;
        }

        public static PatchAnchorResult timeOut(RepositorySource anchorSource, String errorMsg) {
            return new PatchAnchorResult(anchorSource, false, true, errorMsg);
        }

        public static PatchAnchorResult error(String errorMsg) {
            return PatchAnchorResult.error(null, errorMsg);
        }

        public static PatchAnchorResult error(RepositorySource anchorSource, String errorMsg) {
            return new PatchAnchorResult(anchorSource, false, false, errorMsg);
        }

        public static PatchAnchorResult success(RepositorySource anchorSource) {
            return new PatchAnchorResult(anchorSource, true, false, null);
        }
    }

    private class AnchorCandidate {
        RepositorySource anchorSource;
        String anchorPath;
        int stripCount;

        public AnchorCandidate(RepositorySource anchorSource, String anchorPath, int stripCount) {
            this.anchorSource = anchorSource;
            this.anchorPath = anchorPath;
            this.stripCount = stripCount;
        }
    }
}

