/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;

public class LineRangeUtil {
    public static List<Integer> getLines(String lineRange) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(lineRange, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String s2 = stringTokenizer.nextToken();
            int sepIndex = s2.indexOf(45);
            if (sepIndex == -1) {
                lines.add(Integer.valueOf(s2));
                continue;
            }
            int start = Integer.parseInt(s2.substring(0, sepIndex));
            int end = Integer.parseInt(s2.substring(sepIndex + 1));
            for (int i2 = start; i2 <= end; ++i2) {
                lines.add(i2);
            }
        }
        return lines;
    }

    public static String filterLineString(String lines) {
        String newLines = lines.replaceAll("[^0-9,\\- ]", "");
        newLines = newLines.replaceAll("([0-9]) ([0-9])", "$1,$2");
        return newLines;
    }

    public static String generateLineRange(SortedSet<Integer> list) {
        StringBuilder lineRange = new StringBuilder("");
        Integer prev = null;
        boolean prevNotAdded = true;
        for (Integer currentline : list) {
            if (prev == null) {
                if (lineRange.length() != 0) {
                    lineRange.append(",");
                }
                lineRange.append(currentline);
                prev = currentline;
                prevNotAdded = false;
                continue;
            }
            if (currentline == prev + 1) {
                prev = currentline;
                prevNotAdded = true;
                continue;
            }
            if (prevNotAdded) {
                lineRange.append("-").append(prev);
            }
            lineRange.append(",").append(currentline);
            prev = currentline;
            prevNotAdded = false;
        }
        if (prev != null && prevNotAdded) {
            lineRange.append("-").append(prev);
        }
        return lineRange.toString();
    }
}

