/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import org.hibernate.Query;

public class HqlUtil {
    public static String whereBuilder(String currentClause, String newClause, String logic) {
        if (Strings.isNullOrEmpty((String)newClause)) {
            return currentClause;
        }
        return Strings.isNullOrEmpty((String)currentClause) ? "where " + newClause + " " : currentClause + logic + " " + newClause + " ";
    }

    public static String whereBuilder(String currentClause, String newClause, Operator operator) {
        return HqlUtil.whereBuilder(currentClause, newClause, operator.name());
    }

    public static Long getCountFromSet(Collection results) {
        if (!results.isEmpty()) {
            Object[] vals = results.toArray();
            return (Long)vals[0];
        }
        return 0L;
    }

    public static <T> T getFirstResultOrNull(Query q2) {
        List l2 = q2.list();
        if (l2.size() > 0) {
            return (T)l2.get(0);
        }
        return null;
    }

    public static String nestedWhereBuilder(String where, List<String> clauses, String logicOuter, String logicInner) {
        if (!clauses.isEmpty()) {
            StringBuilder nestedClauses = new StringBuilder();
            nestedClauses.append(" ( ");
            String logic = "";
            for (String clause : clauses) {
                nestedClauses.append(" ").append(logic).append(" ");
                nestedClauses.append(" ").append(clause).append(" ");
                logic = logicInner;
            }
            nestedClauses.append(" ) ");
            return HqlUtil.whereBuilder(where, nestedClauses.toString(), logicOuter);
        }
        return where;
    }

    public static enum Operator {
        AND,
        OR;

    }
}

