/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.fisheye.StoppableVisitor;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Query;

public class HqlBatchedInClauseHelper<S> {
    private final Query query;
    private final String parameter;
    private final Iterable<S> objects;

    public HqlBatchedInClauseHelper(Query query, String parameter, Iterable<S> objects) {
        this.query = query;
        this.parameter = parameter;
        this.objects = objects;
    }

    public void executeUpdate() {
        this.execute(new Predicate<Query>(){

            public boolean apply(Query partialQuery) {
                HibernateUtil.beginTransaction();
                partialQuery.executeUpdate();
                HibernateUtil.commitTransaction();
                return true;
            }
        });
    }

    public <T> void execute(final StoppableVisitor<T> visitor, final boolean useQueryIterator) {
        Preconditions.checkNotNull(visitor);
        this.execute(new Predicate<Query>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean apply(Query partialQuery) {
                Iterator it = useQueryIterator ? partialQuery.iterate() : partialQuery.list().iterator();
                try {
                    while (it.hasNext()) {
                        if (visitor.visit(it.next())) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    if (useQueryIterator) {
                        Hibernate.close(it);
                    }
                }
                return true;
            }
        });
    }

    public <T> List<T> executeAndFetchAll() {
        final ImmutableList.Builder resultBuilder = ImmutableList.builder();
        this.execute(new StoppableVisitor<T>(){

            @Override
            public boolean visit(T row) {
                resultBuilder.add(row);
                return true;
            }
        }, false);
        return resultBuilder.build();
    }

    private <T> void execute(Predicate<Query> continueQuerying) {
        for (List subList : Iterables.partition(this.objects, (int)CrucibleSysProps.SQL_IN_CLAUSE_SIZE_LIMIT)) {
            this.query.setParameterList(this.parameter, (Collection)subList);
            boolean keepIterating = continueQuerying.apply((Object)this.query);
            if (keepIterating) continue;
            return;
        }
    }
}

