/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.fisheye.AppConfig;
import java.util.ResourceBundle;

public class HelpUtil {
    private static final String HELP_URL_PREFIX_KEY = ".help.url.prefix";
    private static final String FISHEYE_HELP_URL_PREFIX_KEY = "fisheye.help.url.prefix";
    private static final String CRUCIBLE_HELP_URL_PREFIX_KEY = "crucible.help.url.prefix";

    private static String getHelpPathForPrefix(String prefix, String helpKey) {
        ResourceBundle bundle = HelpUtil.getHelpPathsBundle();
        String page = bundle.getString(helpKey);
        String pageLower = page.toLowerCase();
        if (pageLower.startsWith("http://") || pageLower.startsWith("https://")) {
            return page;
        }
        return String.format("%s/%s", prefix, bundle.getString(helpKey));
    }

    public static String getHelpPath(String urlKey, String helpKey) {
        return HelpUtil.getHelpPathForPrefix(HelpUtil.getHelpPathsBundle().getString(urlKey), helpKey);
    }

    protected static String getHelpPath(String key) {
        return HelpUtil.getHelpPathsBundle().getString(key);
    }

    public static String getDefaultHelpPathUrlPrefix() {
        if (AppConfig.isFishEyeOnly()) {
            return HelpUtil.getFishEyeHelpPathUrlPrefix();
        }
        return HelpUtil.getCrucibleHelpPathUrlPrefix();
    }

    public static String getFishEyeHelpPathUrlPrefix() {
        return HelpUtil.getHelpPath(FISHEYE_HELP_URL_PREFIX_KEY);
    }

    public static String getCrucibleHelpPathUrlPrefix() {
        return HelpUtil.getHelpPath(CRUCIBLE_HELP_URL_PREFIX_KEY);
    }

    public static String getFishEyeHelpPath(String helpKey) {
        return HelpUtil.getHelpPathForPrefix(HelpUtil.getFishEyeHelpPathUrlPrefix(), helpKey);
    }

    public static String getCrucibleHelpPath(String helpKey) {
        return HelpUtil.getHelpPathForPrefix(HelpUtil.getCrucibleHelpPathUrlPrefix(), helpKey);
    }

    protected static ResourceBundle getHelpPathsBundle() {
        return ResourceBundle.getBundle("help-paths");
    }
}

