/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.util.CheckinCommentFormatter;
import com.cenqua.fisheye.web.util.WikiMarkupFormatter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FreemarkerUtil {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("(\\r\\n|\\r|\\n)", 8);
    private static final String P_TAG_OPEN = "<p>";
    private static final String P_TAG_CLOSE = "</p>";
    private static final String STATIC_PATH = StringUtils.strip((String)"/currentstatic/", (String)"/");

    public static Map<String, Object> init() {
        HashMap<String, Object> root = new HashMap<String, Object>();
        try {
            BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
            TemplateHashModel avatarTypeInfo = (TemplateHashModel)wrapper.getStaticModels().get(AvatarTypeInfo.class.getName());
            TemplateHashModel stringUtil = (TemplateHashModel)wrapper.getStaticModels().get(StringUtil.class.getName());
            root.put("navBuilder", new NavBuilder());
            root.put("avatarTypeInfo", avatarTypeInfo);
            root.put("stringUtil", stringUtil);
            root.put("freemarkerUtil", new FreemarkerUtil());
            root.put("siteurl", AppConfig.getsConfig().getSiteURL());
            root.put("staticPath", STATIC_PATH);
        }
        catch (TemplateModelException e2) {
            Logs.APP_LOG.error((Object)"Exception initialising template attributes", (Throwable)e2);
        }
        return root;
    }

    public static String getCommentBgColor(boolean isNew, boolean isDefect) {
        if (isDefect && isNew) {
            return "#FFCCBF";
        }
        if (isDefect) {
            return "#FFE7DF";
        }
        if (isNew) {
            return "#FFF2A9";
        }
        return "#FFFFE7";
    }

    public static String getCommentBorder(boolean isNew, boolean isDefect) {
        String borderColor = isDefect ? "#B96F68" : "#ECE0B2";
        String borderWidth = isNew ? "2px" : "1px";
        return borderWidth + " solid " + borderColor;
    }

    public static FecruUser getAuthorForChangeset(ChangeSet cs) {
        return ((CommitterUserMappingManager)SpringContext.getComponent("committerUserMappingManager")).getUserForCommitter(cs.getRepName(), cs.getAuthor());
    }

    public static String formatChangesetComment(RepositoryConfig repCfg, ChangeSet changeset) {
        String text;
        try {
            text = CheckinCommentFormatter.format(repCfg, changeset.getComment(), changeset.getDateValue());
            text = FreemarkerUtil.stripParagraph(text);
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Could not render changeset comment. " + e2.getMessage()), (Throwable)e2);
            text = changeset.getComment();
        }
        return text;
    }

    public static String formatWikiText(String wikiText, String repository) {
        WikiMarkupFormatter formatter = new WikiMarkupFormatter();
        String text = formatter.formatText(wikiText, repository);
        return FreemarkerUtil.stripParagraph(text);
    }

    public static String formatWikiText(String wikiText, Review review) {
        WikiMarkupFormatter formatter = new WikiMarkupFormatter();
        String text = formatter.formatText(wikiText, review);
        return FreemarkerUtil.stripParagraph(text);
    }

    public static String formatWikiText(String wikiText) {
        WikiMarkupFormatter formatter = new WikiMarkupFormatter();
        String text = formatter.formatText(wikiText);
        return FreemarkerUtil.stripParagraph(text);
    }

    public static String newlinesToBrs(String text) {
        if (!Strings.isNullOrEmpty((String)text)) {
            text = NEWLINE_PATTERN.matcher(text).replaceAll("<br/>");
        }
        return text;
    }

    public static String newLinesToSpaces(String text) {
        if (!Strings.isNullOrEmpty((String)text)) {
            text = NEWLINE_PATTERN.matcher(text).replaceAll(" ");
        }
        return text;
    }

    @VisibleForTesting
    static String stripParagraph(String text) {
        if (!Strings.isNullOrEmpty((String)text) && text.startsWith(P_TAG_OPEN) && (text = text.trim()).endsWith(P_TAG_CLOSE)) {
            text = text.substring(P_TAG_OPEN.length(), text.length() - P_TAG_CLOSE.length());
        }
        return text;
    }

    public static String getAbbreviatedPath(Path path, int maxLength) {
        return path.abbreviate(maxLength).getPath();
    }

    public static String getAppVersion() {
        return new FisheyeVersionInfo().getReleaseNum();
    }
}

