/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FileRevisionToReviewMapper {
    private final Source source;
    private final Set<String> filesAlreadySearched = new HashSet<String>();
    private Multimap<String, Object[]> reviewsAndRevisionsForPaths = null;
    private final HashMap<RevInfoKey, Set<Review>> reviewMap = new HashMap();
    private List<String> paths;

    public FileRevisionToReviewMapper(Source source) {
        this.source = source;
    }

    public void seedPaths(List<String> paths) {
        if (paths != null) {
            this.paths = paths;
            this.reviewsAndRevisionsForPaths = null;
        }
    }

    public void seedKeys(Collection<RevInfoKey> keys) {
        if (keys != null) {
            ArrayList<String> paths = new ArrayList<String>();
            for (RevInfoKey key : keys) {
                paths.add(key.getPath().getPath());
            }
            this.seedPaths(paths);
        }
    }

    public Collection<Review> findReviewsForRevision(RevInfoKey rk) {
        this.doSearch(rk);
        HashSet result = this.reviewMap.get(rk);
        return result != null ? result : new HashSet();
    }

    private void doSearch(RevInfoKey rk) {
        String path = rk.getPath().getPath();
        if (this.filesAlreadySearched.contains(path)) {
            return;
        }
        if (this.reviewsAndRevisionsForPaths == null && this.paths != null) {
            this.reviewsAndRevisionsForPaths = FileRevisionManager.getReviewsAndRevisionsForPaths(this.source, this.paths);
        }
        this.filesAlreadySearched.add(path);
        List<Object[]> rs = null;
        if (this.reviewsAndRevisionsForPaths != null) {
            rs = this.reviewsAndRevisionsForPaths.get((Object)path);
        }
        if (rs == null) {
            rs = FileRevisionManager.getReviewsAndRevisionsForPath(this.source, path);
        }
        for (Object[] row : rs) {
            Review review = (Review)row[0];
            CrucibleRevision cruRev = (CrucibleRevision)row[1];
            Set<Review> reviews = this.reviewMap.get(cruRev.getRevInfoKey());
            if (reviews == null) {
                reviews = new LinkedHashSet<Review>();
                this.reviewMap.put(cruRev.getRevInfoKey(), reviews);
            }
            reviews.add(review);
        }
    }
}

