/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.crucible.model.Comment;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class EmailAllCommentsFormatter {
    private final String indentationString;
    private final int maxIndentationLevel;

    public EmailAllCommentsFormatter() {
        this("  ", 5);
    }

    public EmailAllCommentsFormatter(String indentationString, int maxIndentationLevel) {
        this.indentationString = indentationString;
        this.maxIndentationLevel = maxIndentationLevel;
    }

    public String indent(String string, int levels) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < Math.min(this.maxIndentationLevel, levels); ++i2) {
            buf.append(this.indentationString);
        }
        String prefix = buf.toString();
        return prefix + (string == null ? "" : string.replaceAll("\n", "\n" + prefix));
    }

    public String indentAndTruncate(String string, int levels, int maxChars) {
        String indented = this.indent(string, levels);
        if (indented.length() > maxChars) {
            return indented.substring(0, maxChars);
        }
        return indented;
    }

    public int getIndentationDepth(Comment comment) {
        return this.getIndentationDepth(comment.getReplyToComment(), 0);
    }

    private int getIndentationDepth(Comment comment, int depth) {
        if (depth < this.maxIndentationLevel && comment != null) {
            return this.getIndentationDepth(comment.getReplyToComment(), depth + 1);
        }
        return depth;
    }

    public String wrapAndPrefixAndIndent(Comment comment, int width, String prefix) {
        return this.wrapAndPrefixAndIndent(comment.getMessage(), this.getIndentationDepth(comment), width, prefix);
    }

    public String wrapAndPrefixAndIndent(String message, int depth, int width, String prefix) {
        int margin = depth * this.indentationString.length() + prefix.length();
        if (width <= margin) {
            throw new IllegalArgumentException("Specified width (" + width + ") insufficient. Need at least " + (margin + 1) + " for this level nested comment");
        }
        String wrappedAndPrefixed = prefix + Joiner.on((String)("\n" + prefix)).join(EmailAllCommentsFormatter.wrapDocument(message, width - margin));
        return this.indent(wrappedAndPrefixed, depth);
    }

    private static List<String> wrapDocument(String input, int width) {
        BufferedReader lineReader = new BufferedReader(new StringReader(input));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = lineReader.readLine()) != null) {
                lines.addAll(EmailAllCommentsFormatter.wrapLine(line, width));
            }
        }
        catch (IOException e2) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
        return lines;
    }

    @VisibleForTesting
    static List<String> wrapLine(String line, int width) {
        ArrayList<String> segments = new ArrayList<String>();
        while (line.length() > width) {
            int i2;
            int breakPoint = -1;
            for (i2 = width; i2 >= 0; --i2) {
                if (!Character.isWhitespace(line.charAt(i2))) continue;
                breakPoint = i2;
                break;
            }
            if (breakPoint < 0) {
                for (i2 = width; i2 < line.length(); ++i2) {
                    if (!Character.isWhitespace(line.charAt(i2))) continue;
                    breakPoint = i2;
                    break;
                }
            }
            if (breakPoint < 0) break;
            segments.add(EmailAllCommentsFormatter.trimEnd(line.substring(0, breakPoint)));
            line = EmailAllCommentsFormatter.trimStart(line.substring(breakPoint));
        }
        segments.add(line);
        return segments;
    }

    @VisibleForTesting
    static String trimStart(String string) {
        int pos;
        if (string.length() == 0) {
            return string;
        }
        for (pos = 0; pos < string.length() && Character.isWhitespace(string.charAt(pos)); ++pos) {
        }
        return string.substring(pos);
    }

    @VisibleForTesting
    static String trimEnd(String string) {
        int pos;
        if (string.length() == 0) {
            return string;
        }
        for (pos = string.length() - 1; pos >= 0 && Character.isWhitespace(string.charAt(pos)); --pos) {
        }
        return pos < 0 ? "" : string.substring(0, pos + 1);
    }
}

